/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jslee;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.security.auth.login.LoginException;
import javax.slee.ComponentID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.DeploymentMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.transfer.ContentResponseResult;
import org.rhq.core.domain.content.transfer.DeployPackageStep;
import org.rhq.core.domain.content.transfer.DeployPackagesResponse;
import org.rhq.core.domain.content.transfer.RemovePackagesResponse;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.content.ContentFacet;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.jslee.JainSleeServerComponent;
import org.rhq.plugins.jslee.utils.MBeanServerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployableUnitComponent
implements ResourceComponent<JainSleeServerComponent>,
OperationFacet,
DeleteResourceFacet,
ContentFacet {
    private final Log log = LogFactory.getLog(this.getClass());
    private ResourceContext<JainSleeServerComponent> resourceContext;
    private DeployableUnitID deployableUnitID = null;
    private MBeanServerUtils mbeanUtils = null;
    private ObjectName deploymentObjName;
    private String deployPathIdentifier;
    private String farmDeployPathIdentifier;

    public void start(ResourceContext<JainSleeServerComponent> context) throws InvalidPluginConfigurationException, Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("start(" + context + ") called."));
        }
        this.resourceContext = context;
        this.deploymentObjName = new ObjectName("javax.slee.management:name=Deployment");
        this.mbeanUtils = ((JainSleeServerComponent)context.getParentResourceComponent()).getMBeanServerUtils();
        String url = this.resourceContext.getPluginConfiguration().getSimple("url").getStringValue();
        this.deployableUnitID = new DeployableUnitID(url);
        this.deployPathIdentifier = ((JainSleeServerComponent)this.resourceContext.getParentResourceComponent()).getDeployFolderPath();
        this.farmDeployPathIdentifier = ((JainSleeServerComponent)this.resourceContext.getParentResourceComponent()).getFarmDeployFolderPath();
    }

    public void stop() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"stop() called.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvailabilityType getAvailability() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"getAvailability() called.");
        }
        try {
            MBeanServerConnection connection = this.mbeanUtils.getConnection();
            this.mbeanUtils.login();
            DeploymentMBean deploymentMBean = MBeanServerInvocationHandler.newProxyInstance(connection, this.deploymentObjName, DeploymentMBean.class, false);
            DeployableUnitDescriptor deployableUnitDescriptor = deploymentMBean.getDescriptor(this.deployableUnitID);
            deployableUnitDescriptor.getDeploymentDate();
        }
        catch (Exception e) {
            this.log.error((Object)("getAvailability failed for DeployableUnitID = " + this.deployableUnitID));
            AvailabilityType availabilityType = AvailabilityType.DOWN;
            return availabilityType;
        }
        finally {
            block13: {
                try {
                    this.mbeanUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block13;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
        return AvailabilityType.UP;
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("invokeOperation(" + name + ", " + parameters + ") called."));
        }
        if ("listComponents".equals(name)) {
            return this.doListComponents();
        }
        throw new UnsupportedOperationException("Operation [" + name + "] is not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteResource() throws Exception {
        if (this.deployableUnitID.getURL().contains(this.deployPathIdentifier.replaceAll("\\\\", "/"))) {
            if (!new File(new URL(this.deployableUnitID.getURL()).toURI()).delete()) {
                throw new IOException("File '" + this.deployableUnitID.getURL() + "' could not be deleted. Does it exists?");
            }
        } else if (this.deployableUnitID.getURL().contains(this.farmDeployPathIdentifier.replaceAll("\\\\", "/"))) {
            if (!new File(new URL(this.deployableUnitID.getURL()).toURI()).delete()) {
                throw new IOException("File '" + this.deployableUnitID.getURL() + "' could not be deleted. Does it exists?");
            }
        } else {
            try {
                MBeanServerConnection connection = this.mbeanUtils.getConnection();
                this.mbeanUtils.login();
                DeploymentMBean deploymentMBean = MBeanServerInvocationHandler.newProxyInstance(connection, this.deploymentObjName, DeploymentMBean.class, false);
                deploymentMBean.uninstall(this.deployableUnitID);
            }
            finally {
                block14: {
                    try {
                        this.mbeanUtils.logout();
                    }
                    catch (LoginException e) {
                        if (!this.log.isDebugEnabled()) break block14;
                        this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                    }
                }
            }
        }
    }

    public DeployPackagesResponse deployPackages(Set<ResourcePackageDetails> packages, ContentServices contentServices) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("deployPackages(" + packages + "," + contentServices + ") called."));
        }
        String resourceTypeName = this.resourceContext.getResourceType().getName();
        if (packages.size() != 1) {
            this.log.warn((Object)("Request to update " + resourceTypeName + " file contained multiple packages: " + packages));
            DeployPackagesResponse response = new DeployPackagesResponse(ContentResponseResult.FAILURE);
            response.setOverallRequestErrorMessage("Only one " + resourceTypeName + " can be updated at a time.");
            return response;
        }
        ResourcePackageDetails packageDetails = packages.iterator().next();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Updating DU file ' ' using [" + packageDetails + "]..."));
        }
        return null;
    }

    public Set<ResourcePackageDetails> discoverDeployedPackages(PackageType packageType) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("discoverDeployedPackages(" + packageType + ") called."));
        }
        return null;
    }

    public List<DeployPackageStep> generateInstallationSteps(ResourcePackageDetails arg0) {
        return null;
    }

    public RemovePackagesResponse removePackages(Set<ResourcePackageDetails> arg0) {
        return null;
    }

    public InputStream retrievePackageBits(ResourcePackageDetails arg0) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResult doListComponents() throws Exception {
        try {
            OperationResult result = new OperationResult();
            MBeanServerConnection connection = this.mbeanUtils.getConnection();
            this.mbeanUtils.login();
            DeploymentMBean deploymentMBean = MBeanServerInvocationHandler.newProxyInstance(connection, this.deploymentObjName, DeploymentMBean.class, false);
            DeployableUnitDescriptor deployableUnitDescriptor = deploymentMBean.getDescriptor(this.deployableUnitID);
            ComponentID[] components = deployableUnitDescriptor.getComponents();
            PropertyList columnList = new PropertyList("result");
            for (ComponentID componentID : components) {
                PropertyMap col = new PropertyMap("element");
                col.put((Property)new PropertySimple("Name", (Object)componentID.getName()));
                col.put((Property)new PropertySimple("Vendor", (Object)componentID.getVendor()));
                col.put((Property)new PropertySimple("Version", (Object)componentID.getVersion()));
                columnList.add((Property)col);
            }
            result.getComplexResults().put((Property)columnList);
            OperationResult operationResult = result;
            return operationResult;
        }
        finally {
            block8: {
                try {
                    this.mbeanUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block8;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }
}

