/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jslee;

import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.security.auth.login.LoginException;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.DeploymentMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jslee.JainSleeServerComponent;
import org.rhq.plugins.jslee.utils.MBeanServerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployableUnitDiscoveryComponent
implements ResourceDiscoveryComponent<JainSleeServerComponent> {
    private final Log log = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<JainSleeServerComponent> context) throws InvalidPluginConfigurationException, Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("discoverResources(" + context + ") called."));
        }
        HashSet<DiscoveredResourceDetails> discoveredDUs = new HashSet<DiscoveredResourceDetails>();
        MBeanServerUtils mbeanUtils = ((JainSleeServerComponent)context.getParentResourceComponent()).getMBeanServerUtils();
        try {
            DeployableUnitID[] deployableUnitIDs;
            MBeanServerConnection connection = mbeanUtils.getConnection();
            mbeanUtils.login();
            ObjectName deploymentmanagement = new ObjectName("javax.slee.management:name=Deployment");
            DeploymentMBean deploymentMBean = MBeanServerInvocationHandler.newProxyInstance(connection, deploymentmanagement, DeploymentMBean.class, false);
            for (DeployableUnitID deployableUnitID : deployableUnitIDs = deploymentMBean.getDeployableUnits()) {
                DeployableUnitDescriptor deployableUnitDescriptor = deploymentMBean.getDescriptor(deployableUnitID);
                String key = deployableUnitID.getURL();
                String[] elements = key.split(System.getProperty("file.separator").replaceAll("\\\\", "\\\\\\\\"));
                String lastElement = elements[elements.length - 1];
                String name = lastElement.substring(0, lastElement.lastIndexOf("."));
                String description = name + " -- Deployed on : " + deployableUnitDescriptor.getDeploymentDate();
                DiscoveredResourceDetails discoveredDu = new DiscoveredResourceDetails(context.getResourceType(), key, name, null, description, null, null);
                discoveredDu.getPluginConfiguration().put((Property)new PropertySimple("url", (Object)deployableUnitID.getURL()));
                discoveredDUs.add(discoveredDu);
            }
        }
        finally {
            block11: {
                try {
                    mbeanUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block11;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Discovered " + discoveredDUs.size() + " JAIN SLEE Deployable Unit Components."));
        }
        return discoveredDUs;
    }
}

