/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jslee;

import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.security.auth.login.LoginException;
import org.mobicents.slee.container.management.jmx.EventRouterConfigurationMBean;
import org.mobicents.slee.container.management.jmx.EventRouterStatisticsMBean;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.jmx.MBeanResourceComponent;
import org.rhq.plugins.jslee.JainSleeServerComponent;
import org.rhq.plugins.jslee.utils.JainSleeServerUtils;
import org.rhq.plugins.jslee.utils.MBeanServerUtils;

public class ExecutorComponent
extends MBeanResourceComponent {
    private ResourceContext<JainSleeServerComponent> resourceContext;
    volatile MBeanServerUtils mbeanUtils = null;
    Integer executorId = null;

    public void start(ResourceContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("start(" + context + ") called."));
        }
        this.resourceContext = context;
        this.executorId = this.resourceContext.getPluginConfiguration().getSimple("executorId").getIntegerValue();
        this.mbeanUtils = ((JainSleeServerUtils)context.getParentResourceComponent()).getMBeanServerUtils();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvailabilityType getAvailability() {
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)"getAvailability() called.");
            }
            MBeanServerConnection connection = this.mbeanUtils.getConnection();
            this.mbeanUtils.login();
            ObjectName erConfigObjectName = new ObjectName("org.mobicents.slee:name=EventRouterConfiguration");
            EventRouterConfigurationMBean erConfigMBean = MBeanServerInvocationHandler.newProxyInstance(connection, erConfigObjectName, EventRouterConfigurationMBean.class, false);
            AvailabilityType availabilityType = this.executorId < erConfigMBean.getEventRouterThreads() ? AvailabilityType.UP : AvailabilityType.DOWN;
            return availabilityType;
        }
        catch (Exception e) {
            log.debug((Object)("Failed to get Availability for Executor #" + this.executorId), (Throwable)e);
        }
        finally {
            block13: {
                try {
                    this.mbeanUtils.logout();
                }
                catch (LoginException e) {
                    if (!log.isDebugEnabled()) break block13;
                    log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
        return AvailabilityType.DOWN;
    }

    public void getValues(MeasurementReport report, Set requests) {
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("getValues(" + report + "," + requests + ") called."));
            }
            Set metrics = requests;
            EventRouterStatisticsMBean erStats = this.getEventRouterStatisticsMBean();
            for (MeasurementScheduleRequest request : metrics) {
                if (request.getName().equals("activitiesMapped")) {
                    report.addData(new MeasurementDataNumeric(request, Double.valueOf(erStats.getActivitiesMapped(this.executorId.intValue()))));
                    continue;
                }
                if (request.getName().equals("averageEventRoutingTime")) {
                    report.addData(new MeasurementDataNumeric(request, Double.valueOf(erStats.getAverageEventRoutingTime(this.executorId.intValue()))));
                    continue;
                }
                if (request.getName().equals("executedTasks")) {
                    report.addData(new MeasurementDataNumeric(request, Double.valueOf(erStats.getExecutedTasks(this.executorId.intValue()))));
                    continue;
                }
                if (request.getName().equals("executingTime")) {
                    report.addData(new MeasurementDataNumeric(request, Double.valueOf(erStats.getExecutingTime(this.executorId.intValue()))));
                    continue;
                }
                if (request.getName().equals("idleTime")) {
                    report.addData(new MeasurementDataNumeric(request, Double.valueOf(erStats.getIdleTime(this.executorId.intValue()))));
                    continue;
                }
                if (request.getName().equals("miscTasksExecuted")) {
                    report.addData(new MeasurementDataNumeric(request, Double.valueOf(erStats.getMiscTasksExecuted(this.executorId.intValue()))));
                    continue;
                }
                if (!request.getName().equals("miscTasksExecutingTime")) continue;
                report.addData(new MeasurementDataNumeric(request, Double.valueOf(erStats.getMiscTasksExecutingTime(this.executorId.intValue()))));
            }
        }
        catch (Exception e) {
            log.debug((Object)("Failure gathering values for Executor #" + this.executorId), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventRouterStatisticsMBean getEventRouterStatisticsMBean() throws Exception {
        try {
            EventRouterStatisticsMBean erStatsMBean;
            MBeanServerConnection connection = this.mbeanUtils.getConnection();
            this.mbeanUtils.login();
            ObjectName erStatsObjectName = new ObjectName("org.mobicents.slee:name=EventRouterStatistics");
            EventRouterStatisticsMBean eventRouterStatisticsMBean = erStatsMBean = MBeanServerInvocationHandler.newProxyInstance(connection, erStatsObjectName, EventRouterStatisticsMBean.class, false);
            return eventRouterStatisticsMBean;
        }
        finally {
            block7: {
                try {
                    this.mbeanUtils.logout();
                }
                catch (LoginException e) {
                    if (!log.isDebugEnabled()) break block7;
                    log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }
}

