/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jslee;

import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mobicents.slee.container.management.jmx.EventRouterConfigurationMBean;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jslee.JainSleeServerComponent;
import org.rhq.plugins.jslee.utils.MBeanServerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutorDiscoveryComponent
implements ResourceDiscoveryComponent<JainSleeServerComponent> {
    private final Log log = LogFactory.getLog(ExecutorDiscoveryComponent.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<JainSleeServerComponent> context) throws InvalidPluginConfigurationException, Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"ExecutorDiscoveryComponent.discoverResources() called");
        }
        HashSet<DiscoveredResourceDetails> discoveredExecutors = new HashSet<DiscoveredResourceDetails>();
        MBeanServerUtils mbeanUtils = ((JainSleeServerComponent)context.getParentResourceComponent()).getMBeanServerUtils();
        try {
            MBeanServerConnection connection = mbeanUtils.getConnection();
            mbeanUtils.login();
            ObjectName erConfigObjectName = new ObjectName("org.mobicents.slee:name=EventRouterConfiguration");
            EventRouterConfigurationMBean erConfigMBean = MBeanServerInvocationHandler.newProxyInstance(connection, erConfigObjectName, EventRouterConfigurationMBean.class, false);
            for (int executorId = 0; executorId < erConfigMBean.getEventRouterThreads(); ++executorId) {
                String key;
                String name = key = "Executor #" + executorId;
                String description = "Mobicents JAIN SLEE Event Router " + name;
                DiscoveredResourceDetails discoveredExecutor = new DiscoveredResourceDetails(context.getResourceType(), key, name, null, description, null, null);
                discoveredExecutor.getPluginConfiguration().put((Property)new PropertySimple("executorId", (Object)executorId));
                discoveredExecutors.add(discoveredExecutor);
            }
            HashSet<DiscoveredResourceDetails> hashSet = discoveredExecutors;
            return hashSet;
        }
        finally {
            block9: {
                try {
                    mbeanUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block9;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }
}

