/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jslee;

import java.util.Date;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.security.auth.login.LoginException;
import javax.slee.management.ResourceAdaptorEntityState;
import javax.slee.management.ResourceManagementMBean;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.ResourceAdaptorID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mobicents.slee.container.management.jmx.ActivityManagementMBeanImplMBean;
import org.mobicents.slee.container.management.jmx.JmxActivityContextHandle;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.jslee.ResourceAdaptorComponent;
import org.rhq.plugins.jslee.utils.JainSleeServerUtils;
import org.rhq.plugins.jslee.utils.MBeanServerUtils;
import org.rhq.plugins.jslee.utils.ResourceAdaptorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RAEntityComponent
implements ResourceAdaptorUtils,
ConfigurationFacet,
DeleteResourceFacet,
CreateChildResourceFacet,
OperationFacet,
MeasurementFacet {
    private final Log log = LogFactory.getLog(this.getClass());
    private ResourceContext<ResourceAdaptorComponent> resourceContext;
    private String raEntityName;
    private ResourceAdaptorID raId = null;
    private MBeanServerUtils mbeanUtils = null;
    private ConfigProperties configProperties = null;
    private ObjectName resourceManagement;

    public void start(ResourceContext context) throws InvalidPluginConfigurationException, Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("start(" + context + ") called."));
        }
        this.resourceContext = context;
        this.resourceManagement = new ObjectName("javax.slee.management:name=ResourceManagement");
        this.mbeanUtils = ((JainSleeServerUtils)context.getParentResourceComponent()).getMBeanServerUtils();
        String name = this.resourceContext.getPluginConfiguration().getSimple("name").getStringValue();
        String version = this.resourceContext.getPluginConfiguration().getSimple("version").getStringValue();
        String vendor = this.resourceContext.getPluginConfiguration().getSimple("vendor").getStringValue();
        this.raEntityName = this.resourceContext.getPluginConfiguration().getSimple("entityName").getStringValue();
        this.raId = new ResourceAdaptorID(name, vendor, version);
    }

    public void stop() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"stop() called.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvailabilityType getAvailability() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"getAvailability() called.");
        }
        try {
            MBeanServerConnection connection = this.mbeanUtils.getConnection();
            this.mbeanUtils.login();
            ResourceManagementMBean resourceManagementMBean = MBeanServerInvocationHandler.newProxyInstance(connection, this.resourceManagement, ResourceManagementMBean.class, false);
            this.configProperties = resourceManagementMBean.getConfigurationProperties(this.raEntityName);
        }
        catch (Exception e) {
            this.log.error((Object)("getAvailability failed for ResourceAdaptor Entity = " + this.raEntityName));
            AvailabilityType availabilityType = AvailabilityType.DOWN;
            return availabilityType;
        }
        finally {
            block13: {
                try {
                    this.mbeanUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block13;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
        return AvailabilityType.UP;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("getValues(" + report + "," + metrics + ") called."));
        }
        for (MeasurementScheduleRequest request : metrics) {
            if (request.getName().equals("state")) {
                report.addData(new MeasurementDataTrait(request, this.getState().toString()));
            }
            if (!request.getName().equals("activites")) continue;
            Object[] activities = this.getActivityContextID();
            report.addData(new MeasurementDataNumeric(request, Double.valueOf(activities == null ? 0.0 : (double)activities.length)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceAdaptorEntityState getState() throws Exception {
        try {
            MBeanServerConnection connection = this.mbeanUtils.getConnection();
            this.mbeanUtils.login();
            ResourceManagementMBean resourceManagementMBean = MBeanServerInvocationHandler.newProxyInstance(connection, this.resourceManagement, ResourceManagementMBean.class, false);
            ResourceAdaptorEntityState resourceAdaptorEntityState = resourceManagementMBean.getState(this.raEntityName);
            return resourceAdaptorEntityState;
        }
        finally {
            block7: {
                try {
                    this.mbeanUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block7;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getActivityContextID() throws Exception {
        try {
            Object[] activities;
            ObjectName actMana = new ObjectName("org.mobicents.slee:name=ActivityManagementMBean");
            MBeanServerConnection connection = this.mbeanUtils.getConnection();
            this.mbeanUtils.login();
            ActivityManagementMBeanImplMBean aciManagMBean = MBeanServerInvocationHandler.newProxyInstance(connection, actMana, ActivityManagementMBeanImplMBean.class, false);
            Object[] objectArray = activities = aciManagMBean.retrieveActivityContextIDByResourceAdaptorEntityName(this.raEntityName);
            return objectArray;
        }
        finally {
            block7: {
                try {
                    this.mbeanUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block7;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }

    public Configuration loadResourceConfiguration() throws Exception {
        Configuration config = new Configuration();
        config.put((Property)new PropertySimple("entityName", (Object)this.raEntityName));
        PropertyList columnList = new PropertyList("properties");
        for (ConfigProperties.Property confProp : this.configProperties.getProperties()) {
            PropertyMap col = new PropertyMap("propertyDefinition");
            col.put((Property)new PropertySimple("propertyName", (Object)confProp.getName()));
            col.put((Property)new PropertySimple("propertyType", (Object)confProp.getType()));
            col.put((Property)new PropertySimple("propertyValue", confProp.getValue()));
            columnList.add((Property)col);
        }
        config.put((Property)columnList);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateResourceConfiguration(ConfigurationUpdateReport configurationUpdateReport) {
        try {
            MBeanServerConnection connection = this.mbeanUtils.getConnection();
            this.mbeanUtils.login();
            ResourceManagementMBean resourceManagementMBean = MBeanServerInvocationHandler.newProxyInstance(connection, this.resourceManagement, ResourceManagementMBean.class, false);
            PropertyList propsList = configurationUpdateReport.getConfiguration().getList("properties");
            ConfigProperties cps = resourceManagementMBean.getConfigurationProperties(this.raEntityName);
            for (Property p : propsList.getList()) {
                PropertyMap pMap = (PropertyMap)p;
                String propName = ((PropertySimple)pMap.get("propertyName")).getStringValue();
                String propType = ((PropertySimple)pMap.get("propertyType")).getStringValue();
                String propValue = ((PropertySimple)pMap.get("propertyValue")).getStringValue();
                Object value = null;
                if (propType.equals("java.lang.String")) {
                    value = propValue;
                } else if (propType.equals("java.lang.Integer")) {
                    value = Integer.valueOf(propValue);
                } else if (propType.equals("java.lang.Long")) {
                    value = Long.valueOf(propValue);
                }
                ConfigProperties.Property cp = cps.getProperty(propName);
                if (value == null || cp == null || value.equals(cp.getValue())) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Changing property '" + propName + "' from value [" + cp.getValue() + "] to [" + value + "]."));
                }
                cp.setValue(value);
            }
            resourceManagementMBean.updateConfigurationProperties(this.raEntityName, cps);
            configurationUpdateReport.setStatus(ConfigurationUpdateStatus.SUCCESS);
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to update Resource Configuration.", (Throwable)e);
            configurationUpdateReport.setErrorMessageFromThrowable((Throwable)e);
            configurationUpdateReport.setStatus(ConfigurationUpdateStatus.FAILURE);
        }
        finally {
            block19: {
                try {
                    this.mbeanUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block19;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteResource() throws Exception {
        try {
            MBeanServerConnection connection = this.mbeanUtils.getConnection();
            this.mbeanUtils.login();
            ResourceManagementMBean resourceManagementMBean = MBeanServerInvocationHandler.newProxyInstance(connection, this.resourceManagement, ResourceManagementMBean.class, false);
            resourceManagementMBean.removeResourceAdaptorEntity(this.raEntityName);
        }
        finally {
            block8: {
                try {
                    this.mbeanUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block8;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }

    @Override
    public ResourceAdaptorID getResourceAdaptorID() {
        return this.raId;
    }

    @Override
    public MBeanServerUtils getMBeanServerUtils() {
        return this.mbeanUtils;
    }

    public String getRAEntityName() {
        return this.raEntityName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CreateResourceReport createResource(CreateResourceReport report) {
        try {
            Configuration configuration = report.getResourceConfiguration();
            String linkName = configuration.getSimple("linkName").getStringValue();
            MBeanServerConnection connection = this.mbeanUtils.getConnection();
            this.mbeanUtils.login();
            ResourceManagementMBean resourceManagementMBean = MBeanServerInvocationHandler.newProxyInstance(connection, this.resourceManagement, ResourceManagementMBean.class, false);
            report.setResourceKey(linkName);
            resourceManagementMBean.bindLinkName(this.raEntityName, linkName);
            report.setStatus(CreateResourceStatus.SUCCESS);
            report.setResourceName(linkName);
        }
        catch (Exception e) {
            this.log.error((Object)"Adding new ResourceAdaptor Entity failed ", (Throwable)e);
            report.setException((Throwable)e);
            report.setStatus(CreateResourceStatus.FAILURE);
        }
        finally {
            block12: {
                try {
                    this.mbeanUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block12;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
        return report;
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("invokeOperation(" + name + ", " + parameters + ") called."));
        }
        OperationResult result = new OperationResult();
        if ("changeRaEntityState".equals(name)) {
            result = this.doChangeRaEntityState(parameters);
        } else if ("listActivityContexts".equals(name)) {
            result = this.doListActivityContexts();
        } else {
            throw new UnsupportedOperationException("Operation [" + name + "] is not supported yet.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResult doChangeRaEntityState(Configuration parameters) throws Exception {
        try {
            String message = null;
            String action = parameters.getSimple("action").getStringValue();
            MBeanServerConnection connection = this.mbeanUtils.getConnection();
            this.mbeanUtils.login();
            ResourceManagementMBean resourceManagementMBean = MBeanServerInvocationHandler.newProxyInstance(connection, this.resourceManagement, ResourceManagementMBean.class, false);
            if ("activate".equals(action)) {
                resourceManagementMBean.activateResourceAdaptorEntity(this.raEntityName);
                message = "Successfully Activated Resource Adaptor Entity " + this.raEntityName;
            } else if ("deactivate".equals(action)) {
                resourceManagementMBean.deactivateResourceAdaptorEntity(this.raEntityName);
                message = "Successfully DeActivated Resource Adaptor Entity " + this.raEntityName;
            }
            OperationResult result = new OperationResult();
            result.getComplexResults().put((Property)new PropertySimple("result", (Object)message));
            OperationResult operationResult = result;
            return operationResult;
        }
        finally {
            block10: {
                try {
                    this.mbeanUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block10;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResult doListActivityContexts() throws Exception {
        try {
            MBeanServerConnection connection = this.mbeanUtils.getConnection();
            this.mbeanUtils.login();
            ObjectName actMana = new ObjectName("org.mobicents.slee:name=ActivityManagementMBean");
            ActivityManagementMBeanImplMBean aciManagMBean = MBeanServerInvocationHandler.newProxyInstance(connection, actMana, ActivityManagementMBeanImplMBean.class, false);
            Object[] activities = aciManagMBean.retrieveActivityContextIDByResourceAdaptorEntityName(this.raEntityName);
            PropertyList columnList = new PropertyList("result");
            if (activities != null) {
                for (Object obj : activities) {
                    Object[] tempObjects = (Object[])obj;
                    PropertyMap col = new PropertyMap("element");
                    Object tempObj = tempObjects[0];
                    PropertySimple activityHandle = new PropertySimple("ActivityHandle", (Object)(tempObj != null ? ((JmxActivityContextHandle)tempObj).getActivityHandleToString() : "-"));
                    col.put((Property)activityHandle);
                    col.put((Property)new PropertySimple("Class", tempObjects[1]));
                    tempObj = tempObjects[2];
                    Date d = new Date(Long.parseLong((String)tempObj));
                    col.put((Property)new PropertySimple("LastAccessTime", (Object)d));
                    tempObj = tempObjects[3];
                    col.put((Property)new PropertySimple("ResourceAdaptor", tempObj == null ? "-" : tempObj));
                    tempObj = tempObjects[4];
                    String[] strArr = (String[])tempObj;
                    StringBuffer sb = new StringBuffer();
                    for (String s : strArr) {
                        sb.append(s).append("; ");
                    }
                    col.put((Property)new PropertySimple("SbbAttachmentValue", (Object)sb.toString()));
                    tempObj = tempObjects[5];
                    sb = new StringBuffer();
                    for (String s : strArr = (String[])tempObj) {
                        sb.append(s).append("; ");
                    }
                    col.put((Property)new PropertySimple("NameBoundToValue", (Object)sb.toString()));
                    tempObj = tempObjects[6];
                    sb = new StringBuffer();
                    for (String s : strArr = (String[])tempObj) {
                        sb.append(s).append("; ");
                    }
                    col.put((Property)new PropertySimple("TimerValue", (Object)sb.toString()));
                    tempObj = tempObjects[7];
                    sb = new StringBuffer();
                    for (String s : strArr = (String[])tempObj) {
                        sb.append(s).append("; ");
                    }
                    col.put((Property)new PropertySimple("DataPropertyValue", (Object)sb.toString()));
                    columnList.add((Property)col);
                }
            }
            OperationResult result = new OperationResult();
            result.getComplexResults().put((Property)columnList);
            OperationResult operationResult = result;
            return operationResult;
        }
        finally {
            block13: {
                try {
                    this.mbeanUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block13;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }
}

