/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jslee;

import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.security.auth.login.LoginException;
import javax.slee.SbbID;
import javax.slee.management.ResourceManagementMBean;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.ResourceAdaptorID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.jslee.RAEntityComponent;
import org.rhq.plugins.jslee.utils.MBeanServerUtils;
import org.rhq.plugins.jslee.utils.ResourceAdaptorUtils;

public class RAEntityLinkComponent
implements ResourceAdaptorUtils,
DeleteResourceFacet,
OperationFacet {
    private final Log log = LogFactory.getLog(RAEntityLinkComponent.class);
    private ResourceContext<RAEntityComponent> resourceContext;
    private String raEntityLinkName;
    private String raEntityName;
    private ResourceAdaptorID raId = null;
    private MBeanServerUtils mbeanUtils = null;
    private SbbID[] boundSbbs = null;
    private ConfigProperties configProperties = null;
    private ObjectName resourceManagement;

    public ResourceAdaptorID getResourceAdaptorID() {
        return null;
    }

    public void start(ResourceContext context) throws InvalidPluginConfigurationException, Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("start(" + context + ") called."));
        }
        this.resourceContext = context;
        this.resourceManagement = new ObjectName("javax.slee.management:name=ResourceManagement");
        this.mbeanUtils = ((RAEntityComponent)context.getParentResourceComponent()).getMBeanServerUtils();
        this.raEntityLinkName = this.resourceContext.getPluginConfiguration().getSimple("linkName").getStringValue();
        this.raEntityName = ((RAEntityComponent)context.getParentResourceComponent()).getRAEntityName();
        this.raId = ((RAEntityComponent)context.getParentResourceComponent()).getResourceAdaptorID();
    }

    public void stop() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"stop() called.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvailabilityType getAvailability() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"getAvailability() called.");
        }
        try {
            MBeanServerConnection connection = this.mbeanUtils.getConnection();
            this.mbeanUtils.login();
            ResourceManagementMBean resourceManagementMBean = MBeanServerInvocationHandler.newProxyInstance(connection, this.resourceManagement, ResourceManagementMBean.class, false);
            this.boundSbbs = resourceManagementMBean.getBoundSbbs(this.raEntityLinkName);
        }
        catch (Exception e) {
            this.log.error((Object)("getAvailability failed for RAEntityLinkComponent Link = " + this.raEntityLinkName));
            AvailabilityType availabilityType = AvailabilityType.DOWN;
            return availabilityType;
        }
        finally {
            block13: {
                try {
                    this.mbeanUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block13;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
        return AvailabilityType.UP;
    }

    public MBeanServerUtils getMBeanServerUtils() {
        return this.mbeanUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteResource() throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"deleteResource() called.");
        }
        try {
            MBeanServerConnection connection = this.mbeanUtils.getConnection();
            this.mbeanUtils.login();
            ResourceManagementMBean resourceManagementMBean = MBeanServerInvocationHandler.newProxyInstance(connection, this.resourceManagement, ResourceManagementMBean.class, false);
            resourceManagementMBean.unbindLinkName(this.raEntityLinkName);
        }
        finally {
            block9: {
                try {
                    this.mbeanUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block9;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("invokeOperation(" + name + ", " + parameters + ") called."));
        }
        OperationResult result = new OperationResult();
        if (!"listBoundSbbs".equals(name)) {
            throw new UnsupportedOperationException("Operation [" + name + "] is not supported yet.");
        }
        result = this.doListBoundSBBs();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResult doListBoundSBBs() throws Exception {
        try {
            MBeanServerConnection connection = this.mbeanUtils.getConnection();
            this.mbeanUtils.login();
            ResourceManagementMBean resourceManagementMBean = MBeanServerInvocationHandler.newProxyInstance(connection, this.resourceManagement, ResourceManagementMBean.class, false);
            SbbID[] sbbIds = resourceManagementMBean.getBoundSbbs(this.raEntityLinkName);
            PropertyList columnList = new PropertyList("result");
            for (SbbID sbbID : sbbIds) {
                PropertyMap col = new PropertyMap("element");
                col.put((Property)new PropertySimple("SbbName", (Object)sbbID.getName()));
                col.put((Property)new PropertySimple("SbbVendeor", (Object)sbbID.getVendor()));
                col.put((Property)new PropertySimple("SbbVersion", (Object)sbbID.getVersion()));
                columnList.add((Property)col);
            }
            OperationResult result = new OperationResult();
            result.getComplexResults().put((Property)columnList);
            OperationResult operationResult = result;
            return operationResult;
        }
        finally {
            block8: {
                try {
                    this.mbeanUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block8;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }
}

