/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jslee;

import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.security.auth.login.LoginException;
import javax.slee.management.ResourceManagementMBean;
import javax.slee.resource.ResourceAdaptorID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jslee.RAEntityComponent;
import org.rhq.plugins.jslee.utils.MBeanServerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RAEntityLinkDiscoveryComponent
implements ResourceDiscoveryComponent<RAEntityComponent> {
    private final Log log = LogFactory.getLog(this.getClass());
    private String raEntityName;
    private ResourceAdaptorID raID;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<RAEntityComponent> context) throws InvalidPluginConfigurationException, Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"RAEntityLinkDiscoveryComponent.discoverResources() called");
        }
        HashSet<DiscoveredResourceDetails> discoveredLinks = new HashSet<DiscoveredResourceDetails>();
        MBeanServerUtils mbeanUtils = ((RAEntityComponent)context.getParentResourceComponent()).getMBeanServerUtils();
        try {
            String[] links;
            MBeanServerConnection connection = mbeanUtils.getConnection();
            mbeanUtils.login();
            ObjectName resourceManagement = new ObjectName("javax.slee.management:name=ResourceManagement");
            ResourceManagementMBean resourceManagementMBean = MBeanServerInvocationHandler.newProxyInstance(connection, resourceManagement, ResourceManagementMBean.class, false);
            this.raEntityName = ((RAEntityComponent)context.getParentResourceComponent()).getRAEntityName();
            this.raID = ((RAEntityComponent)context.getParentResourceComponent()).getResourceAdaptorID();
            for (String link : links = resourceManagementMBean.getLinkNames(this.raEntityName)) {
                String description = "Link : " + link + " For ResourceAdaptor Entity : " + this.raEntityName;
                DiscoveredResourceDetails discoveredEntity = new DiscoveredResourceDetails(context.getResourceType(), link, link + " Link", this.raID.getVersion(), description, null, null);
                discoveredEntity.getPluginConfiguration().put((Property)new PropertySimple("linkName", (Object)link));
                discoveredLinks.add(discoveredEntity);
            }
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Discovered " + discoveredLinks.size() + " JAIN SLEE Resource Adaptor Entity Link Components."));
            }
            HashSet<DiscoveredResourceDetails> hashSet = discoveredLinks;
            return hashSet;
        }
        finally {
            block10: {
                try {
                    mbeanUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block10;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }
}

