/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jslee;

import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.security.auth.login.LoginException;
import javax.slee.ComponentID;
import javax.slee.management.DeploymentMBean;
import javax.slee.management.ResourceManagementMBean;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.ResourceAdaptorDescriptor;
import javax.slee.resource.ResourceAdaptorID;
import javax.slee.resource.ResourceAdaptorTypeID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.plugins.jslee.JainSleeServerComponent;
import org.rhq.plugins.jslee.utils.JainSleeServerUtils;
import org.rhq.plugins.jslee.utils.MBeanServerUtils;
import org.rhq.plugins.jslee.utils.ResourceAdaptorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceAdaptorComponent
implements ResourceAdaptorUtils,
MeasurementFacet,
ConfigurationFacet,
CreateChildResourceFacet {
    private final Log log = LogFactory.getLog(this.getClass());
    private ResourceContext<JainSleeServerComponent> resourceContext;
    private ResourceAdaptorID raId = null;
    private MBeanServerUtils mbeanUtils = null;
    private ConfigProperties configProperties = null;
    private ObjectName resourceManagement;
    private ObjectName deploymentManagement;

    public void start(ResourceContext context) throws InvalidPluginConfigurationException, Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("start(" + context + ") called."));
        }
        this.resourceContext = context;
        this.resourceManagement = new ObjectName("javax.slee.management:name=ResourceManagement");
        this.deploymentManagement = new ObjectName("javax.slee.management:name=Deployment");
        this.mbeanUtils = ((JainSleeServerUtils)context.getParentResourceComponent()).getMBeanServerUtils();
        String name = this.resourceContext.getPluginConfiguration().getSimple("name").getStringValue();
        String version = this.resourceContext.getPluginConfiguration().getSimple("version").getStringValue();
        String vendor = this.resourceContext.getPluginConfiguration().getSimple("vendor").getStringValue();
        this.raId = new ResourceAdaptorID(name, vendor, version);
    }

    public void stop() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"stop() called.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvailabilityType getAvailability() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"getAvailability() called.");
        }
        try {
            MBeanServerConnection connection = this.mbeanUtils.getConnection();
            this.mbeanUtils.login();
            ResourceManagementMBean resourceManagementMBean = MBeanServerInvocationHandler.newProxyInstance(connection, this.resourceManagement, ResourceManagementMBean.class, false);
            this.configProperties = resourceManagementMBean.getConfigurationProperties(this.raId);
        }
        catch (Exception e) {
            this.log.error((Object)("getAvailability failed for ResourceAdaptorID = " + this.raId));
            AvailabilityType availabilityType = AvailabilityType.DOWN;
            return availabilityType;
        }
        finally {
            block13: {
                try {
                    this.mbeanUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block13;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
        return AvailabilityType.UP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("getValues(" + report + "," + metrics + ") called."));
        }
        try {
            MBeanServerConnection connection = this.mbeanUtils.getConnection();
            this.mbeanUtils.login();
            for (MeasurementScheduleRequest request : metrics) {
                if (request.getName().equals("entities")) {
                    ResourceManagementMBean resourceManagementMBean = MBeanServerInvocationHandler.newProxyInstance(connection, this.resourceManagement, ResourceManagementMBean.class, false);
                    String[] raEntities = resourceManagementMBean.getResourceAdaptorEntities(this.raId);
                    report.addData(new MeasurementDataNumeric(request, Double.valueOf(raEntities.length)));
                    continue;
                }
                if (!request.getName().equals("ratype")) continue;
                DeploymentMBean deploymentMBean = MBeanServerInvocationHandler.newProxyInstance(connection, this.deploymentManagement, DeploymentMBean.class, false);
                ResourceAdaptorTypeID[] raTypes = ((ResourceAdaptorDescriptor)deploymentMBean.getDescriptor((ComponentID)this.raId)).getResourceAdaptorTypes();
                String raTypesString = "";
                for (ResourceAdaptorTypeID raTypeId : raTypes) {
                    raTypesString = raTypesString + raTypeId + "; ";
                }
                report.addData(new MeasurementDataTrait(request, raTypesString));
            }
        }
        finally {
            block12: {
                try {
                    this.mbeanUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block12;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }

    @Override
    public ResourceAdaptorID getResourceAdaptorID() {
        return this.raId;
    }

    @Override
    public MBeanServerUtils getMBeanServerUtils() {
        return this.mbeanUtils;
    }

    public Configuration loadResourceConfiguration() throws Exception {
        Configuration config = new Configuration();
        PropertyList columnList = new PropertyList("properties");
        for (ConfigProperties.Property confProp : this.configProperties.getProperties()) {
            PropertyMap col = new PropertyMap("propertyDefinition");
            col.put((Property)new PropertySimple("propertyName", (Object)confProp.getName()));
            col.put((Property)new PropertySimple("propertyType", (Object)confProp.getType()));
            col.put((Property)new PropertySimple("propertyValue", confProp.getValue()));
            columnList.add((Property)col);
        }
        config.put((Property)columnList);
        return config;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport arg0) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CreateResourceReport createResource(CreateResourceReport report) {
        try {
            Configuration configuration = report.getResourceConfiguration();
            String entityName = configuration.getSimple("entityName").getStringValue();
            PropertyList columnList = configuration.getList("properties");
            ConfigProperties props = new ConfigProperties();
            for (Property c : columnList.getList()) {
                PropertyMap column = (PropertyMap)c;
                String propName = column.getSimple("propertyName").getStringValue();
                String propType = column.getSimple("propertyType").getStringValue();
                String propValue = column.getSimple("propertyValue").getStringValue();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Property (name=" + propName + ", type=" + propType + ", value=" + propValue + ")"));
                }
                Object value = null;
                if (propType.equals("java.lang.String")) {
                    value = propValue;
                } else if (propType.equals("java.lang.Integer")) {
                    value = Integer.valueOf(propValue);
                } else if (propType.equals("java.lang.Long")) {
                    value = Long.valueOf(propValue);
                }
                ConfigProperties.Property p = new ConfigProperties.Property(propName, propType, value);
                props.addProperty(p);
            }
            MBeanServerConnection connection = this.mbeanUtils.getConnection();
            this.mbeanUtils.login();
            ResourceManagementMBean resourceManagementMBean = MBeanServerInvocationHandler.newProxyInstance(connection, this.resourceManagement, ResourceManagementMBean.class, false);
            report.setResourceKey(entityName);
            resourceManagementMBean.createResourceAdaptorEntity(this.raId, entityName, props);
            report.setStatus(CreateResourceStatus.SUCCESS);
            report.setResourceName(entityName);
        }
        catch (Exception e) {
            this.log.error((Object)"Adding new ResourceAdaptor Entity failed ", (Throwable)e);
            report.setException((Throwable)e);
            report.setStatus(CreateResourceStatus.FAILURE);
        }
        finally {
            block19: {
                try {
                    this.mbeanUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block19;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
        return report;
    }
}

