/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jslee;

import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.security.auth.login.LoginException;
import javax.slee.management.ResourceManagementMBean;
import javax.slee.resource.ResourceAdaptorID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jslee.ResourceAdaptorComponent;
import org.rhq.plugins.jslee.utils.MBeanServerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RAEntityDiscoveryComponent
implements ResourceDiscoveryComponent<ResourceAdaptorComponent> {
    private final Log log = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<ResourceAdaptorComponent> context) throws InvalidPluginConfigurationException, Exception {
        MBeanServerUtils mbeanUtils = ((ResourceAdaptorComponent)context.getParentResourceComponent()).getMBeanServerUtils();
        try {
            String[] raEntities;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"RAEntityDiscoveryComponent.discoverResources() called");
            }
            HashSet<DiscoveredResourceDetails> discoveredRAEntities = new HashSet<DiscoveredResourceDetails>();
            MBeanServerConnection connection = mbeanUtils.getConnection();
            mbeanUtils.login();
            ObjectName resourceManagement = new ObjectName("javax.slee.management:name=ResourceManagement");
            ResourceManagementMBean resourceManagementMBean = MBeanServerInvocationHandler.newProxyInstance(connection, resourceManagement, ResourceManagementMBean.class, false);
            ResourceAdaptorID raID = ((ResourceAdaptorComponent)context.getParentResourceComponent()).getResourceAdaptorID();
            for (String entityName : raEntities = resourceManagementMBean.getResourceAdaptorEntities(raID)) {
                String description = "RA Entity : " + entityName + " For ResourceAdaptor : " + raID.toString();
                DiscoveredResourceDetails discoveredEntity = new DiscoveredResourceDetails(context.getResourceType(), entityName, entityName + " Entity", raID.getVersion(), description, null, null);
                discoveredEntity.getPluginConfiguration().put((Property)new PropertySimple("entityName", (Object)entityName));
                discoveredEntity.getPluginConfiguration().put((Property)new PropertySimple("name", (Object)raID.getName()));
                discoveredEntity.getPluginConfiguration().put((Property)new PropertySimple("version", (Object)raID.getVersion()));
                discoveredEntity.getPluginConfiguration().put((Property)new PropertySimple("vendor", (Object)raID.getVendor()));
                discoveredRAEntities.add(discoveredEntity);
            }
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Discovered " + discoveredRAEntities.size() + " JAIN SLEE Resource Adaptor Entity Components."));
            }
            HashSet<DiscoveredResourceDetails> hashSet = discoveredRAEntities;
            return hashSet;
        }
        finally {
            block10: {
                try {
                    mbeanUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block10;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }
}

