/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jslee;

import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.security.auth.login.LoginException;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.management.ServiceUsageMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jslee.ServiceSbbComponent;
import org.rhq.plugins.jslee.utils.MBeanServerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceSbbUsageParameterSetDiscoveryComponent
implements ResourceDiscoveryComponent<ServiceSbbComponent> {
    private final Log log = LogFactory.getLog(ServiceSbbUsageParameterSetDiscoveryComponent.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<ServiceSbbComponent> context) throws InvalidPluginConfigurationException, Exception {
        MBeanServerUtils mbeanUtils = ((ServiceSbbComponent)context.getParentResourceComponent()).getMBeanServerUtils();
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"RAEntityDiscoveryComponent.discoverResources() called");
            }
            HashSet<DiscoveredResourceDetails> discoveredUsageParameterSets = new HashSet<DiscoveredResourceDetails>();
            MBeanServerConnection connection = mbeanUtils.getConnection();
            mbeanUtils.login();
            ServiceID serviceId = ((ServiceSbbComponent)context.getParentResourceComponent()).getServiceID();
            ObjectName serviceUsageON = new ObjectName("javax.slee.management.usage:type=ServiceUsage,serviceName=" + ObjectName.quote(serviceId.getName()) + ',' + "serviceVendor" + '=' + ObjectName.quote(serviceId.getVendor()) + ',' + "serviceVersion" + '=' + ObjectName.quote(serviceId.getVersion()));
            ServiceUsageMBean serviceUsageMBean = MBeanServerInvocationHandler.newProxyInstance(connection, serviceUsageON, ServiceUsageMBean.class, false);
            SbbID sbbId = ((ServiceSbbComponent)context.getParentResourceComponent()).getSbbID();
            String[] usageParameterSets = serviceUsageMBean.getUsageParameterSets(sbbId);
            String defaultDescription = "Usage Parameter Set : <default> for " + sbbId + " @\u00d4\u00f8\u03a9" + serviceId;
            String defaultKey = "<default>@" + sbbId + "@" + serviceId;
            DiscoveredResourceDetails defaultDiscoveredEntity = new DiscoveredResourceDetails(context.getResourceType(), defaultKey, "<default> Usage Paramaters Set", sbbId.getVersion(), defaultDescription, null, null);
            defaultDiscoveredEntity.getPluginConfiguration().put((Property)new PropertySimple("usageParameterSet", (Object)"<default>"));
            defaultDiscoveredEntity.getPluginConfiguration().put((Property)new PropertySimple("name", (Object)sbbId.getName()));
            defaultDiscoveredEntity.getPluginConfiguration().put((Property)new PropertySimple("version", (Object)sbbId.getVersion()));
            defaultDiscoveredEntity.getPluginConfiguration().put((Property)new PropertySimple("vendor", (Object)sbbId.getVendor()));
            discoveredUsageParameterSets.add(defaultDiscoveredEntity);
            for (String usageParameterSet : usageParameterSets) {
                String description = "Usage Parameter Set : " + usageParameterSet + " for " + sbbId + " @\u00d4\u00f8\u03a9" + serviceId;
                String key = usageParameterSet + "@" + sbbId + "@" + serviceId;
                DiscoveredResourceDetails discoveredEntity = new DiscoveredResourceDetails(context.getResourceType(), key, usageParameterSet + " Usage Paramaters Set", sbbId.getVersion(), description, null, null);
                discoveredEntity.getPluginConfiguration().put((Property)new PropertySimple("usageParameterSet", (Object)usageParameterSet));
                discoveredEntity.getPluginConfiguration().put((Property)new PropertySimple("name", (Object)sbbId.getName()));
                discoveredEntity.getPluginConfiguration().put((Property)new PropertySimple("version", (Object)sbbId.getVersion()));
                discoveredEntity.getPluginConfiguration().put((Property)new PropertySimple("vendor", (Object)sbbId.getVendor()));
                discoveredUsageParameterSets.add(discoveredEntity);
            }
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Discovered " + discoveredUsageParameterSets.size() + " JAIN SLEE Usage Parameter Sets for " + sbbId + " @\u00d4\u00f8\u03a9" + serviceId + "."));
            }
            HashSet<DiscoveredResourceDetails> hashSet = discoveredUsageParameterSets;
            return hashSet;
        }
        finally {
            block10: {
                try {
                    mbeanUtils.logout();
                }
                catch (LoginException e) {
                    if (!this.log.isDebugEnabled()) break block10;
                    this.log.debug((Object)"Failed to logout from secured JMX", (Throwable)e);
                }
            }
        }
    }
}

