/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management.console.client.common;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.mobicents.slee.container.management.console.client.common.BrowseContainer;

public class BrowseContainer
extends Composite {
    private static int MAX_BREADCRUMB_LINKS = 3;
    private boolean showAllLinks = false;
    private ArrayList<Widget> panels = new ArrayList();
    private ArrayList<BrowseLink> links = new ArrayList();
    private VerticalPanel rootPanel = new VerticalPanel();

    public BrowseContainer() {
        this.initWidget((Widget)this.rootPanel);
        this.setStyleName("common-BrowseContainer");
    }

    public void add(String title, Widget widget) {
        this.panels.add(widget);
        this.links.add(new BrowseLink(this, this, this.links.size(), title));
        this.refresh();
    }

    private void refresh() {
        this.rootPanel.clear();
        this.refreshLinks();
        this.refreshTitle();
        this.refreshPanel();
    }

    private void refreshLinks() {
        if (this.links.size() <= 1) {
            return;
        }
        HorizontalPanel header = new HorizontalPanel();
        header.setStyleName("common-BrowseContainer-links");
        header.setSpacing(5);
        header.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        int firstLink = 0;
        if (!this.showAllLinks && (firstLink = Math.max(0, this.links.size() - MAX_BREADCRUMB_LINKS)) > 0) {
            MenuBar hiddenMenu = new MenuBar();
            MenuBar subMenu = new MenuBar(true);
            for (int q = firstLink - 1; q >= 0; --q) {
                int fq = q;
                1 cmd = new /* Unavailable Anonymous Inner Class!! */;
                BrowseLink link = (BrowseLink)this.links.get(q);
                subMenu.addItem(link.getTitle(), (Command)cmd);
            }
            MenuItem root = new MenuItem("History", subMenu);
            hiddenMenu.addItem(root);
            header.add((Widget)hiddenMenu);
            header.add((Widget)new Image("images/chain.separator.gif"));
        }
        for (int i = firstLink; i <= this.links.size() - 1; ++i) {
            BrowseLink link = (BrowseLink)this.links.get(i);
            this.shortifyAndAddLink(header, link);
            if (i != this.links.size() - 1) {
                header.add((Widget)new Image("images/chain.separator.gif"));
                ((BrowseLink)this.links.get(i)).setStyle(false);
                continue;
            }
            ((BrowseLink)this.links.get(i)).setStyle(true);
        }
        this.rootPanel.add((Widget)header);
    }

    private void shortifyAndAddLink(HorizontalPanel header, BrowseLink link) {
        String linkText = link.getText();
        String linkTitle = link.getTitle();
        String shortLinkText = linkText;
        if (linkText.contains("[name=")) {
            link.setTitle(linkText);
            String compType = linkText.substring(0, linkText.indexOf("["));
            String compName = this.substring(linkText, "[name=", true, ",vendor=", true);
            String compVend = this.substring(linkText, ",vendor=", true, ",version=", true);
            String compVers = this.substring(linkText, ",version=", true, "]", true);
            if (compName.length() > 50) {
                compName = compName.substring(0, 9) + ".." + compName.substring(compName.length() - 29);
            }
            if (compVend.length() > 50) {
                compVend = compVend.substring(0, 9) + ".." + compVend.substring(compVend.length() - 29);
            }
            if (compVers.length() > 50) {
                compVers = compVers.substring(0, 9) + ".." + compVers.substring(compVers.length() - 29);
            }
            this.addComponentImage(header, compType);
            shortLinkText = compName + " / " + compVend + " / " + compVers;
            link.setText(shortLinkText);
        } else if (linkText.contains("[url=")) {
            link.setTitle(linkText);
            String compType = linkText.substring(0, linkText.indexOf("["));
            shortLinkText = linkText.substring(0, linkText.lastIndexOf(".jar"));
            shortLinkText = shortLinkText.substring(shortLinkText.lastIndexOf("/") + 1, shortLinkText.length());
            if (shortLinkText.length() > 50) {
                shortLinkText = shortLinkText.substring(0, 19) + ".." + shortLinkText.substring(shortLinkText.length() - 19);
            }
            link.setText(shortLinkText);
            this.addComponentImage(header, compType);
        } else if (linkTitle.contains("[name=") || linkTitle.contains("[url=")) {
            String compType = linkTitle.substring(0, linkTitle.indexOf("["));
            this.addComponentImage(header, compType);
        }
        header.add((Widget)link);
    }

    private void addComponentImage(HorizontalPanel header, String componentType) {
        if (componentType.equals("EventTypeID")) {
            header.add((Widget)new Image("images/components.event type.gif"));
        } else if (componentType.equals("LibraryID")) {
            header.add((Widget)new Image("images/components.library.gif"));
        } else if (componentType.equals("ResourceAdaptorID")) {
            header.add((Widget)new Image("images/components.resource adaptor.gif"));
        } else if (componentType.equals("ResourceAdaptorTypeID")) {
            header.add((Widget)new Image("images/components.resource adaptor type.gif"));
        } else if (componentType.equals("ProfileSpecificationID")) {
            header.add((Widget)new Image("images/components.profile specification.gif"));
        } else if (componentType.equals("SbbID")) {
            header.add((Widget)new Image("images/components.sbb.gif"));
        } else if (componentType.equals("ServiceID")) {
            header.add((Widget)new Image("images/components.service.gif"));
        } else if (componentType.equals("DeployableUnitID")) {
            header.add((Widget)new Image("images/deployableunits.deployableunit.gif"));
        }
    }

    private String substring(String original, String beginString, boolean excludeBegin, String endString, boolean excludeEnd) {
        return original.substring(original.indexOf(beginString) + (excludeBegin ? beginString.length() : 0), original.indexOf(endString) + (excludeEnd ? 0 : endString.length()));
    }

    private void refreshTitle() {
        if (this.links.size() > 0) {
            Label title = new Label(((BrowseLink)this.links.get(this.links.size() - 1)).getTitle());
            title.setStyleName("common-BrowseContainer-title");
            this.rootPanel.add((Widget)title);
        }
    }

    private void refreshPanel() {
        if (this.panels.size() > 0 && this.panels.get(this.panels.size() - 1) != null) {
            this.rootPanel.add((Widget)this.panels.get(this.panels.size() - 1));
        }
    }

    protected void select(int index) {
        if (index >= this.panels.size()) {
            return;
        }
        while (index + 1 < this.panels.size()) {
            this.panels.remove(index + 1);
            this.links.remove(index + 1);
        }
        this.refresh();
    }

    public void back() {
        if (this.panels.size() <= 1) {
            return;
        }
        this.select(this.panels.size() - 2);
    }

    public void empty() {
        this.panels.clear();
        this.links.clear();
        this.refresh();
    }

    public void setTitle(Widget widget, String title) {
        for (int i = 0; i < this.panels.size(); ++i) {
            if ((Widget)this.panels.get(i) != widget) continue;
            ((BrowseLink)this.links.get(i)).setText(title);
            this.refresh();
            return;
        }
    }
}

