/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.control.mgcp;

import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.message.DeleteConnection;
import jain.protocol.ip.mgcp.message.DeleteConnectionResponse;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.util.List;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.slee.ActivityContextInterface;
import javax.slee.CreateException;
import javax.slee.FactoryException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.TransactionRequiredLocalException;
import javax.slee.UnrecognizedActivityException;
import javax.slee.facilities.ActivityContextNamingFacility;
import javax.slee.facilities.FacilityException;
import javax.slee.facilities.NameNotBoundException;
import net.java.slee.resource.mgcp.JainMgcpProvider;
import net.java.slee.resource.mgcp.MgcpActivityContextInterfaceFactory;
import net.java.slee.resource.mgcp.MgcpConnectionActivity;
import org.apache.log4j.Logger;
import org.mobicents.mscontrol.MsConnection;
import org.mobicents.mscontrol.MsConnectionEvent;
import org.mobicents.mscontrol.MsProvider;
import org.mobicents.slee.resource.media.ratype.MediaRaActivityContextInterfaceFactory;

public abstract class DeleteConnectionSbb
implements Sbb {
    private SbbContext sbbContext;
    private static final Logger logger = Logger.getLogger(DeleteConnectionSbb.class);
    private JainMgcpProvider mgcpProvider;
    private MgcpActivityContextInterfaceFactory mgcpAcif;
    private MsProvider msProvider;
    private MediaRaActivityContextInterfaceFactory msActivityFactory;
    private ActivityContextNamingFacility activityContextNamingfacility;

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = sbbContext;
        try {
            Context ctx = (Context)new InitialContext().lookup("java:comp/env");
            this.msProvider = (MsProvider)ctx.lookup("slee/resources/media/1.0/provider");
            this.msActivityFactory = (MediaRaActivityContextInterfaceFactory)ctx.lookup("slee/resources/media/1.0/acifactory");
            this.mgcpProvider = (JainMgcpProvider)ctx.lookup("slee/resources/jainmgcp/2.0/provider");
            this.mgcpAcif = (MgcpActivityContextInterfaceFactory)ctx.lookup("slee/resources/jainmgcp/2.0/acifactory");
            this.activityContextNamingfacility = (ActivityContextNamingFacility)ctx.lookup("slee/facilities/activitycontextnaming");
        }
        catch (NamingException ne) {
            logger.warn((Object)("Could not set SBB context:" + ne.getMessage()));
        }
    }

    public void onDeleteConnection(DeleteConnection event, ActivityContextInterface aci) {
        int txID = event.getTransactionHandle();
        this.setTxId(txID);
        this.setDeleteResponseSent(false);
        this.setReceivedTransactionID(event.getSource());
        EndpointIdentifier endpointID = event.getEndpointIdentifier();
        CallIdentifier callID = event.getCallIdentifier();
        ConnectionIdentifier connectionID = event.getConnectionIdentifier();
        String enpointName = endpointID.getLocalEndpointName();
        if (enpointName.endsWith("/$")) {
            logger.error((Object)("Cannot execute DLCX command for Endpoint which has wild card " + enpointName));
            this.sendDeleteResponse(ReturnCode.Endpoint_Unknown);
            aci.detach(this.sbbContext.getSbbLocalObject());
            return;
        }
        if (endpointID != null && callID == null && connectionID == null) {
            this.deleteForEndpoint(endpointID);
        } else if (endpointID != null && callID != null && connectionID == null) {
            this.deleteForEndpoint(endpointID);
        } else {
            ConnectionIdentifier connectionIdentifier = event.getConnectionIdentifier();
            ActivityContextInterface mediaACI = this.activityContextNamingfacility.lookup(connectionIdentifier.toString());
            mediaACI.attach(this.sbbContext.getSbbLocalObject());
            MsConnection msConnection = (MsConnection)mediaACI.getActivity();
            msConnection.release();
        }
    }

    public void onConnectionDisconnected(MsConnectionEvent evt, ActivityContextInterface aci) {
        if (!this.getDeleteResponseSent()) {
            this.sendDeleteResponse(ReturnCode.Transaction_Executed_Normally);
        }
    }

    private void sendDeleteResponse(ReturnCode returnCode) {
        DeleteConnectionResponse response = new DeleteConnectionResponse(this.getReceivedTransactionID(), returnCode);
        int txID = this.getTxId();
        response.setTransactionHandle(txID);
        this.mgcpProvider.sendMgcpEvents(new JainMgcpEvent[]{response});
    }

    private void deleteForEndpoint(EndpointIdentifier endpointID) {
        String endpointName = endpointID.getLocalEndpointName();
        List msConnections = this.msProvider.getMsConnections(endpointName);
        List mgcpConnectionActivities = this.mgcpProvider.getConnectionActivities(endpointID);
        for (MsConnection c : msConnections) {
            try {
                for (MgcpConnectionActivity a : mgcpConnectionActivities) {
                    String connectionIdentifier = a.getConnectionIdentifier().toString();
                    ActivityContextInterface mediaACI = this.activityContextNamingfacility.lookup(connectionIdentifier);
                    MsConnection msConnection = (MsConnection)mediaACI.getActivity();
                    if (msConnection.getId().equals(c.getId())) {
                        a.release();
                        mgcpConnectionActivities.remove(a);
                        break;
                    }
                    try {
                        this.activityContextNamingfacility.unbind(connectionIdentifier);
                    }
                    catch (TransactionRequiredLocalException e) {
                        e.printStackTrace();
                    }
                    catch (FacilityException e) {
                        e.printStackTrace();
                    }
                    catch (NameNotBoundException e) {
                        e.printStackTrace();
                    }
                }
                ActivityContextInterface msAci = this.msActivityFactory.getActivityContextInterface(c);
                msAci.attach(this.sbbContext.getSbbLocalObject());
                c.release();
            }
            catch (FactoryException e) {
                logger.error((Object)("FactoryException while trying to retrieve the MS ACI for MsConnection ID = " + c.getId()));
            }
            catch (NullPointerException e) {
                logger.error((Object)("NullPointerException while trying to retrieve the MS ACI for MsConnection ID = " + c.getId()));
            }
            catch (UnrecognizedActivityException e) {
                logger.error((Object)("UnrecognizedActivityException while trying to retrieve the MS ACI for MsConnection ID = " + c.getId()));
            }
        }
    }

    public void unsetSbbContext() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbActivate() {
    }

    public void sbbPassivate() {
    }

    public void sbbLoad() {
    }

    public void sbbStore() {
    }

    public void sbbRemove() {
    }

    public void sbbExceptionThrown(Exception exception, Object object, ActivityContextInterface activityContextInterface) {
        logger.error((Object)"Runtime exception thrown in DLCX TxId = ");
    }

    public void sbbRolledBack(RolledBackContext rolledBackContext) {
        logger.error((Object)"Tx rolled back in DLCX TxId = ");
    }

    public abstract int getTxId();

    public abstract void setTxId(int var1);

    public abstract Object getReceivedTransactionID();

    public abstract void setReceivedTransactionID(Object var1);

    public abstract boolean getDeleteResponseSent();

    public abstract void setDeleteResponseSent(boolean var1);
}

