/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.mgcp.ra;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpListener;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.JainMgcpStack;
import jain.protocol.ip.mgcp.message.CreateConnectionResponse;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import java.util.HashMap;
import java.util.List;
import java.util.TooManyListenersException;
import javax.slee.resource.ActivityHandle;
import net.java.slee.resource.mgcp.JainMgcpProvider;
import net.java.slee.resource.mgcp.MgcpConnectionActivity;
import net.java.slee.resource.mgcp.MgcpEndpointActivity;
import org.apache.log4j.Logger;
import org.mobicents.mgcp.stack.JainMgcpExtendedListener;
import org.mobicents.mgcp.stack.JainMgcpStackProviderImpl;
import org.mobicents.slee.resource.mgcp.ra.MgcpConnectionActivityHandle;
import org.mobicents.slee.resource.mgcp.ra.MgcpConnectionActivityImpl;
import org.mobicents.slee.resource.mgcp.ra.MgcpEndpointActivityHandle;
import org.mobicents.slee.resource.mgcp.ra.MgcpEndpointActivityImpl;
import org.mobicents.slee.resource.mgcp.ra.MgcpResourceAdaptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JainMgcpProviderImpl
implements JainMgcpProvider {
    private static Logger logger = Logger.getLogger(JainMgcpProviderImpl.class);
    private final MgcpResourceAdaptor ra;
    private final JainMgcpStackProviderImpl provider;
    private MgcpStackListener listener = new MgcpStackListener();
    private HashMap<Integer, JainMgcpCommandEvent> commandsEventMap = new HashMap();

    public JainMgcpProviderImpl(MgcpResourceAdaptor ra, jain.protocol.ip.mgcp.JainMgcpProvider jainMgcpProvider) {
        this.ra = ra;
        this.provider = (JainMgcpStackProviderImpl)jainMgcpProvider;
        try {
            this.provider.addJainMgcpListener((JainMgcpListener)this.listener);
        }
        catch (TooManyListenersException e) {
            e.printStackTrace();
        }
    }

    public MgcpConnectionActivity getConnectionActivity(ConnectionIdentifier connectionIdentifier, EndpointIdentifier endpointIdentifier) {
        MgcpConnectionActivityHandle handle = this.ra.getMgcpActivityManager().getMgcpConnectionActivityHandle(connectionIdentifier, endpointIdentifier, -1);
        if (handle != null) {
            return this.ra.getMgcpActivityManager().getMgcpConnectionActivity(handle);
        }
        try {
            MgcpConnectionActivityImpl activity = new MgcpConnectionActivityImpl(connectionIdentifier, endpointIdentifier, this.ra);
            handle = this.ra.getMgcpActivityManager().putMgcpConnectionActivity(activity);
            this.ra.getSleeEndpoint().activityStarted((ActivityHandle)handle);
            return activity;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to start activity", (Throwable)e);
            if (handle != null) {
                this.ra.getMgcpActivityManager().removeMgcpActivity(handle);
            }
            return null;
        }
    }

    public MgcpConnectionActivity getConnectionActivity(int transactionHandle, EndpointIdentifier endpointIdentifier) {
        MgcpConnectionActivityHandle handle = this.ra.getMgcpActivityManager().getMgcpConnectionActivityHandle(null, endpointIdentifier, transactionHandle);
        if (handle != null) {
            return this.ra.getMgcpActivityManager().getMgcpConnectionActivity(handle);
        }
        try {
            MgcpConnectionActivityImpl activity = new MgcpConnectionActivityImpl(transactionHandle, endpointIdentifier, this.ra);
            handle = this.ra.getMgcpActivityManager().putMgcpConnectionActivity(activity);
            this.ra.getSleeEndpoint().activityStarted((ActivityHandle)handle);
            return activity;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to start activity", (Throwable)e);
            if (handle != null) {
                this.ra.getMgcpActivityManager().removeMgcpActivity(handle);
            }
            return null;
        }
    }

    public List<MgcpConnectionActivity> getConnectionActivities(EndpointIdentifier endpointIdentifier) {
        return this.ra.getMgcpActivityManager().getMgcpConnectionActivities(endpointIdentifier);
    }

    public MgcpEndpointActivity getEndpointActivity(EndpointIdentifier endpointIdentifier) {
        MgcpEndpointActivityHandle handle = new MgcpEndpointActivityHandle(endpointIdentifier.toString());
        MgcpEndpointActivityImpl activity = this.ra.getMgcpActivityManager().getMgcpEndpointActivity(handle);
        if (activity != null) {
            return activity;
        }
        boolean insertedActivity = false;
        activity = new MgcpEndpointActivityImpl(this.ra, endpointIdentifier);
        try {
            this.ra.getMgcpActivityManager().putMgcpEndpointActivity(handle, activity);
            insertedActivity = true;
            this.ra.getSleeEndpoint().activityStarted((ActivityHandle)new MgcpEndpointActivityHandle(activity.getEndpointIdentifier().toString()));
            return activity;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to start activity", (Throwable)e);
            if (insertedActivity) {
                this.ra.getMgcpActivityManager().removeMgcpActivity(handle);
            }
            return null;
        }
    }

    public void addJainMgcpListener(JainMgcpListener arg0) throws TooManyListenersException {
        throw new TooManyListenersException("this provider does not support listeners");
    }

    public JainMgcpStack getJainMgcpStack() {
        return this.provider.getJainMgcpStack();
    }

    public void removeJainMgcpListener(JainMgcpListener arg0) {
    }

    public void sendMgcpEvents(JainMgcpEvent[] events) throws IllegalArgumentException {
        for (JainMgcpEvent event : events) {
            if (event instanceof CreateConnectionResponse) {
                this.ra.sendingCreateConnectionResponse((CreateConnectionResponse)event);
            }
            if (!(event instanceof JainMgcpCommandEvent)) continue;
            this.commandsEventMap.put(event.getTransactionHandle(), (JainMgcpCommandEvent)event);
        }
        this.provider.sendMgcpEvents(events);
    }

    public int getUniqueTransactionHandler() {
        return this.provider.getUniqueTransactionHandler();
    }

    public CallIdentifier getUniqueCallIdentifier() {
        return this.provider.getUniqueCallIdentifier();
    }

    public RequestIdentifier getUniqueRequestIdentifier() {
        return this.provider.getUniqueRequestIdentifier();
    }

    private class MgcpStackListener
    implements JainMgcpExtendedListener {
        private MgcpStackListener() {
        }

        public void processMgcpCommandEvent(JainMgcpCommandEvent event) {
            JainMgcpProviderImpl.this.ra.processMgcpCommandEvent(event);
        }

        public void processMgcpResponseEvent(JainMgcpResponseEvent response) {
            JainMgcpProviderImpl.this.ra.processMgcpResponseEvent(response, (JainMgcpEvent)JainMgcpProviderImpl.this.commandsEventMap.remove(response.getTransactionHandle()));
        }

        public void transactionEnded(int handle) {
        }

        public void transactionRxTimedOut(JainMgcpCommandEvent command) {
            JainMgcpProviderImpl.this.ra.processRxTimeout(command);
            JainMgcpProviderImpl.this.commandsEventMap.remove(command.getTransactionHandle());
        }

        public void transactionTxTimedOut(JainMgcpCommandEvent command) {
            JainMgcpProviderImpl.this.ra.processTxTimeout(command);
            JainMgcpProviderImpl.this.commandsEventMap.remove(command.getTransactionHandle());
        }
    }
}

