/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.mgcp.ra;

import javax.slee.ActivityContextInterface;
import javax.slee.FactoryException;
import javax.slee.UnrecognizedActivityException;
import javax.slee.resource.ActivityHandle;
import net.java.slee.resource.mgcp.MgcpActivityContextInterfaceFactory;
import net.java.slee.resource.mgcp.MgcpConnectionActivity;
import net.java.slee.resource.mgcp.MgcpEndpointActivity;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.resource.ResourceAdaptorActivityContextInterfaceFactory;
import org.mobicents.slee.resource.SleeActivityHandle;
import org.mobicents.slee.resource.mgcp.ra.MgcpResourceAdaptor;
import org.mobicents.slee.runtime.ActivityContext;
import org.mobicents.slee.runtime.ActivityContextFactory;
import org.mobicents.slee.runtime.ActivityContextInterfaceImpl;

public class MgcpActivityContextInterfaceFactoryImpl
implements MgcpActivityContextInterfaceFactory,
ResourceAdaptorActivityContextInterfaceFactory {
    private String jndiName;
    private String raEntityName;
    private SleeContainer serviceContainer;
    private ActivityContextFactory activityContextFactory;
    private MgcpResourceAdaptor ra;

    public MgcpActivityContextInterfaceFactoryImpl(SleeContainer serviceContainer, MgcpResourceAdaptor ra, String name) {
        this.raEntityName = name;
        this.jndiName = "java:slee/resources/" + name + "/mgcpacif";
        this.ra = ra;
        this.serviceContainer = serviceContainer;
        this.activityContextFactory = serviceContainer.getActivityContextFactory();
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public ActivityContextInterface getActivityContextInterface(MgcpConnectionActivity activity) throws NullPointerException, UnrecognizedActivityException, FactoryException {
        return this.getAci(activity);
    }

    public ActivityContextInterface getActivityContextInterface(MgcpEndpointActivity activity) throws NullPointerException, UnrecognizedActivityException, FactoryException {
        return this.getAci(activity);
    }

    private ActivityContextInterface getAci(Object activity) throws UnrecognizedActivityException, NullPointerException {
        if (activity != null) {
            ActivityHandle activityHandle = this.ra.getActivityHandle(activity);
            if (activityHandle != null) {
                SleeActivityHandle sleeActivityHandle = new SleeActivityHandle(this.raEntityName, activityHandle, this.serviceContainer);
                ActivityContext ac = this.activityContextFactory.getActivityContext((Object)sleeActivityHandle);
                return new ActivityContextInterfaceImpl(this.serviceContainer, ac.getActivityContextId());
            }
            throw new UnrecognizedActivityException(activity);
        }
        throw new NullPointerException("activity can't be null");
    }
}

