/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.mgcp.ra;

import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.slee.resource.ActivityHandle;
import net.java.slee.resource.mgcp.MgcpConnectionActivity;
import org.apache.log4j.Logger;
import org.mobicents.slee.resource.mgcp.ra.MgcpConnectionActivityHandle;
import org.mobicents.slee.resource.mgcp.ra.MgcpConnectionActivityImpl;
import org.mobicents.slee.resource.mgcp.ra.MgcpEndpointActivityHandle;
import org.mobicents.slee.resource.mgcp.ra.MgcpEndpointActivityImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MgcpActivityManager {
    private static Logger logger = Logger.getLogger(MgcpActivityManager.class);
    private ConcurrentHashMap<MgcpEndpointActivityHandle, MgcpEndpointActivityImpl> endpointActivities = new ConcurrentHashMap();
    private ConcurrentHashMap<MgcpConnectionActivityHandle, MgcpConnectionActivityImpl> connectionActivities = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, MgcpConnectionActivityHandle> transactionHandle2ActivityHandleMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, MgcpConnectionActivityHandle> connectionIdentifier2ActivityHandleMap = new ConcurrentHashMap();

    protected MgcpActivityManager() {
    }

    public MgcpConnectionActivityHandle putMgcpConnectionActivity(MgcpConnectionActivityImpl activity) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("putMgcpConnectionActivity(activity=" + activity + ")"));
        }
        MgcpConnectionActivityHandle handle = new MgcpConnectionActivityHandle(activity.getId());
        if (activity.getConnectionIdentifier() != null) {
            this.connectionIdentifier2ActivityHandleMap.put(activity.getConnectionIdentifier(), handle);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("created mapping between connection identifier " + activity.getConnectionIdentifier() + " and activity handle " + handle + ")"));
            }
        } else if (activity.getTransactionHandle() != null) {
            this.transactionHandle2ActivityHandleMap.put(activity.getTransactionHandle(), handle);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("created temp mapping between transaction handle " + activity.getTransactionHandle() + " and activity handle " + handle + ")"));
            }
        }
        this.connectionActivities.put(handle, activity);
        return handle;
    }

    public MgcpConnectionActivityImpl getMgcpConnectionActivity(MgcpConnectionActivityHandle handle) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getMgcpConnectionActivity(handle=" + handle + ")"));
        }
        return this.connectionActivities.get(handle);
    }

    public List<MgcpConnectionActivity> getMgcpConnectionActivities(EndpointIdentifier endpointIdentifier) {
        List<MgcpConnectionActivity> listOfmgcpConnectionActivities = Collections.synchronizedList(new ArrayList());
        Collection<MgcpConnectionActivityImpl> connectionActivitiesColl = this.connectionActivities.values();
        for (MgcpConnectionActivityImpl mgcpConnectionActivityImpl : connectionActivitiesColl) {
            EndpointIdentifier endpointIdentifierLocal = mgcpConnectionActivityImpl.getEndpointIdentifier();
            if (endpointIdentifierLocal == null || !endpointIdentifierLocal.toString().equals(endpointIdentifier.toString())) continue;
            listOfmgcpConnectionActivities.add(mgcpConnectionActivityImpl);
        }
        return listOfmgcpConnectionActivities;
    }

    /*
     * Enabled aggressive block sorting
     */
    public MgcpConnectionActivityHandle updateMgcpConnectionActivity(int transactionHandle, ConnectionIdentifier connectionIdentifier, EndpointIdentifier endpointIdentifier) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("updateMgcpConnectionActivity(transactionHandle=" + transactionHandle + ",connectionIdentifier=" + connectionIdentifier + ")"));
        }
        if (connectionIdentifier == null) {
            logger.warn((Object)"update of MgcpConnectionActivity failed, connectionIdentifier is null");
            return null;
        }
        ActivityHandle handle = this.transactionHandle2ActivityHandleMap.remove(transactionHandle);
        if (handle == null) {
            if (!logger.isDebugEnabled()) return null;
            logger.debug((Object)("update of MgcpConnectionActivity failed, transactionHandle " + transactionHandle + " not found"));
            return null;
        }
        MgcpConnectionActivityImpl activity = this.connectionActivities.get(handle);
        if (activity == null) {
            logger.warn((Object)("update of MgcpConnectionActivity failed, activity for connectionIdentifier " + connectionIdentifier + " not found"));
            return null;
        }
        MgcpConnectionActivityHandle connectionHandle = (MgcpConnectionActivityHandle)handle;
        this.connectionIdentifier2ActivityHandleMap.put(connectionIdentifier.toString(), connectionHandle);
        activity.setConnectionIdentifier(connectionIdentifier);
        if (endpointIdentifier != null) {
            activity.setEndpointIdentifier(endpointIdentifier);
        }
        if (!logger.isDebugEnabled()) return connectionHandle;
        logger.debug((Object)("activity for connectionIdentifier " + connectionIdentifier + " updated"));
        return connectionHandle;
    }

    public MgcpConnectionActivityHandle getMgcpConnectionActivityHandle(ConnectionIdentifier connectionIdentifier, EndpointIdentifier endpointIdentifier, int transactionHandle) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getMgcpConnectionActivityHandle(transactionHandle=" + transactionHandle + ",connectionIdentifier=" + connectionIdentifier + ")"));
        }
        if (connectionIdentifier != null) {
            MgcpConnectionActivityHandle handle = this.connectionIdentifier2ActivityHandleMap.get(connectionIdentifier.toString());
            return handle != null ? handle : this.updateMgcpConnectionActivity(transactionHandle, connectionIdentifier, endpointIdentifier);
        }
        return this.transactionHandle2ActivityHandleMap.get(transactionHandle);
    }

    public void putMgcpEndpointActivity(MgcpEndpointActivityHandle handle, MgcpEndpointActivityImpl activity) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("putMgcpEndpointActivity(activity=" + activity + ")"));
        }
        this.endpointActivities.put(handle, activity);
    }

    public MgcpEndpointActivityImpl getMgcpEndpointActivity(MgcpEndpointActivityHandle handle) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getMgcpEndpointActivity(handle=" + handle + ")"));
        }
        return this.endpointActivities.get(handle);
    }

    public boolean containsMgcpEndpointActivityHandle(MgcpEndpointActivityHandle handle) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("containsMgcpEndpointActivityHandle(handle=" + handle + ")"));
        }
        return this.endpointActivities.containsKey(handle);
    }

    public void removeMgcpActivity(ActivityHandle handle) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("removeMgcpActivity(handle=" + handle + ")"));
        }
        if (handle instanceof MgcpConnectionActivityHandle) {
            MgcpConnectionActivityImpl activity = this.connectionActivities.remove((MgcpConnectionActivityHandle)handle);
            if (activity != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("removed connection activity for handle " + handle));
                }
                if (activity.getConnectionIdentifier() != null) {
                    if (this.connectionIdentifier2ActivityHandleMap.remove(activity.getConnectionIdentifier()) != null && logger.isDebugEnabled()) {
                        logger.debug((Object)("removed connection identifier mapping for handle " + handle));
                    }
                } else if (this.transactionHandle2ActivityHandleMap.remove(activity.getTransactionHandle()) != null && logger.isDebugEnabled()) {
                    logger.debug((Object)("removed tx handle mapping for activity handle " + handle));
                }
            } else {
                logger.warn((Object)("connection activity for handle " + handle + " not found"));
            }
        } else if (handle instanceof MgcpEndpointActivityHandle) {
            MgcpEndpointActivityImpl activity = this.endpointActivities.remove((MgcpEndpointActivityHandle)handle);
            if (activity != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("removed endpoint activity for handle " + handle));
                }
            } else {
                logger.warn((Object)("endpoint activity for handle " + handle + " not found"));
            }
        }
    }

    public boolean containsActivityHandle(ActivityHandle handle) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("containsActivityHandle(handle=" + handle + ")"));
        }
        if (handle instanceof MgcpConnectionActivityHandle) {
            return this.connectionActivities.containsKey((MgcpConnectionActivityHandle)handle);
        }
        if (handle instanceof MgcpEndpointActivityHandle) {
            return this.endpointActivities.containsKey((MgcpEndpointActivityHandle)handle);
        }
        return false;
    }

    public Object getActivity(ActivityHandle handle) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getActivity(handle=" + handle + ")"));
        }
        if (handle instanceof MgcpConnectionActivityHandle) {
            return this.connectionActivities.get((MgcpConnectionActivityHandle)handle);
        }
        if (handle instanceof MgcpEndpointActivityHandle) {
            return this.endpointActivities.get((MgcpEndpointActivityHandle)handle);
        }
        return null;
    }

    public ActivityHandle getActivityHandle(Object activity) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getActivityHandle(activity=" + activity + ")"));
        }
        if (activity instanceof MgcpConnectionActivityImpl) {
            MgcpConnectionActivityImpl castedActivity = (MgcpConnectionActivityImpl)activity;
            if (castedActivity.getConnectionIdentifier() != null) {
                return this.connectionIdentifier2ActivityHandleMap.get(castedActivity.getConnectionIdentifier());
            }
            return this.transactionHandle2ActivityHandleMap.get(castedActivity.getTransactionHandle());
        }
        if (activity instanceof MgcpEndpointActivityImpl) {
            MgcpEndpointActivityHandle handle = new MgcpEndpointActivityHandle(((MgcpEndpointActivityImpl)activity).getEndpointIdentifier().toString());
            if (this.endpointActivities.containsKey(handle)) {
                return handle;
            }
            return null;
        }
        return null;
    }
}

