/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.mgcp.ra;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.AuditConnection;
import jain.protocol.ip.mgcp.message.AuditEndpoint;
import jain.protocol.ip.mgcp.message.CreateConnection;
import jain.protocol.ip.mgcp.message.CreateConnectionResponse;
import jain.protocol.ip.mgcp.message.DeleteConnection;
import jain.protocol.ip.mgcp.message.DeleteConnectionResponse;
import jain.protocol.ip.mgcp.message.EndpointConfiguration;
import jain.protocol.ip.mgcp.message.ModifyConnection;
import jain.protocol.ip.mgcp.message.NotificationRequest;
import jain.protocol.ip.mgcp.message.Notify;
import jain.protocol.ip.mgcp.message.RestartInProgress;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.slee.Address;
import javax.slee.AddressPlan;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.BootstrapContext;
import javax.slee.resource.FailureReason;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceException;
import javax.slee.resource.SleeEndpoint;
import net.java.slee.resource.mgcp.event.TransactionTimeout;
import org.apache.log4j.Logger;
import org.mobicents.mgcp.stack.JainMgcpStackImpl;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.resource.ResourceAdaptorEntity;
import org.mobicents.slee.resource.ResourceAdaptorTypeIDImpl;
import org.mobicents.slee.resource.mgcp.ra.JainMgcpProviderImpl;
import org.mobicents.slee.resource.mgcp.ra.MgcpActivityContextInterfaceFactoryImpl;
import org.mobicents.slee.resource.mgcp.ra.MgcpActivityManager;
import org.mobicents.slee.resource.mgcp.ra.MgcpConnectionActivityHandle;
import org.mobicents.slee.resource.mgcp.ra.MgcpConnectionActivityImpl;
import org.mobicents.slee.resource.mgcp.ra.MgcpEndpointActivityHandle;
import org.mobicents.slee.resource.mgcp.ra.MgcpEndpointActivityImpl;

public class MgcpResourceAdaptor
implements ResourceAdaptor,
Serializable {
    private static final long serialVersionUID = -3161437298088878963L;
    private MgcpActivityManager mgcpActivityManager = new MgcpActivityManager();
    private BootstrapContext bootstrapContext;
    private JainMgcpStackImpl stack;
    private JainMgcpProviderImpl mgcpProvider;
    private transient SleeEndpoint sleeEndpoint = null;
    private transient EventLookupFacility eventLookup = null;
    private Integer port = new Integer(2728);
    private String localAddress;
    private Logger logger = Logger.getLogger(MgcpResourceAdaptor.class);
    private MgcpActivityContextInterfaceFactoryImpl acif;

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public MgcpActivityManager getMgcpActivityManager() {
        return this.mgcpActivityManager;
    }

    public JainMgcpStackImpl getStack() {
        return this.stack;
    }

    public void entityCreated(BootstrapContext bootstrapContext) throws ResourceException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("RA entity " + bootstrapContext.getEntityName() + " created"));
        }
        this.bootstrapContext = bootstrapContext;
        this.sleeEndpoint = bootstrapContext.getSleeEndpoint();
        this.eventLookup = bootstrapContext.getEventLookupFacility();
    }

    public void entityRemoved() {
    }

    public void entityActivated() throws ResourceException {
        try {
            this.localAddress = InetAddress.getLocalHost().getHostName() + ":" + this.port;
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        try {
            String jbossBindAddress = System.getProperty("jboss.bind.address", "127.0.0.1");
            InetAddress inetAddress = InetAddress.getByName(jbossBindAddress);
            this.stack = new JainMgcpStackImpl(inetAddress, this.port.intValue());
            this.mgcpProvider = new JainMgcpProviderImpl(this, this.stack.createProvider());
        }
        catch (Exception e) {
            throw new ResourceException(e.getMessage());
        }
        this.initializeNamingContext();
        this.mgcpActivityManager.setMgcpRaEntityName(this.bootstrapContext.getEntityName());
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("RA entity " + this.bootstrapContext.getEntityName() + " activated"));
        }
    }

    public void entityDeactivating() {
    }

    public void entityDeactivated() {
        this.clearNamingContext();
        this.stack.close();
        this.stack = null;
        this.mgcpProvider = null;
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("RA entity " + this.bootstrapContext.getEntityName() + " deactivated"));
        }
    }

    public void eventProcessingSuccessful(ActivityHandle handle, Object event, int eventID, Address address, int flags) {
    }

    public void eventProcessingFailed(ActivityHandle handle, Object event, int eventID, Address address, int flags, FailureReason reason) {
    }

    public void activityEnded(ActivityHandle handle) {
        this.mgcpActivityManager.removeMgcpActivity(handle);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Activity with handle " + handle + " ended"));
        }
    }

    public void activityUnreferenced(ActivityHandle handle) {
    }

    public void queryLiveness(ActivityHandle handle) {
        if (!this.mgcpActivityManager.containsActivityHandle(handle)) {
            try {
                this.sleeEndpoint.activityEnding(handle);
            }
            catch (Exception e) {
                this.logger.error((Object)"Unexpected error while ending activity", (Throwable)e);
            }
        }
    }

    public Object getActivity(ActivityHandle handle) {
        return this.mgcpActivityManager.getActivity(handle);
    }

    public ActivityHandle getActivityHandle(Object activity) {
        return this.mgcpActivityManager.getActivityHandle(activity);
    }

    public Object getSBBResourceAdaptorInterface(String string) {
        return this.mgcpProvider;
    }

    public Marshaler getMarshaler() {
        return null;
    }

    public void serviceInstalled(String serviceKey, int[] eventIDs, String[] resourceOptions) {
    }

    public void serviceUninstalled(String serviceKey) {
    }

    public void serviceActivated(String serviceKey) {
    }

    public void serviceDeactivated(String serviceKey) {
    }

    public SleeEndpoint getSleeEndpoint() {
        return this.sleeEndpoint;
    }

    protected void endActivity(ActivityHandle handle) {
        if (handle != null && this.mgcpActivityManager.containsActivityHandle(handle)) {
            try {
                this.getSleeEndpoint().activityEnding(handle);
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to end activity with handle " + handle), (Throwable)e);
            }
        }
    }

    public void processMgcpCommandEvent(JainMgcpCommandEvent event) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.bootstrapContext.getEntityName() + " received event of type " + event.getObjectIdentifier() + ". Request TX ID = " + event.getTransactionHandle()));
        }
        switch (event.getObjectIdentifier()) {
            case 101: {
                AuditConnection auditConnection = (AuditConnection)event;
                this.processNonCreateConnectionMgcpEvent(auditConnection.getConnectionIdentifier(), event.getEndpointIdentifier(), event.getTransactionHandle(), "net.java.slee.resource.mgcp.AUDIT_CONNECTION", event);
                break;
            }
            case 102: {
                AuditEndpoint auditEndpoint = (AuditEndpoint)event;
                this.processEndpointMgcpEvent(auditEndpoint.getEndpointIdentifier(), "net.java.slee.resource.mgcp.AUDIT_ENDPOINT", event);
                break;
            }
            case 103: {
                CreateConnection createConnection = (CreateConnection)event;
                this.processCreateConnectionMgcpEvent(createConnection);
                break;
            }
            case 104: {
                DeleteConnection deleteConnection = (DeleteConnection)event;
                if (deleteConnection.getConnectionIdentifier() != null) {
                    this.processNonCreateConnectionMgcpEvent(deleteConnection.getConnectionIdentifier(), event.getEndpointIdentifier(), event.getTransactionHandle(), "net.java.slee.resource.mgcp.DELETE_CONNECTION", event);
                    break;
                }
                this.processEndpointMgcpEvent(deleteConnection.getEndpointIdentifier(), "net.java.slee.resource.mgcp.DELETE_CONNECTION", event);
                break;
            }
            case 105: {
                EndpointConfiguration endpointConfiguration = (EndpointConfiguration)event;
                this.processEndpointMgcpEvent(endpointConfiguration.getEndpointIdentifier(), "net.java.slee.resource.mgcp.ENDPOINT_CONFIGURATION", event);
                break;
            }
            case 106: {
                ModifyConnection modifyConnection = (ModifyConnection)event;
                this.processNonCreateConnectionMgcpEvent(modifyConnection.getConnectionIdentifier(), event.getEndpointIdentifier(), event.getTransactionHandle(), "net.java.slee.resource.mgcp.MODIFY_CONNECTION", event);
                break;
            }
            case 107: {
                NotificationRequest notificationRequest = (NotificationRequest)event;
                this.processEndpointMgcpEvent(notificationRequest.getEndpointIdentifier(), "net.java.slee.resource.mgcp.NOTIFICATION_REQUEST", event);
                break;
            }
            case 108: {
                Notify notify = (Notify)event;
                this.processEndpointMgcpEvent(notify.getEndpointIdentifier(), "net.java.slee.resource.mgcp.NOTIFY", event);
                break;
            }
            case 109: {
                RestartInProgress restartInProgress = (RestartInProgress)event;
                this.processEndpointMgcpEvent(restartInProgress.getEndpointIdentifier(), "net.java.slee.resource.mgcp.RESTART_IN_PROGRESS", event);
                break;
            }
            default: {
                this.logger.warn((Object)("Unexpected event type: " + event.getObjectIdentifier()));
            }
        }
    }

    public void processMgcpResponseEvent(JainMgcpResponseEvent response, JainMgcpEvent command) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Receive response TX ID = " + response.getTransactionHandle()));
        }
        switch (response.getObjectIdentifier()) {
            case 201: {
                AuditConnection auditConnection = (AuditConnection)command;
                this.processNonCreateConnectionMgcpEvent(auditConnection.getConnectionIdentifier(), auditConnection.getEndpointIdentifier(), response.getTransactionHandle(), "net.java.slee.resource.mgcp.AUDIT_CONNECTION_RESPONSE", response);
                break;
            }
            case 202: {
                this.processEndpointMgcpEvent(((AuditEndpoint)command).getEndpointIdentifier(), "net.java.slee.resource.mgcp.AUDIT_ENDPOINT_RESPONSE", response);
                break;
            }
            case 203: {
                ConnectionIdentifier cId = null;
                EndpointIdentifier endpointIdentifier = null;
                if (!MgcpResourceAdaptor.isProvisional(response.getReturnCode())) {
                    CreateConnectionResponse createConnectionResponse = (CreateConnectionResponse)response;
                    cId = createConnectionResponse.getConnectionIdentifier();
                    endpointIdentifier = createConnectionResponse.getSpecificEndpointIdentifier();
                }
                if (endpointIdentifier == null) {
                    endpointIdentifier = ((CreateConnection)command).getEndpointIdentifier();
                }
                this.processNonCreateConnectionMgcpEvent(cId, endpointIdentifier, response.getTransactionHandle(), "net.java.slee.resource.mgcp.CREATE_CONNECTION_RESPONSE", response);
                if (!MgcpResourceAdaptor.isFailure(response.getReturnCode())) break;
                this.endActivity(this.mgcpActivityManager.getMgcpConnectionActivityHandle(cId, endpointIdentifier, response.getTransactionHandle()));
                break;
            }
            case 204: {
                DeleteConnection deleteConnection = (DeleteConnection)command;
                if (deleteConnection.getConnectionIdentifier() != null) {
                    this.processNonCreateConnectionMgcpEvent(deleteConnection.getConnectionIdentifier(), deleteConnection.getEndpointIdentifier(), response.getTransactionHandle(), "net.java.slee.resource.mgcp.DELETE_CONNECTION_RESPONSE", response);
                    break;
                }
                this.processEndpointMgcpEvent(deleteConnection.getEndpointIdentifier(), "net.java.slee.resource.mgcp.DELETE_CONNECTION_RESPONSE", response);
                break;
            }
            case 205: {
                this.processEndpointMgcpEvent(((EndpointConfiguration)command).getEndpointIdentifier(), "net.java.slee.resource.mgcp.ENDPOINT_CONFIGURATION_RESPONSE", response);
                break;
            }
            case 206: {
                ModifyConnection modifyConnection = (ModifyConnection)command;
                this.processNonCreateConnectionMgcpEvent(modifyConnection.getConnectionIdentifier(), modifyConnection.getEndpointIdentifier(), response.getTransactionHandle(), "net.java.slee.resource.mgcp.MODIFY_CONNECTION_RESPONSE", response);
                break;
            }
            case 207: {
                this.processEndpointMgcpEvent(((NotificationRequest)command).getEndpointIdentifier(), "net.java.slee.resource.mgcp.NOTIFICATION_REQUEST_RESPONSE", response);
                break;
            }
            case 208: {
                this.processEndpointMgcpEvent(((Notify)command).getEndpointIdentifier(), "net.java.slee.resource.mgcp.NOTIFY_RESPONSE", response);
                break;
            }
            case 209: {
                this.processEndpointMgcpEvent(((RestartInProgress)command).getEndpointIdentifier(), "net.java.slee.resource.mgcp.RESTART_IN_PROGRESS_RESPONSE", response);
                break;
            }
            default: {
                this.logger.warn((Object)("Unexpected event type: " + response.getObjectIdentifier()));
            }
        }
    }

    private void fireEvent(String eventName, ActivityHandle handle, Object event) {
        int eventID = -1;
        try {
            eventID = this.eventLookup.getEventID(eventName, "net.java", "1.0");
        }
        catch (Exception fe) {
            this.logger.error((Object)"Caught a exception while getting id of event to fire", (Throwable)fe);
        }
        if (eventID == -1) {
            this.logger.warn((Object)("Unknown event type: " + eventName));
            return;
        }
        try {
            Address address = new Address(AddressPlan.IP, "localhost");
            this.sleeEndpoint.fireEvent(handle, event, eventID, address);
            this.logger.info((Object)("Fired event: " + eventName));
        }
        catch (Exception e) {
            this.logger.error((Object)"Caught an exception while firing event", (Throwable)e);
        }
    }

    private void processNonCreateConnectionMgcpEvent(ConnectionIdentifier connectionIdentifier, EndpointIdentifier endpointIdentifier, int transactionHandle, String eventName, Object eventObject) {
        MgcpConnectionActivityHandle handle = this.mgcpActivityManager.getMgcpConnectionActivityHandle(connectionIdentifier, endpointIdentifier, transactionHandle);
        if (handle == null) {
            MgcpConnectionActivityImpl activity = new MgcpConnectionActivityImpl(connectionIdentifier, endpointIdentifier, this);
            handle = this.mgcpActivityManager.putMgcpConnectionActivity(activity);
        }
        this.fireEvent(eventName, handle, eventObject);
        if (eventObject instanceof DeleteConnection || eventObject instanceof DeleteConnectionResponse && !MgcpResourceAdaptor.isProvisional(((DeleteConnectionResponse)eventObject).getReturnCode())) {
            try {
                this.getSleeEndpoint().activityEnding((ActivityHandle)handle);
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to end activity with handle " + handle), (Throwable)e);
            }
        }
    }

    private void processCreateConnectionMgcpEvent(CreateConnection createConnection) {
        MgcpConnectionActivityImpl activity = new MgcpConnectionActivityImpl(createConnection.getTransactionHandle(), createConnection.getEndpointIdentifier(), this);
        MgcpConnectionActivityHandle handle = this.mgcpActivityManager.putMgcpConnectionActivity(activity);
        this.fireEvent("net.java.slee.resource.mgcp.CREATE_CONNECTION", handle, createConnection);
    }

    private void processEndpointMgcpEvent(EndpointIdentifier endpointIdentifier, String eventName, Object eventObject) {
        MgcpEndpointActivityHandle handle = new MgcpEndpointActivityHandle(endpointIdentifier.toString());
        if (!this.mgcpActivityManager.containsMgcpEndpointActivityHandle(handle)) {
            this.mgcpActivityManager.putMgcpEndpointActivity(handle, new MgcpEndpointActivityImpl(this, endpointIdentifier));
        }
        this.fireEvent(eventName, handle, eventObject);
        if (eventObject instanceof DeleteConnection || eventObject instanceof DeleteConnectionResponse) {
            try {
                this.getSleeEndpoint().activityEnding((ActivityHandle)handle);
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to end activity with handle " + handle), (Throwable)e);
            }
        }
    }

    private ActivityHandle getActivityHandle(JainMgcpCommandEvent event) {
        Serializable handle = null;
        switch (event.getObjectIdentifier()) {
            case 101: {
                handle = this.mgcpActivityManager.getMgcpConnectionActivityHandle(((AuditConnection)event).getConnectionIdentifier(), event.getEndpointIdentifier(), event.getTransactionHandle());
                break;
            }
            case 102: {
                handle = new MgcpEndpointActivityHandle(((AuditEndpoint)event).getEndpointIdentifier().toString());
                if (this.mgcpActivityManager.containsActivityHandle((ActivityHandle)handle)) break;
                handle = null;
                break;
            }
            case 103: {
                handle = this.mgcpActivityManager.getMgcpConnectionActivityHandle(null, event.getEndpointIdentifier(), event.getTransactionHandle());
                break;
            }
            case 104: {
                handle = this.mgcpActivityManager.getMgcpConnectionActivityHandle(((DeleteConnection)event).getConnectionIdentifier(), event.getEndpointIdentifier(), event.getTransactionHandle());
                break;
            }
            case 105: {
                handle = new MgcpEndpointActivityHandle(((EndpointConfiguration)event).getEndpointIdentifier().toString());
                if (this.mgcpActivityManager.containsActivityHandle((ActivityHandle)handle)) break;
                handle = null;
                break;
            }
            case 106: {
                handle = this.mgcpActivityManager.getMgcpConnectionActivityHandle(((ModifyConnection)event).getConnectionIdentifier(), event.getEndpointIdentifier(), event.getTransactionHandle());
                break;
            }
            case 107: {
                handle = new MgcpEndpointActivityHandle(((NotificationRequest)event).getEndpointIdentifier().toString());
                if (this.mgcpActivityManager.containsActivityHandle((ActivityHandle)handle)) break;
                handle = null;
                break;
            }
            case 108: {
                handle = new MgcpEndpointActivityHandle(((Notify)event).getEndpointIdentifier().toString());
                if (this.mgcpActivityManager.containsActivityHandle((ActivityHandle)handle)) break;
                handle = null;
                break;
            }
            case 109: {
                handle = new MgcpEndpointActivityHandle(((RestartInProgress)event).getEndpointIdentifier().toString());
                if (this.mgcpActivityManager.containsActivityHandle((ActivityHandle)handle)) break;
                handle = null;
                break;
            }
            default: {
                this.logger.warn((Object)("Unexpected event type: " + event.getObjectIdentifier()));
            }
        }
        return handle;
    }

    public void processTxTimeout(JainMgcpCommandEvent event) {
        ActivityHandle handle = null;
        handle = this.getActivityHandle(event);
        if (handle != null) {
            this.fireEvent("net.java.slee.resource.mgcp.TRANSACTION_TIMEOUT", handle, new TransactionTimeout());
            this.endActivity(handle);
        }
    }

    public void processRxTimeout(JainMgcpCommandEvent event) {
        ActivityHandle handle = null;
        handle = this.getActivityHandle(event);
        if (handle != null) {
            this.endActivity(handle);
        }
    }

    public void sendingCreateConnectionResponse(CreateConnectionResponse event) {
        this.mgcpActivityManager.updateMgcpConnectionActivity(event.getTransactionHandle(), event.getConnectionIdentifier(), event.getSpecificEndpointIdentifier());
    }

    private void initializeNamingContext() {
        this.logger.info((Object)"Initialize naming context");
        SleeContainer sleeContainer = SleeContainer.lookupFromJndi();
        this.logger.debug((Object)("SLEE container: " + sleeContainer));
        String entityName = this.bootstrapContext.getEntityName();
        this.logger.debug((Object)("Entity name: " + entityName));
        ResourceAdaptorEntity resourceAdaptorEntity = sleeContainer.getResourceAdaptorEnitity(entityName);
        this.logger.debug((Object)("Resource Adaptor Entity: " + resourceAdaptorEntity));
        ResourceAdaptorTypeIDImpl resourceAdaptorTypeId = resourceAdaptorEntity.getInstalledResourceAdaptor().getRaType().getResourceAdaptorTypeID();
        this.logger.debug((Object)("Resource Adaptor Type ID: " + resourceAdaptorTypeId));
        this.acif = new MgcpActivityContextInterfaceFactoryImpl(resourceAdaptorEntity.getServiceContainer(), this, entityName);
        sleeContainer.getActivityContextInterfaceFactories().put(resourceAdaptorTypeId, this.acif);
        String jndiName = this.acif.getJndiName();
        int i = jndiName.indexOf(58);
        int j = jndiName.lastIndexOf(47);
        String prefix = jndiName.substring(i + 1, j);
        String name = jndiName.substring(j + 1);
        SleeContainer.registerWithJndi((String)prefix, (String)name, (Object)this.acif);
    }

    private void clearNamingContext() {
        String jndiName = this.acif.getJndiName();
        int i = jndiName.indexOf(58);
        String name = jndiName.substring(i + 1);
        SleeContainer.unregisterWithJndi((String)name);
    }

    private static boolean isProvisional(ReturnCode rc) {
        int rval = rc.getValue();
        return 99 < rval && rval < 200;
    }

    private static boolean isFailure(ReturnCode rc) {
        int rval = rc.getValue();
        return rval > 299;
    }
}

