/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mgcp.stack;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.EndpointConfiguration;
import jain.protocol.ip.mgcp.message.EndpointConfigurationResponse;
import jain.protocol.ip.mgcp.message.parms.BearerInformation;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.net.InetAddress;
import java.text.ParseException;
import org.apache.log4j.Logger;
import org.mobicents.mgcp.stack.JainMgcpStackImpl;
import org.mobicents.mgcp.stack.TransactionHandler;
import org.mobicents.mgcp.stack.parser.MgcpContentHandler;
import org.mobicents.mgcp.stack.parser.MgcpMessageParser;
import org.mobicents.mgcp.stack.parser.Utils;

public class EndpointConfigurationHandler
extends TransactionHandler {
    private EndpointConfiguration command;
    private EndpointConfigurationResponse response;
    private Logger logger = Logger.getLogger(EndpointConfigurationHandler.class);

    public EndpointConfigurationHandler(JainMgcpStackImpl stack) {
        super(stack);
    }

    public EndpointConfigurationHandler(JainMgcpStackImpl stack, InetAddress address, int port) {
        super(stack, address, port);
    }

    protected JainMgcpCommandEvent decodeCommand(String message) throws ParseException {
        MgcpMessageParser parser = new MgcpMessageParser(new CommandContentHandle());
        try {
            parser.parse(message);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.command;
    }

    protected JainMgcpResponseEvent decodeResponse(String message) throws ParseException {
        MgcpMessageParser parser = new MgcpMessageParser(new ResponseContentHandle());
        try {
            parser.parse(message);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.response;
    }

    protected String encode(JainMgcpCommandEvent event) {
        EndpointConfiguration evt = (EndpointConfiguration)event;
        String msg = "EPCF " + evt.getTransactionHandle() + " " + evt.getEndpointIdentifier() + " MGCP 1.0\n";
        msg = msg + "B:e:" + evt.getBearerInformation() + "\n";
        return msg;
    }

    protected String encode(JainMgcpResponseEvent event) {
        EndpointConfigurationResponse response = (EndpointConfigurationResponse)event;
        ReturnCode returnCode = response.getReturnCode();
        String msg = returnCode.getValue() + " " + response.getTransactionHandle() + " " + returnCode.getComment() + "\n";
        return msg;
    }

    private class ResponseContentHandle
    implements MgcpContentHandler {
        public void header(String header) throws ParseException {
            String[] tokens = header.split("\\s");
            int tid = Integer.parseInt(tokens[1]);
            EndpointConfigurationHandler.this.response = new EndpointConfigurationResponse((Object)EndpointConfigurationHandler.this.stack, Utils.decodeReturnCode(Integer.parseInt(tokens[0])));
            EndpointConfigurationHandler.this.response.setTransactionHandle(tid);
        }

        public void param(String name, String value) throws ParseException {
        }

        public void sessionDescription(String sd) throws ParseException {
        }
    }

    private class CommandContentHandle
    implements MgcpContentHandler {
        public void header(String header) throws ParseException {
            String[] tokens = header.split("\\s");
            String verb = tokens[0].trim();
            String transactionID = tokens[1].trim();
            String version = tokens[3].trim() + " " + tokens[4].trim();
            int tid = Integer.parseInt(transactionID);
            EndpointIdentifier endpoint = Utils.decodeEndpointIdentifier(tokens[2].trim());
            EndpointConfigurationHandler.this.command = new EndpointConfiguration((Object)EndpointConfigurationHandler.this.stack, endpoint, BearerInformation.EncMethod_A_Law);
            EndpointConfigurationHandler.this.command.setTransactionHandle(tid);
        }

        public void param(String name, String value) throws ParseException {
            if (name.equalsIgnoreCase("B")) {
                EndpointConfigurationHandler.this.command.setBearerInformation(Utils.createBearerInformation(value));
            }
        }

        public void sessionDescription(String sd) throws ParseException {
        }
    }
}

