/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mgcp.stack;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.Notify;
import jain.protocol.ip.mgcp.message.NotifyResponse;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import org.apache.log4j.Logger;
import org.mobicents.mgcp.stack.JainMgcpStackImpl;
import org.mobicents.mgcp.stack.TransactionHandler;
import org.mobicents.mgcp.stack.parser.MgcpContentHandler;
import org.mobicents.mgcp.stack.parser.MgcpMessageParser;
import org.mobicents.mgcp.stack.parser.Utils;

public class NotifyHandler
extends TransactionHandler {
    private Notify command;
    private NotifyResponse response;
    private Logger logger = Logger.getLogger(NotifyHandler.class);

    public NotifyHandler(JainMgcpStackImpl stack) {
        super(stack);
    }

    public NotifyHandler(JainMgcpStackImpl stack, InetAddress address, int port) {
        super(stack, address, port);
    }

    public JainMgcpCommandEvent decodeCommand(String message) throws ParseException {
        MgcpMessageParser parser = new MgcpMessageParser(new CommandContentHandle());
        try {
            parser.parse(message);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), -1);
        }
        return this.command;
    }

    public JainMgcpResponseEvent decodeResponse(String message) throws ParseException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Decoding Notify response = " + message));
        }
        MgcpMessageParser parser = new MgcpMessageParser(new ResponseContentHandle());
        try {
            parser.parse(message);
        }
        catch (IOException e) {
            this.logger.error((Object)"Something wrong while parsing the NOTIFY Response received", (Throwable)e);
        }
        return this.response;
    }

    public String encode(JainMgcpCommandEvent event) {
        Notify notify = (Notify)event;
        StringBuffer message = new StringBuffer();
        message.append("NTFY " + event.getTransactionHandle() + " " + notify.getEndpointIdentifier() + " MGCP 1.0\n");
        if (notify.getNotifiedEntity() != null) {
            message.append("N:" + notify.getNotifiedEntity() + "\n");
        }
        message.append("X:" + notify.getRequestIdentifier() + "\n");
        if (notify.getObservedEvents() != null) {
            message.append("O:" + Utils.encodeEventNames(notify.getObservedEvents()) + "\n");
        }
        return message.toString();
    }

    public String encode(JainMgcpResponseEvent event) {
        return event.getReturnCode().getValue() + " " + event.getTransactionHandle() + " " + event.getReturnCode().getComment() + "\n";
    }

    public JainMgcpResponseEvent getProvisionalResponse() {
        NotifyResponse provisionalresponse = null;
        if (!this.sent) {
            provisionalresponse = new NotifyResponse(this.commandEvent.getSource(), ReturnCode.Transaction_Being_Executed);
        }
        return provisionalresponse;
    }

    private class ResponseContentHandle
    implements MgcpContentHandler {
        private ResponseContentHandle() {
        }

        public void header(String header) throws ParseException {
            String[] tokens = header.split("\\s");
            int tid = Integer.parseInt(tokens[1]);
            NotifyHandler.this.response = new NotifyResponse((Object)NotifyHandler.this.stack, Utils.decodeReturnCode(Integer.parseInt(tokens[0])));
            NotifyHandler.this.response.setTransactionHandle(tid);
        }

        public void param(String name, String value) throws ParseException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void sessionDescription(String sd) throws ParseException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class CommandContentHandle
    implements MgcpContentHandler {
        private CommandContentHandle() {
        }

        public void header(String header) throws ParseException {
            String[] tokens = header.split("\\s");
            String verb = tokens[0].trim();
            String transactionID = tokens[1].trim();
            String version = tokens[3].trim() + " " + tokens[4].trim();
            int tid = Integer.parseInt(transactionID);
            EndpointIdentifier endpoint = Utils.decodeEndpointIdentifier(tokens[2].trim());
            NotifyHandler.this.command = new Notify(NotifyHandler.this.getObjectSource(tid), endpoint, new RequestIdentifier("0"), new EventName[0]);
            NotifyHandler.this.command.setTransactionHandle(tid);
        }

        public void param(String name, String value) throws ParseException {
            if (name.equalsIgnoreCase("N")) {
                NotifyHandler.this.command.setNotifiedEntity(Utils.decodeNotifiedEntity(value));
            } else if (name.equalsIgnoreCase("X")) {
                NotifyHandler.this.command.setRequestIdentifier(new RequestIdentifier(value));
            } else if (name.equalsIgnoreCase("O")) {
                NotifyHandler.this.command.setObservedEvents(Utils.decodeEventNames(value));
            }
        }

        public void sessionDescription(String sd) throws ParseException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

