/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.media.local;

import org.mobicents.mscontrol.MsLink;
import org.mobicents.mscontrol.MsLinkEvent;
import org.mobicents.mscontrol.MsLinkListener;
import org.mobicents.slee.resource.media.local.MsLinkEventLocal;
import org.mobicents.slee.resource.media.local.MsLinkLocal;
import org.mobicents.slee.resource.media.local.MsProviderLocal;
import org.mobicents.slee.resource.media.local.MsSessionLocal;

public class MsLinkEventProxy
implements MsLinkListener {
    private MsProviderLocal provider;

    protected MsLinkEventProxy(MsProviderLocal provider) {
        this.provider = provider;
    }

    public void linkCreated(MsLinkEvent evt) {
        MsSessionLocal session = (MsSessionLocal)this.provider.sessions.get(evt.getSource().getSession().getId());
        MsLinkLocal link = new MsLinkLocal(session, evt.getSource());
        session.links.put(link.getId(), link);
        MsLinkEventLocal event = new MsLinkEventLocal(evt, link);
        this.provider.ra.linkCreated(event);
        session.linkActivityCreated();
    }

    public void linkConnected(MsLinkEvent evt) {
        MsSessionLocal session = (MsSessionLocal)this.provider.sessions.get(evt.getSource().getSession().getId());
        MsLink link = session.links.get(evt.getSource().getId());
        MsLinkEventLocal event = new MsLinkEventLocal(evt, link);
        this.provider.ra.linkConnected(event);
    }

    public void linkDisconnected(MsLinkEvent evt) {
        String eventSessionId = evt.getSource().getSession().getId();
        MsSessionLocal session = (MsSessionLocal)this.provider.sessions.get(eventSessionId);
        MsLink link = null;
        link = session != null ? session.links.remove(evt.getSource().getId()) : evt.getSource();
        MsLinkEventLocal event = new MsLinkEventLocal(evt, link);
        this.provider.ra.linkDisconnected(event);
    }

    public void linkFailed(MsLinkEvent evt) {
        MsSessionLocal session = (MsSessionLocal)this.provider.sessions.get(evt.getSource().getSession().getId());
        MsLink link = session.links.get(evt.getSource().getId());
        MsLinkEventLocal event = new MsLinkEventLocal(evt, link);
        this.provider.ra.linkFailed(event);
    }

    public void modeHalfDuplex(MsLinkEvent evt) {
        MsSessionLocal session = (MsSessionLocal)this.provider.sessions.get(evt.getSource().getSession().getId());
        MsLink link = session.links.get(evt.getSource().getId());
        MsLinkEventLocal event = new MsLinkEventLocal(evt, link);
        this.provider.ra.modeHalfDuplex(event);
    }

    public void modeFullDuplex(MsLinkEvent evt) {
        MsSessionLocal session = (MsSessionLocal)this.provider.sessions.get(evt.getSource().getSession().getId());
        MsLink link = session.links.get(evt.getSource().getId());
        MsLinkEventLocal event = new MsLinkEventLocal(evt, link);
        this.provider.ra.modeFullDuplex(event);
    }
}

