/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.media.local;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.mobicents.mscontrol.MsConnection;
import org.mobicents.mscontrol.MsConnectionListener;
import org.mobicents.mscontrol.MsLink;
import org.mobicents.mscontrol.MsLinkListener;
import org.mobicents.mscontrol.MsNotificationListener;
import org.mobicents.mscontrol.MsProvider;
import org.mobicents.mscontrol.MsResourceListener;
import org.mobicents.mscontrol.MsSession;
import org.mobicents.mscontrol.MsSessionEvent;
import org.mobicents.mscontrol.MsSessionEventCause;
import org.mobicents.mscontrol.MsSessionEventID;
import org.mobicents.mscontrol.MsSessionListener;
import org.mobicents.mscontrol.events.MsEventFactory;
import org.mobicents.slee.resource.media.local.MsConnectionEventProxy;
import org.mobicents.slee.resource.media.local.MsLinkEventProxy;
import org.mobicents.slee.resource.media.local.MsSessionEventLocal;
import org.mobicents.slee.resource.media.local.MsSessionLocal;
import org.mobicents.slee.resource.media.ra.MediaResourceAdaptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MsProviderLocal
implements MsProvider,
MsSessionListener {
    private MsProvider provider;
    protected MediaResourceAdaptor ra;
    protected ConcurrentHashMap sessions = new ConcurrentHashMap();

    public MsProviderLocal(MsProvider provider, MediaResourceAdaptor ra) {
        this.provider = provider;
        this.ra = ra;
        provider.addNotificationListener((MsNotificationListener)ra);
        provider.addSessionListener((MsSessionListener)this);
        provider.addConnectionListener((MsConnectionListener)new MsConnectionEventProxy(this));
        provider.addLinkListener((MsLinkListener)new MsLinkEventProxy(this));
        provider.addResourceListener((MsResourceListener)ra);
    }

    public void addSessionListener(MsSessionListener listener) {
        throw new SecurityException("addSessionListener is unsupported. Use event handlers of SBB");
    }

    public void removeSessionListener(MsSessionListener listener) {
        throw new SecurityException("removeSessionListener is unsupported.");
    }

    public void addNotificationListener(MsNotificationListener listener) {
        throw new SecurityException("addNotificationListener is unsupported. Use event handlers of SBB");
    }

    public void removeNotificationListener(MsNotificationListener listener) {
        throw new SecurityException("removeNotificationListener is unsupported.");
    }

    public void addConnectionListener(MsConnectionListener connectionListener) {
        throw new SecurityException("addConnectionListener is unsupported. Use event handlers of SBB");
    }

    public void removeConnectionListener(MsConnectionListener listener) {
        throw new SecurityException("removeConnectionListener is unsupported.");
    }

    public void addResourceListener(MsResourceListener listener) {
        throw new SecurityException("addResourceListener is unsupported. Use event handlers of SBB");
    }

    public void addLinkListener(MsLinkListener listener) {
        throw new SecurityException("addLinkListener is unsupported. Use event handlers of SBB");
    }

    public void removeLinkListener(MsLinkListener listener) {
        throw new SecurityException("removeLinkListener is unsupported.");
    }

    public MsSession createSession() {
        MsSession s = this.provider.createSession();
        MsSessionLocal session = new MsSessionLocal(s, this);
        this.sessions.put(session.getId(), session);
        MsSessionEventLocal event = new MsSessionEventLocal(MsSessionEventID.SESSION_CREATED, MsSessionEventCause.SESSION_CREATED, session);
        this.ra.sessionCreated(event);
        return session;
    }

    public MsConnection getMsConnection(String msConnectionId) {
        return this.provider.getMsConnection(msConnectionId);
    }

    public List<MsConnection> getMsConnections(String endpointName) {
        return this.provider.getMsConnections(endpointName);
    }

    public List<MsLink> getMsLinks(String endpointName) {
        return this.provider.getMsLinks(endpointName);
    }

    public void sessionCreated(MsSessionEvent evt) {
    }

    public void sessionActive(MsSessionEvent evt) {
        MsSession session = (MsSession)this.sessions.get(evt.getSource().getId());
        MsSessionEventLocal event = new MsSessionEventLocal(evt, session);
        this.ra.sessionActive(event);
    }

    public void sessionInvalid(MsSessionEvent evt) {
        MsSession session = (MsSession)this.sessions.remove(evt.getSource().getId());
        MsSessionEventLocal event = new MsSessionEventLocal(evt, session);
        this.ra.sessionInvalid(event);
    }

    public MsEventFactory getEventFactory() {
        return this.provider.getEventFactory();
    }
}

