/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.media.local;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.mobicents.mscontrol.MsConnection;
import org.mobicents.mscontrol.MsConnectionEventCause;
import org.mobicents.mscontrol.MsConnectionEventID;
import org.mobicents.mscontrol.MsLink;
import org.mobicents.mscontrol.MsLinkMode;
import org.mobicents.mscontrol.MsProvider;
import org.mobicents.mscontrol.MsSession;
import org.mobicents.mscontrol.MsSessionListener;
import org.mobicents.mscontrol.MsSessionState;
import org.mobicents.slee.resource.media.local.MsConnectionEventLocal;
import org.mobicents.slee.resource.media.local.MsConnectionLocal;
import org.mobicents.slee.resource.media.local.MsProviderLocal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MsSessionLocal
implements MsSession {
    private MsSession session;
    private MsProviderLocal provider;
    protected ConcurrentHashMap<String, MsConnection> connections = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, MsLink> links = new ConcurrentHashMap();
    private ReentrantLock blockState = new ReentrantLock();
    private Condition connectionActivityCreated = this.blockState.newCondition();
    private Condition linkActivityCreated = this.blockState.newCondition();

    protected MsSessionLocal(MsSession session, MsProviderLocal provider) {
        this.session = session;
        this.provider = provider;
    }

    public String getId() {
        return this.session.getId();
    }

    public MsProvider getProvider() {
        return this.provider;
    }

    public MsSessionState getState() {
        return this.session.getState();
    }

    public MsConnection createNetworkConnection(String endpointName) {
        MsConnection c = this.session.createNetworkConnection(endpointName);
        MsConnectionLocal connection = new MsConnectionLocal(this, c);
        this.connections.put(connection.getId(), connection);
        MsConnectionEventLocal evt = new MsConnectionEventLocal(MsConnectionEventID.CONNECTION_CREATED, MsConnectionEventCause.NORMAL, connection);
        this.provider.ra.connectionCreated(evt);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MsLink createLink(MsLinkMode mode) {
        this.blockState.lock();
        try {
            MsLink link = this.session.createLink(mode);
            while (!this.links.containsKey(link.getId())) {
                try {
                    this.linkActivityCreated.await();
                }
                catch (InterruptedException e) {
                    link.release();
                    MsLink msLink = null;
                    this.blockState.unlock();
                    return msLink;
                }
            }
            MsLink msLink = this.links.get(link.getId());
            return msLink;
        }
        finally {
            this.blockState.unlock();
        }
    }

    public void addSessionListener(MsSessionListener listener) {
        throw new SecurityException("addSessionListener is unsupported. Use event handlers of SBB");
    }

    public void removeSessionListener(MsSessionListener listener) {
        throw new SecurityException("removeSessionListener is unsupported.");
    }

    public List<MsConnection> getConnections() {
        Collection<MsConnection> values = this.connections.values();
        ArrayList<MsConnection> list = new ArrayList<MsConnection>();
        for (MsConnection connection : values) {
            list.add(connection);
        }
        return list;
    }

    public List<MsLink> getLinks() {
        Collection<MsLink> values = this.links.values();
        ArrayList<MsLink> list = new ArrayList<MsLink>();
        for (MsLink link : values) {
            list.add(link);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionActivityCreated() {
        this.blockState.lock();
        try {
            this.connectionActivityCreated.signalAll();
        }
        finally {
            this.blockState.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkActivityCreated() {
        this.blockState.lock();
        try {
            this.linkActivityCreated.signalAll();
        }
        finally {
            this.blockState.unlock();
        }
    }

    public String toString() {
        return this.session.toString();
    }
}

