/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.media.ra;

import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import javax.slee.Address;
import javax.slee.AddressPlan;
import javax.slee.UnrecognizedActivityException;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ActivityIsEndingException;
import javax.slee.resource.BootstrapContext;
import javax.slee.resource.FailureReason;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceException;
import javax.slee.resource.SleeEndpoint;
import org.apache.log4j.Logger;
import org.mobicents.mscontrol.MsConnection;
import org.mobicents.mscontrol.MsConnectionEvent;
import org.mobicents.mscontrol.MsConnectionListener;
import org.mobicents.mscontrol.MsLink;
import org.mobicents.mscontrol.MsLinkEvent;
import org.mobicents.mscontrol.MsLinkListener;
import org.mobicents.mscontrol.MsNotificationListener;
import org.mobicents.mscontrol.MsNotifyEvent;
import org.mobicents.mscontrol.MsProvider;
import org.mobicents.mscontrol.MsResourceListener;
import org.mobicents.mscontrol.MsSession;
import org.mobicents.mscontrol.MsSessionEvent;
import org.mobicents.mscontrol.MsSessionListener;
import org.mobicents.mscontrol.impl.MsProviderImpl;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.resource.ResourceAdaptorActivityContextInterfaceFactory;
import org.mobicents.slee.resource.ResourceAdaptorEntity;
import org.mobicents.slee.resource.ResourceAdaptorTypeIDImpl;
import org.mobicents.slee.resource.media.local.MsProviderLocal;
import org.mobicents.slee.resource.media.ra.EventIDCache;
import org.mobicents.slee.resource.media.ra.MediaActivityHandle;
import org.mobicents.slee.resource.media.ra.MediaRaActivityContextInterfaceFactoryImpl;
import org.mobicents.slee.resource.media.ratype.MediaRaActivityContextInterfaceFactory;

public class MediaResourceAdaptor
implements ResourceAdaptor,
MsConnectionListener,
MsResourceListener,
MsLinkListener,
MsSessionListener,
MsNotificationListener {
    private static final transient Logger logger = Logger.getLogger(MediaResourceAdaptor.class);
    public Properties properties;
    private MsProviderLocal msProvider;
    private transient ConcurrentHashMap activities = new ConcurrentHashMap();
    private static final Address address = new Address(AddressPlan.IP, "localhost");
    private static final transient EventIDCache eventIdCache = new EventIDCache();
    private transient BootstrapContext bootstrapContext = null;
    private transient SleeEndpoint sleeEndpoint = null;
    private transient EventLookupFacility eventLookup = null;
    private transient MediaRaActivityContextInterfaceFactory acif = null;

    public void entityCreated(BootstrapContext bootstrapContext) throws ResourceException {
        this.bootstrapContext = bootstrapContext;
        this.sleeEndpoint = bootstrapContext.getSleeEndpoint();
        this.eventLookup = bootstrapContext.getEventLookupFacility();
    }

    public void entityRemoved() {
    }

    public void entityActivated() throws ResourceException {
        try {
            MsProviderImpl provider = new MsProviderImpl();
            this.msProvider = new MsProviderLocal((MsProvider)provider, this);
            this.initializeNamingContext();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ResourceException("MediaResourceAdaptor.entityActivated(): Failed to activate RAFrame Resource Adaptor!", (Throwable)e);
        }
    }

    public void entityDeactivating() {
    }

    public void entityDeactivated() {
        try {
            this.cleanNamingContext();
        }
        catch (NamingException e) {
            logger.error((Object)"Cannot unbind naming context", (Throwable)e);
        }
    }

    public void eventProcessingSuccessful(ActivityHandle handle, Object event, int eventID, Address address, int flags) {
    }

    public void eventProcessingFailed(ActivityHandle handle, Object event, int eventID, Address address, int flags, FailureReason reason) {
    }

    public void activityEnded(ActivityHandle activityHandle) {
        Object activity = this.activities.remove(activityHandle);
    }

    public void activityUnreferenced(ActivityHandle activityHandle) {
    }

    public void queryLiveness(ActivityHandle activityHandle) {
        if (this.activities.contains(activityHandle)) {
            try {
                this.sleeEndpoint.activityEnding(activityHandle);
            }
            catch (Exception e) {
                logger.error((Object)"Unexpected error while ending activity", (Throwable)e);
            }
        }
    }

    public Object getActivity(ActivityHandle activityHandle) {
        return this.activities.get(activityHandle);
    }

    public ActivityHandle getActivityHandle(Object activity) {
        return null;
    }

    public Object getSBBResourceAdaptorInterface(String className) {
        return this.msProvider;
    }

    public Marshaler getMarshaler() {
        return null;
    }

    public void serviceInstalled(String serviceKey, int[] eventIDs, String[] resourceOptions) {
    }

    public void serviceUninstalled(String serviceKey) {
    }

    public void serviceActivated(String arg0) {
    }

    public void serviceDeactivated(String arg0) {
    }

    private void initializeNamingContext() throws NamingException {
        SleeContainer container = SleeContainer.lookupFromJndi();
        String entityName = this.bootstrapContext.getEntityName();
        ResourceAdaptorEntity resourceAdaptorEntity = container.getResourceAdaptorEnitity(entityName);
        ResourceAdaptorTypeIDImpl raTypeId = resourceAdaptorEntity.getInstalledResourceAdaptor().getRaType().getResourceAdaptorTypeID();
        this.acif = new MediaRaActivityContextInterfaceFactoryImpl(resourceAdaptorEntity.getServiceContainer(), entityName, this);
        resourceAdaptorEntity.getServiceContainer().getActivityContextInterfaceFactories().put(raTypeId, this.acif);
        try {
            if (this.acif != null) {
                String jndiName = ((ResourceAdaptorActivityContextInterfaceFactory)this.acif).getJndiName();
                int begind = jndiName.indexOf(58);
                int toind = jndiName.lastIndexOf(47);
                String prefix = jndiName.substring(begind + 1, toind);
                String name = jndiName.substring(toind + 1);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("jndiName prefix =" + prefix + "; jndiName = " + name));
                }
                SleeContainer.registerWithJndi((String)prefix, (String)name, (Object)this.acif);
            }
        }
        catch (IndexOutOfBoundsException e) {
            logger.warn((Object)e);
        }
    }

    private void cleanNamingContext() throws NamingException {
        block4: {
            try {
                if (this.acif != null) {
                    String jndiName = ((ResourceAdaptorActivityContextInterfaceFactory)this.acif).getJndiName();
                    int begind = jndiName.indexOf(58);
                    String javaJNDIName = jndiName.substring(begind + 1);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("JNDI name to unregister: " + javaJNDIName));
                    }
                    SleeContainer.unregisterWithJndi((String)javaJNDIName);
                }
            }
            catch (IndexOutOfBoundsException e) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug((Object)e);
            }
        }
    }

    private synchronized void fireEvent(String eventName, ActivityHandle activityHandle, Object event) {
        int eventID = -1;
        eventID = eventIdCache.getEventId(this.eventLookup, eventName, "org.mobicents.media", "1.0");
        if (eventID == -1) {
            logger.warn((Object)("Unknown event type: " + eventName));
            return;
        }
        try {
            this.sleeEndpoint.fireEvent(activityHandle, event, eventID, address);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Fire event: " + eventName));
            }
        }
        catch (IllegalStateException ise) {
            logger.error((Object)"Caught an IllegalStateException: ");
            ise.printStackTrace();
        }
        catch (ActivityIsEndingException aiee) {
            logger.error((Object)"Caught an ActivityIsEndingException: ");
            aiee.printStackTrace();
        }
        catch (UnrecognizedActivityException uaee) {
            logger.error((Object)"Caught an UnrecognizedActivityException: ");
            uaee.printStackTrace();
        }
    }

    SleeEndpoint getSleeEndpoint() {
        return this.sleeEndpoint;
    }

    public synchronized void update(MsNotifyEvent event) {
        Object source = event.getSource();
        MediaActivityHandle handle = new MediaActivityHandle(source.toString());
        this.fireEvent(event.getEventID().getFqn(), handle, event);
    }

    public synchronized void linkCreated(MsLinkEvent evt) {
        MsLink link = evt.getSource();
        MediaActivityHandle handle = new MediaActivityHandle(link.getId());
        this.activities.put(handle, link);
        this.fireEvent("org.mobicents.slee.media.LINK_CREATED", handle, evt);
    }

    public synchronized void linkConnected(MsLinkEvent evt) {
        MsLink link = evt.getSource();
        MediaActivityHandle handle = new MediaActivityHandle(link.getId());
        this.fireEvent("org.mobicents.slee.media.LINK_CONNECTED", handle, evt);
    }

    public synchronized void linkDisconnected(MsLinkEvent evt) {
        MsLink link = evt.getSource();
        MediaActivityHandle handle = new MediaActivityHandle(link.getId());
        this.fireEvent("org.mobicents.slee.media.LINK_DISCONNECTED", handle, evt);
        try {
            this.sleeEndpoint.activityEnding((ActivityHandle)handle);
        }
        catch (Exception e) {
            logger.error((Object)("Could not end activity: " + link));
        }
    }

    public synchronized void linkFailed(MsLinkEvent evt) {
        MsLink link = evt.getSource();
        MediaActivityHandle handle = new MediaActivityHandle(link.getId());
        this.fireEvent("org.mobicents.slee.media.LINK_FAILED", handle, evt);
    }

    public synchronized void modeHalfDuplex(MsLinkEvent evt) {
        MsLink link = evt.getSource();
        MediaActivityHandle handle = new MediaActivityHandle(link.getId());
        this.fireEvent("org.mobicents.slee.media.LINK_MODE_HALF_DUPLEX", handle, evt);
    }

    public synchronized void modeFullDuplex(MsLinkEvent evt) {
        MsLink link = evt.getSource();
        MediaActivityHandle handle = new MediaActivityHandle(link.getId());
        this.fireEvent("org.mobicents.slee.media.LINK_MODE_FULL_DUPLEX", handle, evt);
    }

    public synchronized void connectionCreated(MsConnectionEvent evt) {
        MsConnection connection = evt.getConnection();
        MediaActivityHandle handle = new MediaActivityHandle(connection.getId());
        this.activities.put(handle, connection);
        this.fireEvent("org.mobicents.slee.media.CONNECTION_CREATED", handle, evt);
    }

    public synchronized void connectionHalfOpen(MsConnectionEvent evt) {
        MsConnection connection = evt.getConnection();
        MediaActivityHandle handle = new MediaActivityHandle(connection.getId());
        this.fireEvent("org.mobicents.slee.media.CONNECTION_HALF_OPEN", handle, evt);
    }

    public synchronized void connectionOpen(MsConnectionEvent evt) {
        MsConnection connection = evt.getConnection();
        MediaActivityHandle handle = new MediaActivityHandle(connection.getId());
        this.fireEvent("org.mobicents.slee.media.CONNECTION_OPEN", handle, evt);
    }

    public synchronized void connectionFailed(MsConnectionEvent evt) {
        MsConnection connection = evt.getConnection();
        MediaActivityHandle handle = new MediaActivityHandle(connection.getId());
        this.fireEvent("org.mobicents.slee.media.CONNECTION_FAILED", handle, evt);
    }

    public synchronized void connectionDisconnected(MsConnectionEvent evt) {
        MsConnection connection = evt.getConnection();
        MediaActivityHandle handle = new MediaActivityHandle(connection.getId());
        this.fireEvent("org.mobicents.slee.media.CONNECTION_DISCONNECTED", handle, evt);
        try {
            this.sleeEndpoint.activityEnding((ActivityHandle)handle);
        }
        catch (Exception e) {
            logger.error((Object)("Could not end activity: " + connection));
        }
    }

    public synchronized void connectionModeRecvOnly(MsConnectionEvent evt) {
        MsConnection connection = evt.getConnection();
        MediaActivityHandle handle = new MediaActivityHandle(connection.getId());
        this.fireEvent("org.mobicents.slee.media.CONNECTION_MODE_RECV_ONLY", handle, evt);
    }

    public synchronized void connectionModeSendOnly(MsConnectionEvent evt) {
        MsConnection connection = evt.getConnection();
        MediaActivityHandle handle = new MediaActivityHandle(connection.getId());
        this.fireEvent("org.mobicents.slee.media.CONNECTION_MODE_SEND_ONLY", handle, evt);
    }

    public synchronized void connectionModeSendRecv(MsConnectionEvent evt) {
        MsConnection connection = evt.getConnection();
        MediaActivityHandle handle = new MediaActivityHandle(connection.getId());
        this.fireEvent("org.mobicents.slee.media.CONNECTION_MODE_SEND_RECV", handle, evt);
    }

    public synchronized void sessionCreated(MsSessionEvent evt) {
        MsSession session = evt.getSource();
        MediaActivityHandle handle = new MediaActivityHandle(session.getId());
        this.activities.put(handle, session);
        this.fireEvent("org.mobicents.slee.media.SESSION_CREATED", handle, evt);
    }

    public synchronized void sessionActive(MsSessionEvent evt) {
        MsSession session = evt.getSource();
        MediaActivityHandle handle = new MediaActivityHandle(session.getId());
        this.fireEvent("org.mobicents.slee.media.SESSION_ACTIVE", handle, evt);
    }

    public synchronized void sessionInvalid(MsSessionEvent evt) {
        MsSession session = evt.getSource();
        MediaActivityHandle handle = new MediaActivityHandle(session.getId());
        this.fireEvent("org.mobicents.slee.media.SESSION_INVALID", handle, evt);
        try {
            this.sleeEndpoint.activityEnding((ActivityHandle)handle);
        }
        catch (Exception e) {
            logger.error((Object)("Could not end activity: " + session));
        }
    }

    public void resourceCreated(MsNotifyEvent notifyEvent) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void resourceInvalid(MsNotifyEvent notifyEvent) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

