/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.examples.callcontrol.profile;

import javax.slee.Address;
import javax.slee.AddressPlan;
import javax.slee.profile.ProfileManagement;
import javax.slee.profile.ProfileVerificationException;
import org.mobicents.slee.examples.callcontrol.profile.CallControlProfileCMP;

public abstract class CallControlProfileManagementImpl
implements ProfileManagement,
CallControlProfileCMP {
    public void profileInitialize() {
        this.setUserAddress(null);
        this.setBlockedAddresses(null);
        this.setBackupAddress(null);
        this.setVoicemailState(false);
    }

    public void profileLoad() {
    }

    public void profileStore() {
    }

    public void profileVerify() throws ProfileVerificationException {
        Address backupAddress;
        Address[] blockedAddresses;
        Address address = this.getUserAddress();
        if (address != null) {
            this.verifyAddress(address);
        }
        if ((blockedAddresses = this.getBlockedAddresses()) != null) {
            for (int i = 0; i < blockedAddresses.length; ++i) {
                if (blockedAddresses[i] == null) continue;
                this.verifyAddress(blockedAddresses[i]);
            }
        }
        if ((backupAddress = this.getBackupAddress()) != null) {
            this.verifyAddress(backupAddress);
        }
    }

    public void verifyAddress(Address address) throws ProfileVerificationException {
        if (address.getAddressPlan() != AddressPlan.SIP) {
            throw new ProfileVerificationException("Address \"" + address + "\" is not a SIP address");
        }
        String uri = address.getAddressString().toLowerCase();
        if (!uri.startsWith("sip:") && !uri.startsWith("sips:")) {
            throw new ProfileVerificationException("Address \"" + address + "\" is not a SIP address");
        }
    }
}

