/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mgcp.demo;

import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.message.CreateConnection;
import jain.protocol.ip.mgcp.message.CreateConnectionResponse;
import jain.protocol.ip.mgcp.message.DeleteConnection;
import jain.protocol.ip.mgcp.message.ModifyConnection;
import jain.protocol.ip.mgcp.message.ModifyConnectionResponse;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionDescriptor;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionMode;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.text.ParseException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.ToHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.ActivityContextInterface;
import javax.slee.CreateException;
import javax.slee.FactoryException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.UnrecognizedActivityException;
import net.java.slee.resource.mgcp.JainMgcpProvider;
import net.java.slee.resource.mgcp.MgcpActivityContextInterfaceFactory;
import net.java.slee.resource.mgcp.MgcpConnectionActivity;
import net.java.slee.resource.sip.DialogActivity;
import net.java.slee.resource.sip.SipActivityContextInterfaceFactory;
import net.java.slee.resource.sip.SleeSipProvider;
import org.apache.log4j.Logger;

public abstract class MDCXSbb
implements Sbb {
    private static final Logger logger = Logger.getLogger(MDCXSbb.class);
    public static final String ENDPOINT_NAME = "media/test/trunk/Loopback/$";
    public static final String JBOSS_BIND_ADDRESS = System.getProperty("jboss.bind.address", "127.0.0.1");
    private SbbContext sbbContext;
    private SleeSipProvider provider;
    private AddressFactory addressFactory;
    private HeaderFactory headerFactory;
    private MessageFactory messageFactory;
    private SipActivityContextInterfaceFactory acif;
    private JainMgcpProvider mgcpProvider;
    private MgcpActivityContextInterfaceFactory mgcpAcif;

    public void onCallCreated(RequestEvent evt, ActivityContextInterface aci) {
        Request request = evt.getRequest();
        FromHeader from = (FromHeader)request.getHeader("From");
        ToHeader to = (ToHeader)request.getHeader("To");
        logger.info((Object)("Incoming call " + from + " " + to));
        ActivityContextInterface daci = null;
        try {
            Dialog dialog = this.provider.getNewDialog((Transaction)evt.getServerTransaction());
            dialog.terminateOnBye(true);
            daci = this.acif.getActivityContextInterface((DialogActivity)dialog);
            daci.attach(this.sbbContext.getSbbLocalObject());
        }
        catch (Exception e) {
            logger.error((Object)"Error during dialog creation", (Throwable)e);
            this.respond(evt, 500);
            return;
        }
        String remoteSdp = new String(evt.getRequest().getRawContent());
        this.setRemoteSdp(remoteSdp);
        CallIdentifier callID = this.mgcpProvider.getUniqueCallIdentifier();
        this.setCallIdentifier(callID.toString());
        EndpointIdentifier endpointID = new EndpointIdentifier(ENDPOINT_NAME, JBOSS_BIND_ADDRESS + ":2729");
        CreateConnection createConnection = new CreateConnection((Object)this, callID, endpointID, ConnectionMode.SendRecv);
        createConnection.setTransactionHandle(this.mgcpProvider.getUniqueTransactionHandler());
        MgcpConnectionActivity connectionActivity = null;
        try {
            connectionActivity = this.mgcpProvider.getConnectionActivity(createConnection.getTransactionHandle(), endpointID);
            ActivityContextInterface epnAci = this.mgcpAcif.getActivityContextInterface(connectionActivity);
            epnAci.attach(this.sbbContext.getSbbLocalObject());
        }
        catch (FactoryException ex) {
            ex.printStackTrace();
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
        }
        catch (UnrecognizedActivityException ex) {
            ex.printStackTrace();
        }
        this.mgcpProvider.sendMgcpEvents(new JainMgcpEvent[]{createConnection});
    }

    public void onCreateConnectionResponse(CreateConnectionResponse event, ActivityContextInterface aci) throws ParseException {
        logger.info((Object)("Receive CRCX response: " + event.getTransactionHandle()));
        ServerTransaction txn = this.getServerTransaction();
        Request request = txn.getRequest();
        ReturnCode status = event.getReturnCode();
        switch (status.getValue()) {
            case 200: {
                this.setConnectionIdentifier(event.getConnectionIdentifier().toString());
                CallIdentifier callIdentifier = new CallIdentifier(this.getCallIdentifier());
                EndpointIdentifier endpointID = ((MgcpConnectionActivity)aci.getActivity()).getEndpointIdentifier();
                ModifyConnection modifyConnection = new ModifyConnection((Object)this, callIdentifier, endpointID, event.getConnectionIdentifier());
                ConnectionDescriptor connectionDescriptor = new ConnectionDescriptor(this.getRemoteSdp());
                modifyConnection.setRemoteConnectionDescriptor(connectionDescriptor);
                modifyConnection.setTransactionHandle(this.mgcpProvider.getUniqueTransactionHandler());
                this.mgcpProvider.sendMgcpEvents(new JainMgcpEvent[]{modifyConnection});
                break;
            }
            default: {
                logger.error((Object)("CRCX did not go successfully " + status.getValue()));
                try {
                    Response response = this.messageFactory.createResponse(500, request);
                    txn.sendResponse(response);
                    break;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    public void onModifyConnectionResponse(ModifyConnectionResponse event, ActivityContextInterface aci) {
        logger.info((Object)("Receive MDCX response: " + event.getTransactionHandle()));
        ContentTypeHeader contentType = null;
        ServerTransaction txn = this.getServerTransaction();
        Response response = null;
        Request request = txn.getRequest();
        String sdp = event.getLocalConnectionDescriptor().toString();
        try {
            contentType = this.headerFactory.createContentTypeHeader("application", "sdp");
        }
        catch (ParseException ex) {
            // empty catch block
        }
        String localAddress = this.provider.getListeningPoints()[0].getIPAddress();
        int localPort = this.provider.getListeningPoints()[0].getPort();
        Address contactAddress = null;
        try {
            contactAddress = this.addressFactory.createAddress("sip:" + localAddress + ":" + localPort);
        }
        catch (ParseException ex) {
            // empty catch block
        }
        ContactHeader contact = this.headerFactory.createContactHeader(contactAddress);
        try {
            response = this.messageFactory.createResponse(200, request, contentType, sdp.getBytes());
        }
        catch (ParseException ex) {
            logger.error((Object)"ParseException while trying to create the OK Response for MDCX", (Throwable)ex);
        }
        response.setHeader((Header)contact);
        try {
            txn.sendResponse(response);
        }
        catch (InvalidArgumentException ex) {
            logger.error((Object)"InvalidArgumentException while trying to send the OK Response for MDCX", (Throwable)ex);
        }
        catch (SipException ex) {
            logger.error((Object)"SipException while trying to send the OK Response for MDCX", (Throwable)ex);
        }
    }

    public void onCallTerminated(RequestEvent evt, ActivityContextInterface aci) {
        try {
            EndpointIdentifier endpointID = this.getMgcpConnectionActivity().getEndpointIdentifier();
            DeleteConnection deleteConnection = new DeleteConnection((Object)this, endpointID);
            deleteConnection.setConnectionIdentifier(new ConnectionIdentifier(this.getConnectionIdentifier()));
            deleteConnection.setTransactionHandle(this.mgcpProvider.getUniqueTransactionHandler());
            this.mgcpProvider.sendMgcpEvents(new JainMgcpEvent[]{deleteConnection});
            ServerTransaction tx = evt.getServerTransaction();
            Request request = evt.getRequest();
            Response response = this.messageFactory.createResponse(200, request);
            tx.sendResponse(response);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void respond(RequestEvent evt, int cause) {
        Request request = evt.getRequest();
        ServerTransaction tx = evt.getServerTransaction();
        try {
            Response response = this.messageFactory.createResponse(cause, request);
            tx.sendResponse(response);
        }
        catch (Exception e) {
            logger.warn((Object)"Unexpected error: ", (Throwable)e);
        }
    }

    private ServerTransaction getServerTransaction() {
        ActivityContextInterface[] activities;
        for (ActivityContextInterface activity : activities = this.sbbContext.getActivities()) {
            if (!(activity.getActivity() instanceof ServerTransaction)) continue;
            return (ServerTransaction)activity.getActivity();
        }
        return null;
    }

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = sbbContext;
        try {
            Context ctx = (Context)new InitialContext().lookup("java:comp/env");
            this.provider = (SleeSipProvider)ctx.lookup("slee/resources/jainsip/1.2/provider");
            this.addressFactory = this.provider.getAddressFactory();
            this.headerFactory = this.provider.getHeaderFactory();
            this.messageFactory = this.provider.getMessageFactory();
            this.acif = (SipActivityContextInterfaceFactory)ctx.lookup("slee/resources/jainsip/1.2/acifactory");
            this.mgcpProvider = (JainMgcpProvider)ctx.lookup("slee/resources/jainmgcp/2.0/provider/demo");
            this.mgcpAcif = (MgcpActivityContextInterfaceFactory)ctx.lookup("slee/resources/jainmgcp/2.0/acifactory/demo");
        }
        catch (Exception ne) {
            logger.error((Object)"Could not set SBB context:", (Throwable)ne);
        }
    }

    public abstract String getConnectionIdentifier();

    public abstract void setConnectionIdentifier(String var1);

    public abstract String getCallIdentifier();

    public abstract void setCallIdentifier(String var1);

    public abstract String getRemoteSdp();

    public abstract void setRemoteSdp(String var1);

    public void unsetSbbContext() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbActivate() {
    }

    public void sbbPassivate() {
    }

    public void sbbLoad() {
    }

    public void sbbStore() {
    }

    public void sbbRemove() {
    }

    public void sbbExceptionThrown(Exception exception, Object object, ActivityContextInterface activityContextInterface) {
    }

    public void sbbRolledBack(RolledBackContext rolledBackContext) {
    }

    private MgcpConnectionActivity getMgcpConnectionActivity() {
        ActivityContextInterface[] activities;
        for (ActivityContextInterface activity : activities = this.sbbContext.getActivities()) {
            if (!(activity.getActivity() instanceof MgcpConnectionActivity)) continue;
            return (MgcpConnectionActivity)activity.getActivity();
        }
        return null;
    }
}

