/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.ctrl.mgcp;

import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.mobicents.media.server.ctrl.mgcp.ConnectionActivity;
import org.mobicents.media.server.ctrl.mgcp.MgcpController;
import org.mobicents.media.server.ctrl.mgcp.UnknownConnectionException;
import org.mobicents.media.server.spi.Connection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Call
implements Serializable {
    private String id;
    private MgcpController controller;
    private ConcurrentHashMap<String, ConnectionActivity> connections = new ConcurrentHashMap();

    protected Call(String id, MgcpController controller) {
        this.controller = controller;
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    public ConnectionActivity addConnection(Connection connection) {
        ConnectionActivity l = new ConnectionActivity(this, connection);
        this.connections.put(l.getID(), l);
        return l;
    }

    public void removeConnection(String connectionID) throws UnknownConnectionException {
        ConnectionActivity l = this.connections.remove(connectionID);
        if (l == null) {
            throw new UnknownConnectionException(connectionID);
        }
        if (this.connections.isEmpty()) {
            this.controller.removeCall(this.id);
        }
    }

    public Collection<ConnectionActivity> getActivities() {
        return this.connections.values();
    }
}

