/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.ctrl.mgcp;

import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.CreateConnection;
import jain.protocol.ip.mgcp.message.CreateConnectionResponse;
import jain.protocol.ip.mgcp.message.parms.ConnectionDescriptor;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.mobicents.media.server.ctrl.mgcp.Call;
import org.mobicents.media.server.ctrl.mgcp.ConnectionActivity;
import org.mobicents.media.server.ctrl.mgcp.MgcpController;
import org.mobicents.media.server.ctrl.mgcp.MgcpUtils;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.ConnectionMode;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.ResourceUnavailableException;

public class CreateConnectionAction
implements Callable {
    private static final ConnectionIdentifier ERROR_CONNID = new ConnectionIdentifier("0");
    private CreateConnection crcx;
    private MgcpController controller;
    private MgcpUtils utils = new MgcpUtils();
    private static Logger logger = Logger.getLogger(CreateConnectionAction.class);

    protected CreateConnectionAction(MgcpController controller, CreateConnection req) {
        this.controller = controller;
        this.crcx = req;
    }

    private JainMgcpResponseEvent createRtpConnection(CreateConnection crcx) {
        String callID;
        Call call;
        boolean isNewCall;
        int txID = crcx.getTransactionHandle();
        ConnectionMode mode = this.utils.getMode(crcx.getMode());
        if (mode == null) {
            logger.warn((Object)("TX = " + txID + ", Mode " + crcx.getMode() + " is not supported, Response code: " + 517));
            return new CreateConnectionResponse(crcx.getSource(), ReturnCode.Unsupported_Or_Invalid_Mode, ERROR_CONNID);
        }
        String localName = crcx.getEndpointIdentifier().getLocalEndpointName();
        if (localName.contains("*")) {
            logger.warn((Object)("TX = " + txID + ", The endpoint name is underspecified with 'all off' wildcard, Response code: " + 500));
            return new CreateConnectionResponse(crcx.getSource(), ReturnCode.Endpoint_Unknown, ERROR_CONNID);
        }
        Endpoint endpoint = null;
        try {
            endpoint = this.controller.getNamingService().lookup(localName);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TX=" + txID + ", Allocated endpoint: " + endpoint.getLocalName()));
            }
        }
        catch (ResourceUnavailableException e) {
            logger.warn((Object)("TX = " + txID + ", There is no free endpoint: " + localName + ", ResponseCode: " + 500));
            return new CreateConnectionResponse(crcx.getSource(), ReturnCode.Endpoint_Unknown, ERROR_CONNID);
        }
        Connection connection = null;
        try {
            connection = endpoint.createConnection(mode);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TX=" + txID + ", Endpoint: " + endpoint.getLocalName() + ", Created connection "));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            return new CreateConnectionResponse(crcx.getSource(), ReturnCode.Endpoint_Insufficient_Resources, ERROR_CONNID);
        }
        ConnectionDescriptor remoteSdp = crcx.getRemoteConnectionDescriptor();
        if (remoteSdp != null) {
            try {
                connection.setRemoteDescriptor(remoteSdp.toString());
            }
            catch (Exception e) {
                logger.error((Object)e);
                return new CreateConnectionResponse(crcx.getSource(), ReturnCode.Missing_RemoteConnectionDescriptor, ERROR_CONNID);
            }
        }
        boolean bl = isNewCall = (call = this.controller.getCall(callID = crcx.getCallIdentifier().toString())) == null;
        if (isNewCall) {
            call = new Call(callID, this.controller);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TX = " + txID + ", Created new call instance, ID = " + call.getID()));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("TX = " + txID + ", Using existing call instance, ID = " + call.getID()));
        }
        ConnectionActivity connectionActivity = call.addConnection(connection);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created connection activity=" + connectionActivity.getID() + ", origin connection ID =" + connection.getId()));
        }
        ConnectionDescriptor localSDP = new ConnectionDescriptor(connection.getLocalDescriptor());
        ConnectionIdentifier connectionID = new ConnectionIdentifier(connectionActivity.getID());
        CreateConnectionResponse response = new CreateConnectionResponse(crcx.getSource(), ReturnCode.Transaction_Executed_Normally, connectionID);
        response.setSpecificEndpointIdentifier(new EndpointIdentifier(endpoint.getLocalName(), crcx.getEndpointIdentifier().getDomainName()));
        response.setConnectionIdentifier(connectionID);
        response.setLocalConnectionDescriptor(localSDP);
        response.setTransactionHandle(crcx.getTransactionHandle());
        if (isNewCall) {
            this.controller.addCall(call);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Save reference to the callID=" + call.getID()));
            }
        }
        return response;
    }

    private JainMgcpResponseEvent createLink(CreateConnection crcx) {
        boolean isNewCall;
        int txID = crcx.getTransactionHandle();
        ConnectionMode mode = this.utils.getMode(crcx.getMode());
        if (mode == null) {
            logger.warn((Object)("TX = " + txID + ", Mode " + crcx.getMode() + " is not supported, Response code: " + 517));
            return new CreateConnectionResponse(crcx.getSource(), ReturnCode.Unsupported_Or_Invalid_Mode, ERROR_CONNID);
        }
        String localName = crcx.getEndpointIdentifier().getLocalEndpointName();
        if (localName.contains("*")) {
            logger.warn((Object)("TX = " + txID + ", The endpoint name is underspecified with 'all off' wildcard, Response code: " + 500));
            return new CreateConnectionResponse(crcx.getSource(), ReturnCode.Endpoint_Unknown, ERROR_CONNID);
        }
        Endpoint endpoint = null;
        try {
            endpoint = this.controller.getNamingService().lookup(localName, true);
        }
        catch (ResourceUnavailableException e) {
            logger.warn((Object)("TX = " + txID + ", There is no free endpoint: " + localName + ", ResponseCode: " + 500));
            return new CreateConnectionResponse(crcx.getSource(), ReturnCode.Endpoint_Unknown, ERROR_CONNID);
        }
        String callID = crcx.getCallIdentifier().toString();
        Call call = this.controller.getCall(callID);
        boolean bl = isNewCall = call == null;
        if (isNewCall) {
            call = new Call(callID, this.controller);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TX = " + txID + ", Created new call instance, ID = " + call.getID()));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("TX = " + txID + ", Using existing call instance, ID = " + call.getID()));
        }
        Connection connection = null;
        try {
            connection = endpoint.createLocalConnection(mode);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TX=" + txID + ", Endpoint: " + endpoint.getLocalName() + ", Created connection "));
            }
        }
        catch (Exception e) {
            return new CreateConnectionResponse(crcx.getSource(), ReturnCode.Endpoint_Insufficient_Resources, ERROR_CONNID);
        }
        String localName2 = crcx.getSecondEndpointIdentifier().getLocalEndpointName();
        if (localName2.contains("*")) {
            endpoint.deleteConnection(connection.getId());
            logger.warn((Object)("TX = " + txID + ", The endpoint name is underspecified with 'all off' wildcard, Response code: " + 500));
            return new CreateConnectionResponse(crcx.getSource(), ReturnCode.Endpoint_Unknown, ERROR_CONNID);
        }
        Endpoint endpoint2 = null;
        try {
            endpoint2 = this.controller.getNamingService().lookup(localName2, true);
        }
        catch (ResourceUnavailableException e) {
            logger.warn((Object)("TX = " + txID + ", There is no free endpoint: " + localName2 + ", ResponseCode: " + 500));
            return new CreateConnectionResponse(crcx.getSource(), ReturnCode.Endpoint_Unknown, ERROR_CONNID);
        }
        Connection connection2 = null;
        try {
            connection2 = endpoint2.createLocalConnection(ConnectionMode.SEND_RECV);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TX=" + txID + ", Endpoint: " + endpoint2.getLocalName() + ", Created connection "));
            }
        }
        catch (Exception e) {
            endpoint.deleteConnection(connection.getId());
            return new CreateConnectionResponse(crcx.getSource(), ReturnCode.Endpoint_Insufficient_Resources, ERROR_CONNID);
        }
        try {
            connection.setOtherParty(connection2);
        }
        catch (IOException e) {
            endpoint.deleteConnection(connection.getId());
            endpoint2.deleteConnection(connection2.getId());
            return new CreateConnectionResponse(crcx.getSource(), ReturnCode.Endpoint_Insufficient_Resources, ERROR_CONNID);
        }
        ConnectionActivity connectionActivity = call.addConnection(connection);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created connection activity=" + connectionActivity.getID() + ", origin connection ID =" + connection.getId()));
        }
        ConnectionActivity connectionActivity2 = call.addConnection(connection2);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created connection activity=" + connectionActivity2.getID() + ", origin connection ID =" + connection2.getId()));
        }
        ConnectionIdentifier connectionID = new ConnectionIdentifier(connectionActivity.getID());
        ConnectionIdentifier connectionID2 = new ConnectionIdentifier(connectionActivity2.getID());
        CreateConnectionResponse response = new CreateConnectionResponse(crcx.getSource(), ReturnCode.Transaction_Executed_Normally, connectionID);
        response.setSpecificEndpointIdentifier(new EndpointIdentifier(endpoint.getLocalName(), crcx.getEndpointIdentifier().getDomainName()));
        response.setSecondEndpointIdentifier(new EndpointIdentifier(endpoint2.getLocalName(), crcx.getEndpointIdentifier().getDomainName()));
        response.setSecondConnectionIdentifier(connectionID2);
        response.setTransactionHandle(crcx.getTransactionHandle());
        return response;
    }

    public JainMgcpResponseEvent call() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Request TX= " + this.crcx.getTransactionHandle() + ", CallID = " + this.crcx.getCallIdentifier() + ", Mode=" + this.crcx.getMode() + ", Endpoint = " + this.crcx.getEndpointIdentifier() + ", Endpoint2 = " + this.crcx.getSecondEndpointIdentifier() + ", SDP present = " + (this.crcx.getRemoteConnectionDescriptor() != null)));
        }
        JainMgcpResponseEvent response = this.crcx.getSecondEndpointIdentifier() == null ? this.createRtpConnection(this.crcx) : this.createLink(this.crcx);
        response.setTransactionHandle(this.crcx.getTransactionHandle());
        logger.info((Object)("Response TX = " + response.getTransactionHandle() + ", Response: " + response.getReturnCode()));
        return response;
    }
}

