/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.ctrl.mgcp;

import jain.protocol.ip.JainIPFactory;
import jain.protocol.ip.mgcp.DeleteProviderException;
import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpListener;
import jain.protocol.ip.mgcp.JainMgcpProvider;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.CreateConnection;
import jain.protocol.ip.mgcp.message.DeleteConnection;
import jain.protocol.ip.mgcp.message.ModifyConnection;
import jain.protocol.ip.mgcp.message.NotificationRequest;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.mobicents.media.server.ctrl.mgcp.Call;
import org.mobicents.media.server.ctrl.mgcp.ConnectionActivity;
import org.mobicents.media.server.ctrl.mgcp.CreateConnectionAction;
import org.mobicents.media.server.ctrl.mgcp.DeleteConnectionAction;
import org.mobicents.media.server.ctrl.mgcp.ModifyConnectionAction;
import org.mobicents.media.server.ctrl.mgcp.NotificationRequestAction;
import org.mobicents.media.server.ctrl.mgcp.Request;
import org.mobicents.media.server.ctrl.mgcp.evt.MgcpPackage;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.NamingService;
import org.mobicents.mgcp.stack.JainMgcpStackImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MgcpController
implements JainMgcpListener {
    private static final Logger logger = Logger.getLogger(MgcpController.class);
    private JainMgcpProvider mgcpProvider;
    private JainMgcpStackImpl mgcpStack;
    private JainIPFactory jainFactory;
    private InetAddress inetAddress = null;
    private String bindAddress = null;
    private int port = 2727;
    private NamingService namingService;
    private ConcurrentHashMap<String, Call> calls = new ConcurrentHashMap();
    protected HashMap<String, MgcpPackage> packages = new HashMap();
    protected ConcurrentHashMap<String, Request> requests = new ConcurrentHashMap();
    private NotifiedEntity notifiedEntity;

    public NamingService getNamingService() {
        return this.namingService;
    }

    public void setNamingService(NamingService namingService) {
        this.namingService = namingService;
    }

    public NotifiedEntity getNotifiedEntity() {
        return this.notifiedEntity;
    }

    public void setDefaultNotifiedEntity(String value) {
        String[] tokens = value.split(":");
        int remotePort = this.port;
        if (tokens.length == 2) {
            remotePort = Integer.parseInt(tokens[1]);
        }
        tokens = tokens[0].split("@");
        this.notifiedEntity = new NotifiedEntity(tokens[0], tokens[1], remotePort);
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(String bindAddress) throws UnknownHostException {
        this.bindAddress = bindAddress;
        this.inetAddress = InetAddress.getByName(bindAddress);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void create() {
        logger.info((Object)"Starting MGCP Controller module for MMS");
    }

    public void addPackage(MgcpPackage pkg) {
        pkg.setController(this);
        this.packages.put(pkg.getName(), pkg);
    }

    public void removePackage(MgcpPackage pkg) {
        this.packages.remove(pkg);
    }

    public MgcpPackage getPackage(String name) {
        return this.packages.get(name);
    }

    public void start() throws Exception {
        this.mgcpStack = new JainMgcpStackImpl(this.inetAddress, this.port);
        this.mgcpProvider = this.mgcpStack.createProvider();
        this.mgcpProvider.addJainMgcpListener((JainMgcpListener)this);
        this.port = this.mgcpStack.getPort();
        logger.info((Object)"Started MGCP Controller module for MMS");
    }

    public void stop() {
        logger.info((Object)("Stoping MGCP Controller module for MMS. Listening at IP " + this.inetAddress + " port " + this.port));
        this.mgcpProvider.removeJainMgcpListener((JainMgcpListener)this);
        try {
            this.mgcpStack.deleteProvider(this.mgcpProvider);
        }
        catch (DeleteProviderException e) {
            e.printStackTrace();
        }
    }

    public void destroy() {
        logger.info((Object)"Stopped MGCP Controller module for MMS");
    }

    public JainMgcpStackImpl getMgcpSatck() {
        return this.mgcpStack;
    }

    public JainMgcpProvider getMgcpProvider() {
        return this.mgcpProvider;
    }

    public void processMgcpCommandEvent(JainMgcpCommandEvent evt) {
        Callable action = null;
        int eventID = evt.getObjectIdentifier();
        switch (eventID) {
            case 103: {
                action = new CreateConnectionAction(this, (CreateConnection)evt);
                break;
            }
            case 106: {
                action = new ModifyConnectionAction(this, (ModifyConnection)evt);
                break;
            }
            case 104: {
                action = new DeleteConnectionAction(this, (DeleteConnection)evt);
                break;
            }
            case 107: {
                action = new NotificationRequestAction(this, (NotificationRequest)evt);
                break;
            }
            default: {
                logger.error((Object)("Unknown message type: " + eventID));
                return;
            }
        }
        try {
            JainMgcpResponseEvent response = (JainMgcpResponseEvent)action.call();
            this.mgcpProvider.sendMgcpEvents(new JainMgcpEvent[]{response});
        }
        catch (Exception e) {
            logger.error((Object)"Unexpected error during processing,Caused by ", (Throwable)e);
        }
    }

    public void processMgcpResponseEvent(JainMgcpResponseEvent evt) {
    }

    protected Call getCall(String callID) {
        return this.calls.get(callID);
    }

    protected void addCall(Call call) {
        this.calls.put(call.getID(), call);
    }

    protected void removeCall(String callID) {
        this.calls.remove(callID);
    }

    protected Collection<ConnectionActivity> getActivities(String endpointName) {
        ArrayList<ConnectionActivity> list = new ArrayList<ConnectionActivity>();
        for (Call call : this.calls.values()) {
            Collection<ConnectionActivity> activities = call.getActivities();
            for (ConnectionActivity activity : activities) {
                if (!activity.getMediaConnection().getEndpoint().getLocalName().equals(endpointName)) continue;
                list.add(activity);
            }
        }
        return list;
    }

    protected ConnectionActivity getActivity(String endpointName, String connectionID) {
        for (Call call : this.calls.values()) {
            Collection<ConnectionActivity> activities = call.getActivities();
            for (ConnectionActivity activity : activities) {
                Connection connection = activity.getMediaConnection();
                if (!connection.getEndpoint().getLocalName().equals(endpointName) || !activity.getID().equals(connectionID)) continue;
                return activity;
            }
        }
        return null;
    }

    private class CallMon
    implements Runnable {
        private CallMon() {
        }

        public void run() {
            while (true) {
                System.out.println("********** CALL COUNT= " + MgcpController.this.calls.size());
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                }
            }
        }
    }
}

