/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.ctrl.mgcp;

import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.ModifyConnection;
import jain.protocol.ip.mgcp.message.ModifyConnectionResponse;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionDescriptor;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.mobicents.media.server.ctrl.mgcp.ConnectionActivity;
import org.mobicents.media.server.ctrl.mgcp.MgcpController;
import org.mobicents.media.server.ctrl.mgcp.MgcpUtils;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.ConnectionMode;
import org.mobicents.media.server.spi.Endpoint;

public class ModifyConnectionAction
implements Callable {
    private static Logger logger = Logger.getLogger(ModifyConnectionAction.class);
    private ModifyConnection mdcx;
    private MgcpController controller;
    private MgcpUtils utils = new MgcpUtils();

    protected ModifyConnectionAction(MgcpController controller, ModifyConnection req) {
        this.controller = controller;
        this.mdcx = req;
    }

    public JainMgcpResponseEvent call() throws Exception {
        ConnectionDescriptor remoteConnectionDescriptor;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Request TX= " + this.mdcx.getTransactionHandle() + ", CallID = " + this.mdcx.getCallIdentifier() + ", Mode=" + this.mdcx.getMode() + ", Endpoint = " + this.mdcx.getEndpointIdentifier() + ", SDP present = " + (this.mdcx.getRemoteConnectionDescriptor() != null)));
        }
        ModifyConnectionResponse response = null;
        EndpointIdentifier endpointID = this.mdcx.getEndpointIdentifier();
        String localEndpoint = endpointID.getLocalEndpointName();
        if (localEndpoint.contains("*") || localEndpoint.contains("$")) {
            return this.reject(ReturnCode.Protocol_Error);
        }
        CallIdentifier callID = this.mdcx.getCallIdentifier();
        ConnectionIdentifier connectionID = this.mdcx.getConnectionIdentifier();
        ConnectionMode mode = null;
        if (this.mdcx.getMode() != null) {
            mode = this.utils.getMode(this.mdcx.getMode());
        }
        Endpoint endpoint = null;
        try {
            endpoint = this.controller.getNamingService().lookup(localEndpoint, true);
        }
        catch (Exception e) {
            return this.reject(ReturnCode.Endpoint_Unknown);
        }
        ConnectionActivity connectionActivity = this.controller.getActivity(localEndpoint, connectionID.toString());
        Connection connection = connectionActivity.getMediaConnection();
        if (connection.getMode() != mode) {
            connection.setMode(mode);
        }
        if ((remoteConnectionDescriptor = this.mdcx.getRemoteConnectionDescriptor()) != null) {
            connection.setRemoteDescriptor(remoteConnectionDescriptor.toString());
        }
        response = new ModifyConnectionResponse((Object)this, ReturnCode.Transaction_Executed_Normally);
        response.setTransactionHandle(this.mdcx.getTransactionHandle());
        return response;
    }

    private ModifyConnectionResponse reject(ReturnCode code) {
        ModifyConnectionResponse response = new ModifyConnectionResponse((Object)this, code);
        response.setTransactionHandle(this.mdcx.getTransactionHandle());
        return response;
    }
}

