/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.ctrl.mgcp;

import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.NotificationRequest;
import jain.protocol.ip.mgcp.message.NotificationRequestResponse;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import jain.protocol.ip.mgcp.message.parms.RequestedEvent;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import jain.protocol.ip.mgcp.pkg.PackageName;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.mobicents.media.server.ctrl.mgcp.ConnectionActivity;
import org.mobicents.media.server.ctrl.mgcp.MgcpController;
import org.mobicents.media.server.ctrl.mgcp.Request;
import org.mobicents.media.server.ctrl.mgcp.evt.EventDetector;
import org.mobicents.media.server.ctrl.mgcp.evt.MgcpPackage;
import org.mobicents.media.server.ctrl.mgcp.evt.SignalGenerator;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.Endpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationRequestAction
implements Callable<JainMgcpResponseEvent> {
    private static Logger logger = Logger.getLogger(NotificationRequestAction.class);
    private MgcpController controller;
    private NotificationRequest req;

    public NotificationRequestAction(MgcpController controller, NotificationRequest req) {
        this.controller = controller;
        this.req = req;
    }

    @Override
    public JainMgcpResponseEvent call() throws Exception {
        EventName[] signals;
        ConnectionIdentifier connectionID;
        ConnectionActivity connectionActivity;
        Connection connection;
        MgcpPackage pkg;
        PackageName packageName;
        EventName eventName;
        logger.info((Object)("Request TX= " + this.req.getTransactionHandle() + ", Endpoint = " + this.req.getEndpointIdentifier()));
        NotificationRequestResponse response = null;
        RequestIdentifier reqID = this.req.getRequestIdentifier();
        EndpointIdentifier endpointID = this.req.getEndpointIdentifier();
        if (reqID == null || endpointID == null) {
            return this.reject(ReturnCode.Protocol_Error);
        }
        NotifiedEntity notifiedEntity = this.req.getNotifiedEntity();
        if (notifiedEntity == null) {
            notifiedEntity = this.controller.getNotifiedEntity();
        }
        if (notifiedEntity == null) {
            return this.reject(ReturnCode.Transient_Error);
        }
        Endpoint endpoint = null;
        try {
            endpoint = this.controller.getNamingService().lookup(endpointID.getLocalEndpointName(), true);
        }
        catch (Exception e) {
            return this.reject(ReturnCode.Endpoint_Unknown);
        }
        Request request = new Request(this.controller, reqID, endpointID, endpoint, notifiedEntity);
        RequestedEvent[] events = this.req.getRequestedEvents();
        if (events != null) {
            for (int i = 0; i < events.length; ++i) {
                RequestedEvent event = events[i];
                eventName = event.getEventName();
                packageName = eventName.getPackageName();
                pkg = this.controller.getPackage(packageName.toString());
                if (pkg == null) {
                    return this.reject(ReturnCode.Unsupported_Or_Unknown_Package);
                }
                EventDetector det = pkg.getDetector(event.getEventName().getEventIdentifier(), event.getRequestedActions());
                if (det == null) {
                    logger.warn((Object)("Unknow event: " + packageName + "/" + event.getEventName().getEventIdentifier()));
                    return this.reject(ReturnCode.Gateway_Cannot_Detect_Requested_Event);
                }
                connection = null;
                connectionActivity = null;
                connectionID = eventName.getConnectionIdentifier();
                if (connectionID != null) {
                    connectionActivity = this.controller.getActivity(endpoint.getLocalName(), connectionID.toString());
                    if (connectionActivity == null) {
                        return this.reject(ReturnCode.Connection_Was_Deleted);
                    }
                    det.setConnectionIdentifier(connectionID);
                    connection = connectionActivity.getMediaConnection();
                }
                request.append(det, connection);
            }
        }
        if ((signals = this.req.getSignalRequests()) != null) {
            for (int i = 0; i < signals.length; ++i) {
                eventName = signals[i];
                packageName = eventName.getPackageName();
                pkg = this.controller.getPackage(packageName.toString());
                if (pkg == null) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("No MgcpPackage found for PackageName " + packageName.toString() + " Sending back" + ReturnCode.Unsupported_Or_Unknown_Package.toString()));
                    }
                    return this.reject(ReturnCode.Unsupported_Or_Unknown_Package);
                }
                SignalGenerator signal = pkg.getGenerator(eventName.getEventIdentifier());
                if (signal == null) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("No SignalGenerator found for MgcpEvent " + eventName.getEventIdentifier().toString() + " Sending back" + ReturnCode.Gateway_Cannot_Generate_Requested_Signal.toString()));
                    }
                    return this.reject(ReturnCode.Gateway_Cannot_Generate_Requested_Signal);
                }
                connection = null;
                connectionActivity = null;
                connectionID = eventName.getConnectionIdentifier();
                if (connectionID != null) {
                    connectionActivity = this.controller.getActivity(endpoint.getLocalName(), connectionID.toString());
                    if (connectionActivity == null) {
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("No Connection found for ConnectionIdentifier " + connectionID + " Sending back" + ReturnCode.Connection_Was_Deleted.toString()));
                        }
                        return this.reject(ReturnCode.Connection_Was_Deleted);
                    }
                    connection = connectionActivity.getMediaConnection();
                }
                request.append(signal, connection);
            }
        }
        if (!request.verifyDetectors()) {
            logger.warn((Object)"Verification of detectors failed: ");
            return this.reject(ReturnCode.Gateway_Cannot_Detect_Requested_Event);
        }
        if (!request.verifyGenerators()) {
            return this.reject(ReturnCode.Gateway_Cannot_Generate_Requested_Signal);
        }
        Request prev = this.controller.requests.remove(endpoint.getLocalName());
        if (prev != null) {
            prev.cancel();
        }
        this.controller.requests.put(endpoint.getLocalName(), request);
        request.run();
        response = new NotificationRequestResponse((Object)this, ReturnCode.Transaction_Executed_Normally);
        response.setTransactionHandle(this.req.getTransactionHandle());
        logger.info((Object)("Response TX = " + response.getTransactionHandle() + ", Response: " + response.getReturnCode()));
        return response;
    }

    private NotificationRequestResponse reject(ReturnCode code) {
        NotificationRequestResponse response = new NotificationRequestResponse((Object)this, code);
        response.setTransactionHandle(this.req.getTransactionHandle());
        return response;
    }
}

