/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.ctrl.mgcp.evt;

import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.message.parms.RequestedAction;
import jain.protocol.ip.mgcp.pkg.MgcpEvent;
import jain.protocol.ip.mgcp.pkg.PackageName;
import org.apache.log4j.Logger;
import org.mobicents.media.Component;
import org.mobicents.media.MediaSink;
import org.mobicents.media.server.ctrl.mgcp.Request;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.NotificationListener;
import org.mobicents.media.server.spi.events.NotifyEvent;

public abstract class EventDetector
implements NotificationListener {
    private String pkgName;
    private String eventName;
    private String resourceName;
    private int eventID;
    private Endpoint endpoint;
    private Connection connection;
    private RequestedAction[] actions;
    protected String params;
    protected Component component;
    private ConnectionIdentifier connectionIdentifier = null;
    private Request request;
    private Logger logger = Logger.getLogger(EventDetector.class);

    public EventDetector(String pkgName, String eventName, String resourceName, int eventID, String params, RequestedAction[] actions) {
        this.pkgName = pkgName;
        this.eventName = eventName;
        this.resourceName = resourceName;
        this.eventID = eventID;
        this.params = params;
        this.actions = actions;
    }

    public void setConnectionIdentifier(ConnectionIdentifier connectionIdentifier) {
        this.connectionIdentifier = connectionIdentifier;
    }

    public int getEventID() {
        return this.eventID;
    }

    public void setEventID(int eventID) {
        this.eventID = eventID;
    }

    public RequestedAction[] getActions() {
        return this.actions;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setPackageName(String pkgName) {
        this.pkgName = pkgName;
    }

    public EventName getEventName() {
        if (this.connectionIdentifier != null) {
            return new EventName(PackageName.factory((String)this.pkgName), MgcpEvent.factory((String)this.eventName), this.connectionIdentifier);
        }
        return new EventName(PackageName.factory((String)this.pkgName), MgcpEvent.factory((String)this.eventName));
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public Request getRequest() {
        return this.request;
    }

    public boolean verify(Connection connection) {
        this.connection = connection;
        return this.doVerify(connection);
    }

    public boolean verify(Endpoint endpoint) {
        this.endpoint = endpoint;
        return this.doVerify(endpoint);
    }

    protected boolean doVerify(Connection connection) {
        this.component = connection.getComponent(this.resourceName, 0);
        if (this.component == null) {
            this.logger.warn((Object)("Unknown component " + this.resourceName));
        }
        return this.component != null;
    }

    protected boolean doVerify(Endpoint endpoint) {
        this.logger.info((Object)("Verifying " + this.resourceName + " on endpoint " + endpoint));
        this.component = endpoint.getComponent(this.resourceName);
        return this.component != null;
    }

    public void start() {
        this.component.addListener((NotificationListener)this);
        if (this.component instanceof MediaSink) {
            this.component.start();
        }
    }

    public void stop() {
        if (this.component != null) {
            this.component.stop();
            this.component.removeListener((NotificationListener)this);
            this.component = null;
        }
    }

    public void update(NotifyEvent event) {
        if (event.getEventID() == this.eventID) {
            for (RequestedAction action : this.actions) {
                this.performAction(event, action);
            }
        }
    }

    public abstract void performAction(NotifyEvent var1, RequestedAction var2);
}

