/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.ctrl.mgcp.evt;

import jain.protocol.ip.mgcp.message.parms.RequestedAction;
import jain.protocol.ip.mgcp.pkg.MgcpEvent;
import java.util.List;
import org.mobicents.media.server.ctrl.mgcp.MgcpController;
import org.mobicents.media.server.ctrl.mgcp.evt.DetectorFactory;
import org.mobicents.media.server.ctrl.mgcp.evt.EventDetector;
import org.mobicents.media.server.ctrl.mgcp.evt.GeneratorFactory;
import org.mobicents.media.server.ctrl.mgcp.evt.SignalGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MgcpPackage {
    private String name;
    private int id;
    private MgcpController controller;
    private List<GeneratorFactory> generators;
    private List<DetectorFactory> detectors;

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MgcpController getController() {
        return this.controller;
    }

    public void setController(MgcpController controller) {
        this.controller = controller;
    }

    public List<GeneratorFactory> getGenerators() {
        return this.generators;
    }

    public void setGenerators(List<GeneratorFactory> signals) {
        this.generators = signals;
        try {
            if (signals != null) {
                for (GeneratorFactory factory : this.generators) {
                    factory.setPackageName(this.name);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<DetectorFactory> getDetectors() {
        return this.detectors;
    }

    public void setDetectors(List<DetectorFactory> events) {
        this.detectors = events;
        if (events != null) {
            for (DetectorFactory factory : this.detectors) {
                factory.setPackageName(this.name);
            }
        }
    }

    public SignalGenerator getGenerator(MgcpEvent evt) {
        if (this.generators != null) {
            for (GeneratorFactory factory : this.generators) {
                if (!factory.getEventName().equals(evt.getName())) continue;
                return factory.getInstance(this.controller, evt.getParms());
            }
        }
        return null;
    }

    public EventDetector getDetector(MgcpEvent evt, RequestedAction[] actions) {
        if (this.detectors != null) {
            for (DetectorFactory factory : this.detectors) {
                if (!factory.getEventName().equals(evt.getName())) continue;
                EventDetector det = factory.getInstance(evt.getParms(), actions);
                det.setPackageName(this.name);
                return det;
            }
        }
        return null;
    }
}

