/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.ctrl.mgcp.evt.tone;

import java.util.ArrayList;
import java.util.List;
import org.mobicents.media.server.ctrl.mgcp.Request;
import org.mobicents.media.server.ctrl.mgcp.evt.SignalGenerator;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.resource.FrequencyBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiFreqToneGenerator
extends SignalGenerator {
    private org.mobicents.media.server.spi.resource.MultiFreqToneGenerator mulFreqGen;
    private String params;

    public MultiFreqToneGenerator(String resourceName, String params) {
        super(resourceName, params);
        this.params = params;
    }

    @Override
    public void cancel() {
        this.mulFreqGen.stop();
        this.mulFreqGen = null;
    }

    @Override
    protected boolean doVerify(Connection connection) {
        this.mulFreqGen = (org.mobicents.media.server.spi.resource.MultiFreqToneGenerator)connection.getComponent(this.getResourceName(), 1);
        return this.mulFreqGen != null;
    }

    @Override
    protected boolean doVerify(Endpoint endpoint) {
        this.mulFreqGen = (org.mobicents.media.server.spi.resource.MultiFreqToneGenerator)endpoint.getComponent(this.getResourceName());
        return this.mulFreqGen != null;
    }

    @Override
    public void start(Request request) {
        List<FrequencyBean> freqBean = this.decodeParams();
        this.mulFreqGen.setFreqBeanList(freqBean);
        this.mulFreqGen.setVolume(0);
        this.mulFreqGen.start();
    }

    private List<FrequencyBean> decodeParams() {
        ArrayList<FrequencyBean> listFreqtemp = new ArrayList<FrequencyBean>();
        String[] freqData = this.params.split("-");
        int count = 0;
        while (count < freqData.length) {
            int lowFreq = Integer.parseInt(freqData[count++]);
            int highFreq = Integer.parseInt(freqData[count++]);
            int duration = Integer.parseInt(freqData[count++]);
            FrequencyBean freqbean = new FrequencyBean(lowFreq, highFreq, duration);
            listFreqtemp.add(freqbean);
        }
        return listFreqtemp;
    }
}

