/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.ctrl.mgcp.evt;

import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.message.parms.RequestedAction;
import jain.protocol.ip.mgcp.pkg.MgcpEvent;
import jain.protocol.ip.mgcp.pkg.PackageName;
import org.apache.log4j.Logger;
import org.mobicents.media.Component;
import org.mobicents.media.MediaSink;
import org.mobicents.media.MediaSource;
import org.mobicents.media.server.ctrl.mgcp.Request;
import org.mobicents.media.server.ctrl.mgcp.evt.MgcpPackage;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.MediaType;
import org.mobicents.media.server.spi.NotificationListener;
import org.mobicents.media.server.spi.events.NotifyEvent;

public abstract class EventDetector
implements NotificationListener {
    private static final long serialVersionUID = 1L;
    private MgcpPackage mgcpPackage;
    private String eventName;
    private int eventID;
    private Endpoint endpoint;
    private Connection connection;
    private RequestedAction[] actions;
    protected String params;
    protected Component component;
    private ConnectionIdentifier connectionIdentifier = null;
    private Request request;
    private Logger logger = Logger.getLogger(EventDetector.class);
    protected Class _interface = null;
    protected MediaType mediaType = null;

    public EventDetector(MgcpPackage mgcpPackage, String eventName, int eventID, String params, RequestedAction[] actions) {
        this.mgcpPackage = mgcpPackage;
        this.eventName = eventName;
        this.eventID = eventID;
        this.params = params;
        this.actions = actions;
    }

    public void setConnectionIdentifier(ConnectionIdentifier connectionIdentifier) {
        this.connectionIdentifier = connectionIdentifier;
    }

    public int getEventID() {
        return this.eventID;
    }

    public void setEventID(int eventID) {
        this.eventID = eventID;
    }

    public RequestedAction[] getActions() {
        return this.actions;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setPackage(MgcpPackage mgcpPackage) {
        this.mgcpPackage = mgcpPackage;
    }

    public EventName getEventName() {
        if (this.connectionIdentifier != null) {
            return new EventName(PackageName.factory((String)this.mgcpPackage.getName()), MgcpEvent.factory((String)this.eventName), this.connectionIdentifier);
        }
        return new EventName(PackageName.factory((String)this.mgcpPackage.getName()), MgcpEvent.factory((String)this.eventName));
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public Request getRequest() {
        return this.request;
    }

    public boolean verify(Connection connection) {
        this.connection = connection;
        return this.doVerify(connection);
    }

    public boolean verify(Endpoint endpoint) {
        this.endpoint = endpoint;
        return this.doVerify(endpoint);
    }

    protected boolean doVerify(Connection connection) {
        Component componentWhichProvideInterface = connection.getComponent(this.mediaType, this._interface);
        if (componentWhichProvideInterface != null) {
            this.component = (Component)componentWhichProvideInterface.getInterface(this._interface);
            return true;
        }
        return false;
    }

    protected boolean doVerify(Endpoint endpoint) {
        MediaSink sink = endpoint.getSink(this.mediaType);
        if (sink != null) {
            this.component = (Component)sink.getInterface(this._interface);
            return this.component != null;
        }
        MediaSource source = endpoint.getSource(this.mediaType);
        if (source != null) {
            this.component = (Component)source.getInterface(this._interface);
            return this.component != null;
        }
        return false;
    }

    public void start() {
        this.component.addListener((NotificationListener)this);
    }

    public void stop() {
        this.component.removeListener((NotificationListener)this);
    }

    public void update(NotifyEvent event) {
        if (event.getEventID() == this.eventID) {
            for (RequestedAction action : this.actions) {
                this.performAction(event, action);
            }
        }
    }

    public abstract void performAction(NotifyEvent var1, RequestedAction var2);

    public void setDetectorInterface(Class detectorInterface) {
        this._interface = detectorInterface;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }
}

