/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.ctrl.mgcp.evt.ann;

import org.mobicents.media.Component;
import org.mobicents.media.MediaSource;
import org.mobicents.media.server.ctrl.mgcp.MgcpController;
import org.mobicents.media.server.ctrl.mgcp.Request;
import org.mobicents.media.server.ctrl.mgcp.evt.EventDetector;
import org.mobicents.media.server.ctrl.mgcp.evt.GeneratorFactory;
import org.mobicents.media.server.ctrl.mgcp.evt.MgcpPackage;
import org.mobicents.media.server.ctrl.mgcp.evt.SignalGenerator;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.MediaType;
import org.mobicents.media.server.spi.resource.Player;
import org.mobicents.media.server.spi.resource.TTSEngine;

public class AnnSignalFactory
implements GeneratorFactory {
    private String name;
    private MgcpPackage mgcpPackage;
    private int eventID;

    public String getEventName() {
        return this.name;
    }

    public void setEventName(String eventName) {
        this.name = eventName;
    }

    public MgcpPackage getPackage() {
        return this.mgcpPackage;
    }

    public void setPackage(MgcpPackage mgcpPackage) {
        this.mgcpPackage = mgcpPackage;
    }

    public int getEventID() {
        return this.eventID;
    }

    public void setEventID(int eventID) {
        this.eventID = eventID;
    }

    public SignalGenerator getInstance(MgcpController controller, String parms) {
        System.out.println("params:= " + parms);
        if (parms.contains("ts(")) {
            return new TTSAnnSignal(parms);
        }
        MediaType type = this.mgcpPackage.getMediaType();
        if (type == null) {
            type = MediaType.AUDIO;
        }
        return new AnnSignal(parms, type);
    }

    private class AnnSignal
    extends SignalGenerator {
        private Player generator;
        private MediaType mediaType;
        private String url;

        public AnnSignal(String params, MediaType type) {
            super(params);
            this.generator = null;
            this.mediaType = null;
            this.url = params;
            this.mediaType = type;
        }

        protected boolean doVerify(Connection connection) {
            MediaSource source = (MediaSource)connection.getComponent(this.mediaType, Player.class);
            if (source != null) {
                this.generator = (Player)source.getInterface(Player.class);
                return true;
            }
            return false;
        }

        protected boolean doVerify(Endpoint endpoint) {
            MediaSource source = endpoint.getSource(this.mediaType);
            if (source != null) {
                this.generator = (Player)source.getInterface(Player.class);
                return this.generator != null;
            }
            return false;
        }

        public void start(Request request) {
            if (this.generator != null) {
                try {
                    this.generator.setURL(this.url);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                this.generator.start();
            }
        }

        public void cancel() {
            if (this.generator != null) {
                this.generator.stop();
                this.generator = null;
            }
        }

        public void configureDetector(EventDetector det) {
            det.setMediaType(this.mediaType);
            det.setDetectorInterface(TTSEngine.class);
        }
    }

    private class TTSAnnSignal
    extends SignalGenerator {
        private static final String _DEFAULT_VOICE_ = "kevin";
        private TTSEngine generator;
        private MediaType mediaType;
        private String text;
        private String voice;

        public TTSAnnSignal(String params) {
            super(params);
            this.generator = null;
            this.mediaType = MediaType.AUDIO;
            this.voice = _DEFAULT_VOICE_;
            String[] tokens = params.split(" ");
            for (int i = 0; i < tokens.length; ++i) {
                if (!tokens[i].startsWith("ts(")) continue;
                int indexofts = params.indexOf("ts(");
                this.text = params.substring(indexofts + 3, params.indexOf(41, indexofts + 3));
            }
        }

        protected boolean doVerify(Connection connection) {
            Component source = connection.getComponent(this.mediaType, TTSEngine.class);
            if (source != null) {
                this.generator = (TTSEngine)source.getInterface(TTSEngine.class);
                return true;
            }
            return false;
        }

        protected boolean doVerify(Endpoint endpoint) {
            MediaSource source = endpoint.getSource(this.mediaType);
            if (source != null) {
                this.generator = (TTSEngine)source.getInterface(TTSEngine.class);
                return this.generator != null;
            }
            return false;
        }

        public void start(Request request) {
            if (this.generator != null) {
                this.generator.setText(this.text);
                this.generator.setVoiceName(this.voice);
                this.generator.start();
            }
        }

        public void cancel() {
            if (this.generator != null) {
                this.generator.stop();
                this.generator = null;
            }
        }

        public void configureDetector(EventDetector det) {
            det.setMediaType(this.mediaType);
            det.setDetectorInterface(TTSEngine.class);
        }
    }
}

