/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.ctrl.mgcp;

import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.AuditConnection;
import jain.protocol.ip.mgcp.message.AuditConnectionResponse;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionDescriptor;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionParm;
import jain.protocol.ip.mgcp.message.parms.InfoCode;
import jain.protocol.ip.mgcp.message.parms.RegularConnectionParm;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.util.concurrent.Callable;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.mobicents.media.server.ctrl.mgcp.ConnectionActivity;
import org.mobicents.media.server.ctrl.mgcp.MgcpController;
import org.mobicents.media.server.ctrl.mgcp.MgcpUtils;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.MediaType;

public class AuditConnectionAction
implements Callable {
    private AuditConnection aucx;
    private MgcpController controller;
    private MgcpUtils utils = new MgcpUtils();
    private static Logger logger = Logger.getLogger(AuditConnectionAction.class);

    protected AuditConnectionAction(MgcpController controller, AuditConnection req) {
        this.controller = controller;
        this.aucx = req;
    }

    public JainMgcpResponseEvent call() throws Exception {
        InfoCode[] infCodes = this.aucx.getRequestedInfo();
        ConnectionIdentifier connectionID = this.aucx.getConnectionIdentifier();
        int txID = this.aucx.getTransactionHandle();
        String localName = this.aucx.getEndpointIdentifier().getLocalEndpointName();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("AUCX Request TX= " + this.aucx.getTransactionHandle() + ", connId = " + this.aucx.getConnectionIdentifier() + ", endpt =" + this.aucx.getEndpointIdentifier()));
            StringBuffer s = new StringBuffer();
            for (InfoCode infCd : infCodes) {
                s.append(infCd.toString());
                s.append(",");
            }
            logger.debug((Object)("InfoCode[] = " + s.toString()));
        }
        if (localName.contains("*") || localName.contains("$")) {
            if (logger.isEnabledFor((Priority)Level.WARN)) {
                logger.warn((Object)("TX = " + txID + ", The endpoint name is underspecified with 'all off/any' wildcard, Response code: " + 500));
            }
            return new AuditConnectionResponse(this.aucx.getSource(), ReturnCode.Endpoint_Unknown);
        }
        Endpoint endpoint = null;
        try {
            endpoint = this.controller.getServer().lookup(localName, false);
            if (logger.isEnabledFor((Priority)Level.WARN)) {
                logger.warn((Object)("TX = " + txID + ", The endpoint name is not in use, Response code: " + 501));
            }
            return new AuditConnectionResponse(this.aucx.getSource(), ReturnCode.Endpoint_Not_Ready);
        }
        catch (Exception e) {
            ConnectionActivity connectionActivity = this.controller.getActivity(endpoint.getLocalName(), connectionID.toString());
            if (connectionActivity == null) {
                if (logger.isEnabledFor((Priority)Level.WARN)) {
                    logger.warn((Object)("No Connection found for ConnectionIdentifier " + connectionID + " Sending back" + ReturnCode.Connection_Was_Deleted.toString()));
                }
                return new AuditConnectionResponse(this.aucx.getSource(), ReturnCode.Connection_Was_Deleted);
            }
            if (infCodes.length == 0) {
                if (logger.isEnabledFor((Priority)Level.INFO)) {
                    logger.info((Object)("TX = " + txID + ", The endpoint name is in use and InfoCode[] length is zero, Response code: " + ReturnCode.Transaction_Executed_Normally));
                }
                return new AuditConnectionResponse(this.aucx.getSource(), ReturnCode.Transaction_Executed_Normally);
            }
            Connection connection = connectionActivity.getMediaConnection();
            AuditConnectionResponse aucxResp = new AuditConnectionResponse(this.aucx.getSource(), ReturnCode.Transaction_Executed_Normally);
            block12: for (InfoCode infCode : infCodes) {
                switch (infCode.getInfoCode()) {
                    case 2: {
                        aucxResp.setCallIdentifier(new CallIdentifier(connectionActivity.getCall().getID()));
                        continue block12;
                    }
                    case 4: {
                        aucxResp.setNotifiedEntity(this.controller.getNotifiedEntity());
                        continue block12;
                    }
                    case 6: {
                        continue block12;
                    }
                    case 7: {
                        aucxResp.setMode(this.utils.getMode(connection.getMode(MediaType.AUDIO)));
                        continue block12;
                    }
                    case 17: {
                        aucxResp.setRemoteConnectionDescriptor(new ConnectionDescriptor(connection.getRemoteDescriptor()));
                        continue block12;
                    }
                    case 18: {
                        aucxResp.setLocalConnectionDescriptor(new ConnectionDescriptor(connection.getLocalDescriptor()));
                        continue block12;
                    }
                    case 12: {
                        ConnectionParm[] parms = new ConnectionParm[]{new RegularConnectionParm(RegularConnectionParm.OCTETS_RECEIVED, (int)connection.getBytesReceived()), new RegularConnectionParm(RegularConnectionParm.OCTETS_SENT, (int)connection.getBytesTransmitted()), new RegularConnectionParm(RegularConnectionParm.JITTER, (int)(connection.getJitter() * 1000.0))};
                        aucxResp.setConnectionParms(parms);
                        continue block12;
                    }
                    default: {
                        if (!logger.isEnabledFor((Priority)Level.WARN)) continue block12;
                        logger.warn((Object)("The InfoCode is not recognized " + infCode));
                    }
                }
            }
            return aucxResp;
        }
    }
}

