/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.ctrl.mgcp;

import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.message.DeleteConnection;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionParm;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import jain.protocol.ip.mgcp.message.parms.RegularConnectionParm;
import org.apache.log4j.Logger;
import org.mobicents.media.server.ctrl.mgcp.Call;
import org.mobicents.media.server.ctrl.mgcp.MgcpController;
import org.mobicents.media.server.ctrl.mgcp.Request;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.ConnectionListener;
import org.mobicents.media.server.spi.ConnectionMode;
import org.mobicents.media.server.spi.ConnectionState;
import org.mobicents.protocols.mgcp.stack.ExtendedJainMgcpProvider;

public class ConnectionActivity
implements ConnectionListener {
    private static Logger logger = Logger.getLogger(ConnectionActivity.class);
    private static int GEN = 1;
    protected Connection connection;
    private String id;
    private Call call;

    protected ConnectionActivity(Call call, Connection connection) {
        this.call = call;
        this.id = Integer.toHexString(GEN++);
        if (GEN == Integer.MAX_VALUE) {
            GEN = 1;
        }
        this.connection = connection;
        connection.addListener((ConnectionListener)this);
    }

    public String getID() {
        return this.id;
    }

    public void onStateChange(Connection connection, ConnectionState oldState) {
    }

    public void onModeChange(Connection connection, ConnectionMode oldMode) {
    }

    public void onError(Connection connection, Exception e) {
        ConnectionParm[] parms = new ConnectionParm[]{new RegularConnectionParm(RegularConnectionParm.OCTETS_RECEIVED, (int)this.connection.getBytesReceived()), new RegularConnectionParm(RegularConnectionParm.OCTETS_SENT, (int)this.connection.getBytesTransmitted()), new RegularConnectionParm(RegularConnectionParm.JITTER, (int)(this.connection.getJitter() * 1000.0))};
        this.close();
        MgcpController controller = this.call.getController();
        NotifiedEntity notifiedEntity = controller.getNotifiedEntity();
        CallIdentifier callId = new CallIdentifier(this.call.getID());
        EndpointIdentifier endpointId = new EndpointIdentifier(connection.getEndpoint().getLocalName(), notifiedEntity.getDomainName() + ":" + notifiedEntity.getPortNumber());
        ConnectionIdentifier connectionID = new ConnectionIdentifier(this.getID());
        DeleteConnection dlcx = new DeleteConnection((Object)controller, callId, endpointId, connectionID);
        dlcx.setTransactionHandle(Request.txID++);
        dlcx.setConnectionParms(parms);
        ExtendedJainMgcpProvider extendedMgcpProvider = controller.getExtendedMgcpProvider();
        extendedMgcpProvider.sendAsyncMgcpEvents(new JainMgcpEvent[]{dlcx});
        logger.error((Object)"Error in Connection. Closed Connection and sent DLCX command to client", (Throwable)e);
    }

    public Connection getMediaConnection() {
        return this.connection;
    }

    public void close() {
        try {
            this.call.removeConnection(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connection.getEndpoint().deleteConnection(this.connection.getId());
        this.connection.removeListener((ConnectionListener)this);
        this.connection = null;
    }

    protected Call getCall() {
        return this.call;
    }
}

