/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.ctrl.mgcp;

import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.CreateConnection;
import jain.protocol.ip.mgcp.message.CreateConnectionResponse;
import jain.protocol.ip.mgcp.message.parms.ConnectionDescriptor;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.mobicents.media.server.ctrl.mgcp.Call;
import org.mobicents.media.server.ctrl.mgcp.ConnectionActivity;
import org.mobicents.media.server.ctrl.mgcp.MgcpController;
import org.mobicents.media.server.ctrl.mgcp.MgcpUtils;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.ConnectionMode;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.ResourceUnavailableException;

public class CreateConnectionAction
implements Callable {
    private static final ConnectionIdentifier ERROR_CONNID = new ConnectionIdentifier("0");
    private CreateConnection crcx;
    private MgcpController controller;
    private MgcpUtils utils = new MgcpUtils();
    private static Logger logger = Logger.getLogger(CreateConnectionAction.class);

    protected CreateConnectionAction(MgcpController controller, CreateConnection req) {
        this.controller = controller;
        this.crcx = req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JainMgcpResponseEvent createRtpConnection(CreateConnection crcx) {
        String callID;
        Call call;
        boolean isNewCall;
        int txID = crcx.getTransactionHandle();
        ConnectionMode mode = this.utils.getMode(crcx.getMode());
        if (mode == null) {
            if (logger.isEnabledFor((Priority)Level.WARN)) {
                logger.warn((Object)("TX = " + txID + ", Mode " + crcx.getMode() + " is not supported, Response code: " + 517));
            }
            return new CreateConnectionResponse(crcx.getSource(), ReturnCode.Unsupported_Or_Invalid_Mode, ERROR_CONNID);
        }
        String localName = crcx.getEndpointIdentifier().getLocalEndpointName();
        if (localName.contains("*")) {
            if (logger.isEnabledFor((Priority)Level.WARN)) {
                logger.warn((Object)("TX = " + txID + ", The endpoint name is underspecified with 'all off' wildcard, Response code: " + 500));
            }
            return new CreateConnectionResponse(crcx.getSource(), ReturnCode.Endpoint_Unknown, ERROR_CONNID);
        }
        Endpoint endpoint = null;
        try {
            endpoint = this.controller.getServer().lookup(localName, false);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TX=" + txID + ", Allocated endpoint: " + endpoint.getLocalName()));
            }
        }
        catch (ResourceUnavailableException e) {
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                logger.error((Object)("TX = " + txID + ", There is no free endpoint: " + localName + ", ResponseCode: " + 500));
            }
            return new CreateConnectionResponse(crcx.getSource(), ReturnCode.Endpoint_Unknown, ERROR_CONNID);
        }
        Connection connection = null;
        try {
            connection = endpoint.createConnection();
            connection.setMode(mode);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TX=" + txID + ", Endpoint: " + endpoint.getLocalName() + ", Created connection "));
            }
        }
        catch (Exception e) {
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                logger.error((Object)"", (Throwable)e);
            }
            return new CreateConnectionResponse(crcx.getSource(), ReturnCode.Endpoint_Insufficient_Resources, ERROR_CONNID);
        }
        ConnectionDescriptor remoteSdp = crcx.getRemoteConnectionDescriptor();
        if (remoteSdp != null) {
            try {
                connection.setRemoteDescriptor(remoteSdp.toString());
            }
            catch (Exception e) {
                endpoint.deleteConnection(connection.getId());
                if (logger.isEnabledFor((Priority)Level.ERROR)) {
                    logger.error((Object)"Could not apply remote descriptor", (Throwable)e);
                }
                return new CreateConnectionResponse(crcx.getSource(), ReturnCode.Missing_RemoteConnectionDescriptor, ERROR_CONNID);
            }
        }
        boolean bl = isNewCall = (call = this.controller.getCall(callID = crcx.getCallIdentifier().toString())) == null;
        if (isNewCall) {
            call = new Call(callID, this.controller);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TX = " + txID + ", Created new call instance, ID = " + call.getID()));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("TX = " + txID + ", Using existing call instance, ID = " + call.getID()));
        }
        ConnectionActivity connectionActivity = null;
        try {
            connectionActivity = call.addConnection(connection);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created connection activity=" + connectionActivity.getID() + ", origin connection ID =" + connection.getId()));
            }
        }
        catch (IllegalStateException e) {
            try {
                if (logger.isEnabledFor((Priority)Level.ERROR)) {
                    logger.error((Object)("TX=" + txID + " Failed to create ConnectionActivity for connection: " + connection.getId() + ", from endpoint: " + endpoint.getLocalName()), (Throwable)e);
                }
                endpoint.deleteConnection(connection.getId());
            }
            finally {
                return new CreateConnectionResponse(crcx.getSource(), ReturnCode.Endpoint_Insufficient_Resources, ERROR_CONNID);
            }
        }
        ConnectionDescriptor localSDP = new ConnectionDescriptor(connection.getLocalDescriptor());
        ConnectionIdentifier connectionID = new ConnectionIdentifier(connectionActivity.getID());
        CreateConnectionResponse response = new CreateConnectionResponse(crcx.getSource(), ReturnCode.Transaction_Executed_Normally, connectionID);
        response.setSpecificEndpointIdentifier(new EndpointIdentifier(endpoint.getLocalName(), crcx.getEndpointIdentifier().getDomainName()));
        response.setConnectionIdentifier(connectionID);
        response.setLocalConnectionDescriptor(localSDP);
        response.setTransactionHandle(crcx.getTransactionHandle());
        if (isNewCall) {
            try {
                this.controller.addCall(call);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Save reference to the callID=" + call.getID()));
                }
            }
            catch (IllegalStateException e) {
                try {
                    if (logger.isEnabledFor((Priority)Level.ERROR)) {
                        logger.error((Object)("TX=" + txID + " Failed to add Call : " + call.getID() + ", from endpoint: " + endpoint.getLocalName()), (Throwable)e);
                    }
                    endpoint.deleteConnection(connection.getId());
                }
                finally {
                    return new CreateConnectionResponse(crcx.getSource(), ReturnCode.Endpoint_Insufficient_Resources, ERROR_CONNID);
                }
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JainMgcpResponseEvent createLink(CreateConnection crcx) {
        boolean isNewCall;
        int txID = crcx.getTransactionHandle();
        ConnectionMode mode = this.utils.getMode(crcx.getMode());
        if (mode == null) {
            if (logger.isEnabledFor((Priority)Level.WARN)) {
                logger.warn((Object)("TX = " + txID + ", Mode " + crcx.getMode() + " is not supported, Response code: " + 517));
            }
            return new CreateConnectionResponse(crcx.getSource(), ReturnCode.Unsupported_Or_Invalid_Mode, ERROR_CONNID);
        }
        String localName = crcx.getEndpointIdentifier().getLocalEndpointName();
        if (localName.contains("*")) {
            if (logger.isEnabledFor((Priority)Level.WARN)) {
                logger.warn((Object)("TX = " + txID + ", The endpoint name is underspecified with 'all off' wildcard, Response code: " + 500));
            }
            return new CreateConnectionResponse(crcx.getSource(), ReturnCode.Endpoint_Unknown, ERROR_CONNID);
        }
        Endpoint endpoint = null;
        try {
            endpoint = this.controller.getServer().lookup(localName, true);
        }
        catch (ResourceUnavailableException e) {
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                logger.error((Object)("TX = " + txID + ", There is no free endpoint: " + localName + ", ResponseCode: " + 500));
            }
            return new CreateConnectionResponse(crcx.getSource(), ReturnCode.Endpoint_Unknown, ERROR_CONNID);
        }
        String callID = crcx.getCallIdentifier().toString();
        Call call = this.controller.getCall(callID);
        boolean bl = isNewCall = call == null;
        if (isNewCall) {
            call = new Call(callID, this.controller);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TX = " + txID + ", Created new call instance, ID = " + call.getID()));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("TX = " + txID + ", Using existing call instance, ID = " + call.getID()));
        }
        Connection connection = null;
        try {
            connection = endpoint.createLocalConnection();
            connection.setMode(mode);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TX=" + txID + ", Endpoint: " + endpoint.getLocalName() + ", Created connection "));
            }
        }
        catch (Exception e) {
            return new CreateConnectionResponse(crcx.getSource(), ReturnCode.Endpoint_Insufficient_Resources, ERROR_CONNID);
        }
        String localName2 = crcx.getSecondEndpointIdentifier().getLocalEndpointName();
        if (localName2.contains("*")) {
            endpoint.deleteConnection(connection.getId());
            if (logger.isEnabledFor((Priority)Level.WARN)) {
                logger.warn((Object)("TX = " + txID + ", The endpoint name is underspecified with 'all off' wildcard, Response code: " + 500));
            }
            return new CreateConnectionResponse(crcx.getSource(), ReturnCode.Endpoint_Unknown, ERROR_CONNID);
        }
        Endpoint endpoint2 = null;
        try {
            endpoint2 = this.controller.getServer().lookup(localName2, true);
        }
        catch (ResourceUnavailableException e) {
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                logger.error((Object)("TX = " + txID + ", There is no free endpoint: " + localName2 + ", ResponseCode: " + 500));
            }
            return new CreateConnectionResponse(crcx.getSource(), ReturnCode.Endpoint_Unknown, ERROR_CONNID);
        }
        Connection connection2 = null;
        try {
            connection2 = endpoint2.createLocalConnection();
            connection2.setMode(ConnectionMode.SEND_RECV);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TX=" + txID + ", Endpoint: " + endpoint2.getLocalName() + ", Created connection "));
            }
        }
        catch (Exception e) {
            try {
                if (logger.isEnabledFor((Priority)Level.ERROR)) {
                    logger.error((Object)("TX=" + txID + ", Endpoint: " + endpoint2.getLocalName() + ", Created connection , failed to create connection. "), (Throwable)e);
                }
                endpoint.deleteConnection(connection.getId());
            }
            finally {
                return new CreateConnectionResponse(crcx.getSource(), ReturnCode.Endpoint_Insufficient_Resources, ERROR_CONNID);
            }
        }
        try {
            connection.setOtherParty(connection2);
            connection2.setOtherParty(connection);
        }
        catch (IOException e) {
            try {
                if (logger.isEnabledFor((Priority)Level.ERROR)) {
                    logger.error((Object)("TX=" + txID + " Failed to link connection: " + connection.getId() + ", from endpoint: " + endpoint.getLocalName() + ", with connection: " + connection2.getId() + ", from endpoint:  " + endpoint2.getLocalName()), (Throwable)e);
                }
                endpoint.deleteConnection(connection.getId());
                endpoint2.deleteConnection(connection2.getId());
            }
            finally {
                return new CreateConnectionResponse(crcx.getSource(), ReturnCode.Endpoint_Insufficient_Resources, ERROR_CONNID);
            }
        }
        ConnectionActivity connectionActivity = null;
        try {
            connectionActivity = call.addConnection(connection);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created connection activity=" + connectionActivity.getID() + ", origin connection ID =" + connection.getId()));
            }
        }
        catch (IllegalStateException e) {
            try {
                if (logger.isEnabledFor((Priority)Level.ERROR)) {
                    logger.error((Object)("TX=" + txID + " Failed to create ConnectionActivity for connection: " + connection.getId() + ", from endpoint: " + endpoint.getLocalName()), (Throwable)e);
                }
                endpoint.deleteConnection(connection.getId());
                endpoint2.deleteConnection(connection2.getId());
            }
            finally {
                return new CreateConnectionResponse(crcx.getSource(), ReturnCode.Endpoint_Insufficient_Resources, ERROR_CONNID);
            }
        }
        ConnectionActivity connectionActivity2 = null;
        try {
            connectionActivity2 = call.addConnection(connection2);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created connection activity=" + connectionActivity2.getID() + ", origin connection ID =" + connection2.getId()));
            }
        }
        catch (IllegalStateException e) {
            try {
                if (logger.isEnabledFor((Priority)Level.ERROR)) {
                    logger.error((Object)("TX=" + txID + " Failed to create ConnectionActivity for connection: " + connection2.getId() + ", from endpoint:  " + endpoint2.getLocalName()), (Throwable)e);
                }
                endpoint.deleteConnection(connection.getId());
                endpoint2.deleteConnection(connection2.getId());
            }
            finally {
                return new CreateConnectionResponse(crcx.getSource(), ReturnCode.Endpoint_Insufficient_Resources, ERROR_CONNID);
            }
        }
        ConnectionIdentifier connectionID = new ConnectionIdentifier(connectionActivity.getID());
        ConnectionIdentifier connectionID2 = new ConnectionIdentifier(connectionActivity2.getID());
        CreateConnectionResponse response = new CreateConnectionResponse(crcx.getSource(), ReturnCode.Transaction_Executed_Normally, connectionID);
        response.setSpecificEndpointIdentifier(new EndpointIdentifier(endpoint.getLocalName(), crcx.getEndpointIdentifier().getDomainName()));
        response.setSecondEndpointIdentifier(new EndpointIdentifier(endpoint2.getLocalName(), crcx.getEndpointIdentifier().getDomainName()));
        response.setSecondConnectionIdentifier(connectionID2);
        response.setTransactionHandle(crcx.getTransactionHandle());
        if (isNewCall) {
            try {
                this.controller.addCall(call);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Save reference to the callID=" + call.getID()));
                }
            }
            catch (IllegalStateException e) {
                try {
                    if (logger.isEnabledFor((Priority)Level.ERROR)) {
                        logger.error((Object)("TX=" + txID + " Failed to add Call : " + call.getID() + ", from endpoint: " + endpoint.getLocalName()), (Throwable)e);
                    }
                    endpoint.deleteConnection(connection.getId());
                    endpoint2.deleteConnection(connection2.getId());
                }
                finally {
                    return new CreateConnectionResponse(crcx.getSource(), ReturnCode.Endpoint_Insufficient_Resources, ERROR_CONNID);
                }
            }
        }
        if (isNewCall) {
            this.controller.addCall(call);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Save reference to the callID=" + call.getID()));
            }
        }
        return response;
    }

    public JainMgcpResponseEvent call() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Request TX= " + this.crcx.getTransactionHandle() + ", CallID = " + this.crcx.getCallIdentifier() + ", Mode=" + this.crcx.getMode() + ", Endpoint = " + this.crcx.getEndpointIdentifier() + ", Endpoint2 = " + this.crcx.getSecondEndpointIdentifier() + ", SDP " + this.crcx.getRemoteConnectionDescriptor()));
        }
        JainMgcpResponseEvent response = this.crcx.getSecondEndpointIdentifier() == null ? this.createRtpConnection(this.crcx) : this.createLink(this.crcx);
        response.setTransactionHandle(this.crcx.getTransactionHandle());
        logger.info((Object)("Response TX = " + response.getTransactionHandle() + ", Response: " + response.getReturnCode()));
        return response;
    }
}

