/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.ctrl.mgcp;

import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.DeleteConnection;
import jain.protocol.ip.mgcp.message.DeleteConnectionResponse;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionParm;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.RegularConnectionParm;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.mobicents.media.server.ctrl.mgcp.ConnectionActivity;
import org.mobicents.media.server.ctrl.mgcp.MgcpController;
import org.mobicents.media.server.ctrl.mgcp.MgcpUtils;
import org.mobicents.media.server.spi.Endpoint;

public class DeleteConnectionAction
implements Callable {
    private static Logger logger = Logger.getLogger(DeleteConnectionAction.class);
    private DeleteConnection req;
    private MgcpController controller;
    private MgcpUtils utils = new MgcpUtils();

    protected DeleteConnectionAction(MgcpController controller, DeleteConnection req) {
        this.controller = controller;
        this.req = req;
    }

    private JainMgcpResponseEvent endpointDeleteConnections(String localName) {
        Endpoint endpoint = null;
        try {
            endpoint = this.controller.getServer().lookup(localName, true);
        }
        catch (Exception e) {
            return new DeleteConnectionResponse((Object)this.controller, ReturnCode.Endpoint_Unknown);
        }
        endpoint.deleteAllConnections();
        Collection<ConnectionActivity> activities = this.controller.getActivities(localName);
        for (ConnectionActivity activity : activities) {
            activity.close();
        }
        DeleteConnectionResponse response = new DeleteConnectionResponse((Object)this.controller, ReturnCode.Transaction_Executed_Normally);
        return response;
    }

    private JainMgcpResponseEvent deleteConnection(String localName, String connectionID) {
        Endpoint endpoint = null;
        try {
            endpoint = this.controller.getServer().lookup(localName, true);
        }
        catch (Exception e) {
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                logger.error((Object)("Failed on endpoint lookup: " + localName), (Throwable)e);
            }
            return new DeleteConnectionResponse((Object)this.controller, ReturnCode.Endpoint_Unknown);
        }
        ConnectionActivity activity = this.controller.getActivity(localName, connectionID);
        ConnectionParm[] parms = new ConnectionParm[]{new RegularConnectionParm(RegularConnectionParm.OCTETS_RECEIVED, (int)activity.connection.getBytesReceived()), new RegularConnectionParm(RegularConnectionParm.OCTETS_SENT, (int)activity.connection.getBytesTransmitted()), new RegularConnectionParm(RegularConnectionParm.JITTER, (int)(activity.connection.getJitter() * 1000.0))};
        endpoint.deleteConnection(activity.connection.getId());
        activity.close();
        DeleteConnectionResponse response = new DeleteConnectionResponse((Object)this.controller, ReturnCode.Transaction_Executed_Normally);
        response.setConnectionParms(parms);
        return response;
    }

    public JainMgcpResponseEvent call() throws Exception {
        int txID = this.req.getTransactionHandle();
        CallIdentifier callID = this.req.getCallIdentifier();
        EndpointIdentifier endpointID = this.req.getEndpointIdentifier();
        ConnectionIdentifier connectionID = this.req.getConnectionIdentifier();
        logger.info((Object)("Request TX= " + txID + ", CallID = " + callID + ", Endpoint = " + endpointID + ", Connection = " + connectionID));
        Object response = null;
        response = endpointID != null && callID == null && connectionID == null ? this.endpointDeleteConnections(endpointID.getLocalEndpointName()) : (endpointID != null && callID != null && connectionID == null ? this.endpointDeleteConnections(endpointID.getLocalEndpointName()) : (endpointID != null && callID != null && connectionID != null ? this.deleteConnection(endpointID.getLocalEndpointName(), connectionID.toString()) : new DeleteConnectionResponse((Object)this.controller, ReturnCode.Protocol_Error)));
        response.setTransactionHandle(txID);
        logger.info((Object)("Response TX=" + txID + ", response=" + response.getReturnCode()));
        return response;
    }
}

