/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.ctrl.mgcp;

import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.message.Notify;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mobicents.media.server.ctrl.mgcp.MgcpController;
import org.mobicents.media.server.ctrl.mgcp.evt.EventDetector;
import org.mobicents.media.server.ctrl.mgcp.evt.SignalGenerator;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.ConnectionListener;
import org.mobicents.media.server.spi.ConnectionMode;
import org.mobicents.media.server.spi.ConnectionState;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.protocols.mgcp.stack.ExtendedJainMgcpProvider;

public class Request
implements Runnable,
ConnectionListener {
    protected static int txID = 1;
    private RequestIdentifier reqID;
    private MgcpController controller;
    private EndpointIdentifier endpointID;
    private Endpoint endpoint;
    private ArrayList<Connection> connections = new ArrayList();
    private NotifiedEntity notifiedEntity;
    private HashMap<String, List<EventDetector>> connectionDetectors = new HashMap();
    private HashMap<String, List<SignalGenerator>> connectionGenerators = new HashMap();
    private ArrayList<EventDetector> endpointDetectors = new ArrayList();
    private ArrayList<SignalGenerator> endpointGenerators = new ArrayList();
    private HashMap<String, Iterator<SignalGenerator>> connectionSignalQueue = new HashMap();
    private Iterator<SignalGenerator> endpointSignalQueue;
    private HashMap<String, SignalGenerator> activeConnectionSignals = new HashMap();
    private SignalGenerator activeEndpointSignal;
    private ExtendedJainMgcpProvider extendedMgcpProvider;

    public Request(MgcpController controller, RequestIdentifier reqID, EndpointIdentifier endpointID, Endpoint endpoint, NotifiedEntity notifiedEntity) {
        this.controller = controller;
        this.extendedMgcpProvider = this.controller.getExtendedMgcpProvider();
        this.reqID = reqID;
        this.endpointID = endpointID;
        this.endpoint = endpoint;
        this.notifiedEntity = notifiedEntity;
    }

    public void append(EventDetector detector, Connection connection) {
        detector.setRequest(this);
        if (connection == null) {
            this.endpointDetectors.add(detector);
            return;
        }
        if (this.connectionDetectors.containsKey(connection.getId())) {
            this.connectionDetectors.get(connection.getId()).add(detector);
        } else {
            ArrayList<EventDetector> list = new ArrayList<EventDetector>();
            list.add(detector);
            this.connectionDetectors.put(connection.getId(), list);
            if (!this.connections.contains(connection)) {
                connection.addListener((ConnectionListener)this);
                this.connections.add(connection);
            }
        }
    }

    public void append(SignalGenerator generator, Connection connection) {
        if (connection == null) {
            this.endpointGenerators.add(generator);
            return;
        }
        if (this.connectionGenerators.containsKey(connection.getId())) {
            this.connectionGenerators.get(connection.getId()).add(generator);
        } else {
            ArrayList<SignalGenerator> list = new ArrayList<SignalGenerator>();
            list.add(generator);
            this.connectionGenerators.put(connection.getId(), list);
            if (!this.connections.contains(connection)) {
                connection.addListener((ConnectionListener)this);
                this.connections.add(connection);
            }
        }
    }

    public void run() {
        Collection<List<EventDetector>> detItems = this.connectionDetectors.values();
        for (List<EventDetector> item : detItems) {
            for (EventDetector det : item) {
                det.start();
            }
        }
        for (EventDetector det : this.endpointDetectors) {
            det.start();
        }
        Set<String> connectionIDs = this.connectionSignalQueue.keySet();
        for (String connectionID : connectionIDs) {
            Iterator<SignalGenerator> queue = this.connectionSignalQueue.get(connectionID);
            SignalGenerator gen = queue.next();
            this.activeConnectionSignals.put(connectionID, gen);
            gen.start(this);
        }
        if (this.endpointSignalQueue.hasNext()) {
            this.activeEndpointSignal = this.endpointSignalQueue.next();
            this.activeEndpointSignal.start(this);
        }
    }

    public void cancel() {
        Collection<List<EventDetector>> detItems = this.connectionDetectors.values();
        for (List<EventDetector> item : detItems) {
            for (EventDetector det : item) {
                det.stop();
            }
        }
        for (EventDetector det : this.endpointDetectors) {
            det.stop();
        }
        Collection<SignalGenerator> signals = this.activeConnectionSignals.values();
        for (SignalGenerator signal : signals) {
            signal.cancel();
        }
        if (this.activeEndpointSignal != null) {
            this.activeEndpointSignal.cancel();
        }
        this.connections.clear();
        this.endpointDetectors.clear();
        this.endpointGenerators.clear();
        this.connectionDetectors.clear();
        this.connectionGenerators.clear();
        this.activeConnectionSignals.clear();
    }

    private boolean verifyDetectors(Connection connection) {
        boolean res;
        if (!this.connectionDetectors.containsKey(connection.getId())) {
            return true;
        }
        Iterator<EventDetector> list = this.connectionDetectors.get(connection.getId()).iterator();
        for (res = true; res && list.hasNext(); res &= list.next().verify(connection)) {
        }
        return res;
    }

    private boolean verifyGenerators(Connection connection) {
        boolean res;
        if (!this.connectionGenerators.containsKey(connection.getId())) {
            return true;
        }
        Iterator<SignalGenerator> list = this.connectionGenerators.get(connection.getId()).iterator();
        for (res = true; res && list.hasNext(); res &= list.next().verify(connection)) {
        }
        if (res) {
            this.connectionSignalQueue.put(connection.getId(), this.connectionGenerators.get(connection.getId()).iterator());
        }
        return res;
    }

    public boolean verifyDetectors() {
        boolean res;
        Iterator<Connection> list = this.connections.iterator();
        for (res = true; res && list.hasNext(); res &= this.verifyDetectors(list.next())) {
        }
        Iterator<EventDetector> list2 = this.endpointDetectors.iterator();
        while (res && list2.hasNext()) {
            res &= list2.next().verify(this.endpoint);
        }
        return res;
    }

    public boolean verifyGenerators() {
        boolean res;
        Iterator<Connection> list = this.connections.iterator();
        for (res = true; res && list.hasNext(); res &= this.verifyGenerators(list.next())) {
        }
        Iterator<SignalGenerator> list2 = this.endpointGenerators.iterator();
        while (res && list2.hasNext()) {
            res &= list2.next().verify(this.endpoint);
        }
        this.endpointSignalQueue = this.endpointGenerators.iterator();
        return res;
    }

    public void onStateChange(Connection connection, ConnectionState oldState) {
        if (connection.getState() != ConnectionState.CLOSED) {
            return;
        }
        this.connectionSignalQueue.remove(connection.getId());
        this.connectionGenerators.remove(connection.getId());
        SignalGenerator gen = this.activeConnectionSignals.get(connection.getId());
        if (gen != null) {
            gen.cancel();
        }
        this.connectionDetectors.remove(connection.getId());
        List<EventDetector> list = this.connectionDetectors.remove(connection.getId());
        if (list != null) {
            for (EventDetector det : list) {
                det.stop();
            }
        }
        this.connections.remove(connection);
    }

    public void onModeChange(Connection connection, ConnectionMode oldMode) {
    }

    public void onError(Connection connection, Exception e) {
    }

    public int getTxID() {
        if (++txID == Integer.MAX_VALUE) {
            txID = 1;
        }
        return txID;
    }

    public void sendNotify(EventName eventName) {
        Notify notify = new Notify((Object)this, this.endpointID, this.reqID, new EventName[]{eventName});
        notify.setNotifiedEntity(this.notifiedEntity);
        notify.setTransactionHandle(txID++);
        notify.setRequestIdentifier(this.reqID);
        this.extendedMgcpProvider.sendAsyncMgcpEvents(new JainMgcpEvent[]{notify});
    }
}

