/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.ctrl.mgcp.evt;

import jain.protocol.ip.mgcp.message.parms.RequestedAction;
import jain.protocol.ip.mgcp.pkg.MgcpEvent;
import java.util.List;
import org.mobicents.media.server.ctrl.mgcp.MgcpController;
import org.mobicents.media.server.ctrl.mgcp.evt.DetectorFactory;
import org.mobicents.media.server.ctrl.mgcp.evt.EventDetector;
import org.mobicents.media.server.ctrl.mgcp.evt.GeneratorFactory;
import org.mobicents.media.server.ctrl.mgcp.evt.SignalGenerator;
import org.mobicents.media.server.spi.MediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MgcpPackage {
    private String name;
    private int id;
    private MgcpController controller;
    private GeneratorFactory[] generators;
    private DetectorFactory[] detectors;
    private MediaType mediaType;
    private Class detectorInterface;

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public String getDetectorInterface() {
        if (this.detectorInterface == null) {
            return null;
        }
        return this.detectorInterface.toString();
    }

    public Class getCDetectorInterface() {
        return this.detectorInterface;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public void setDetectorInterface(String detectorInterface) {
        try {
            this.detectorInterface = Class.forName(detectorInterface);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MgcpController getController() {
        return this.controller;
    }

    public void setController(MgcpController controller) {
        this.controller = controller;
    }

    public GeneratorFactory[] _getGenerators() {
        return this.generators;
    }

    public void setGenerators(List<GeneratorFactory> signals) {
        try {
            if (signals != null) {
                this.generators = new GeneratorFactory[signals.size()];
                for (int i = 0; i < signals.size(); ++i) {
                    GeneratorFactory factory = signals.get(i);
                    factory.setPackage(this);
                    this.generators[i] = factory;
                }
            } else {
                this.generators = new GeneratorFactory[0];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DetectorFactory[] _getDetectors() {
        return this.detectors;
    }

    public void setDetectors(List<DetectorFactory> events) {
        try {
            if (events != null) {
                this.detectors = new DetectorFactory[events.size()];
                for (int i = 0; i < events.size(); ++i) {
                    DetectorFactory factory = events.get(i);
                    factory.setPackage(this);
                    this.detectors[i] = factory;
                }
            } else {
                this.detectors = new DetectorFactory[0];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SignalGenerator getGenerator(MgcpEvent evt) {
        if (this.generators != null) {
            for (GeneratorFactory factory : this.generators) {
                if (!factory.getEventName().equals(evt.getName())) continue;
                return factory.getInstance(this.controller, evt.getParms());
            }
        }
        return null;
    }

    public EventDetector getDetector(MgcpEvent evt, RequestedAction[] actions) {
        if (this.detectors != null) {
            for (DetectorFactory factory : this.detectors) {
                if (!factory.getEventName().equals(evt.getName())) continue;
                EventDetector det = null;
                det = factory.getInstance(evt.getParms(), actions, this.detectorInterface, this.mediaType);
                det.setPackage(this);
                return det;
            }
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MgcpPackage other = (MgcpPackage)obj;
        if (this.id != other.id) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "MgcpPackage [detectorInterface=" + this.detectorInterface + ", id=" + this.id + ", mediaType=" + this.mediaType + ", name=" + this.name + "]";
    }
}

