/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.ctrl.mgcp.evt.dtmf;

import org.mobicents.media.MediaSource;
import org.mobicents.media.server.ctrl.mgcp.MgcpController;
import org.mobicents.media.server.ctrl.mgcp.Request;
import org.mobicents.media.server.ctrl.mgcp.evt.EventDetector;
import org.mobicents.media.server.ctrl.mgcp.evt.GeneratorFactory;
import org.mobicents.media.server.ctrl.mgcp.evt.MgcpPackage;
import org.mobicents.media.server.ctrl.mgcp.evt.SignalGenerator;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.MediaType;
import org.mobicents.media.server.spi.resource.DtmfDetector;
import org.mobicents.media.server.spi.resource.DtmfGenerator;

public class DtmfGeneratorFactory
implements GeneratorFactory {
    private String name;
    private MgcpPackage mgcpPackage;
    private String digit;

    public String getEventName() {
        return this.name;
    }

    public MgcpPackage getPackage() {
        return this.mgcpPackage;
    }

    public void setEventName(String eventName) {
        this.name = eventName;
    }

    public void setPackage(MgcpPackage mgcpPackage) {
        this.mgcpPackage = mgcpPackage;
    }

    public String getDigit() {
        return this.digit;
    }

    public void setDigit(String digit) {
        this.digit = digit;
    }

    public SignalGenerator getInstance(MgcpController controller, String param) {
        return new MgcpDtmfGenerator(this.digit);
    }

    private class MgcpDtmfGenerator
    extends SignalGenerator {
        private String digit;
        private DtmfGenerator dtmfGenerator;
        private MediaType mediaType;
        private Class detectorInterface;
        private Class generatorInterface;

        public MgcpDtmfGenerator(String digit) {
            super(digit);
            this.digit = null;
            this.dtmfGenerator = null;
            this.digit = digit;
            this.mediaType = MediaType.AUDIO;
            this.detectorInterface = DtmfDetector.class;
            this.generatorInterface = DtmfGenerator.class;
        }

        public void cancel() {
        }

        protected boolean doVerify(Connection connection) {
            MediaSource source = (MediaSource)connection.getComponent(MediaType.AUDIO, this.generatorInterface);
            if (source != null) {
                this.dtmfGenerator = (DtmfGenerator)source.getInterface(this.generatorInterface);
                return true;
            }
            return false;
        }

        protected boolean doVerify(Endpoint endpoint) {
            MediaSource source = endpoint.getSource(MediaType.AUDIO);
            if (source != null) {
                this.dtmfGenerator = (DtmfGenerator)source.getInterface(DtmfGenerator.class);
                return this.dtmfGenerator != null;
            }
            return false;
        }

        public void start(Request request) {
            this.dtmfGenerator.setDigit(this.digit);
            this.dtmfGenerator.start();
        }

        public void configureDetector(EventDetector det) {
            det.setMediaType(MediaType.AUDIO);
            det.setDetectorInterface(this.detectorInterface);
        }
    }
}

