/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.ctrl.mgcp.evt.ivr;

import org.mobicents.media.Component;
import org.mobicents.media.MediaSource;
import org.mobicents.media.server.ctrl.mgcp.MgcpController;
import org.mobicents.media.server.ctrl.mgcp.Request;
import org.mobicents.media.server.ctrl.mgcp.evt.EventDetector;
import org.mobicents.media.server.ctrl.mgcp.evt.GeneratorFactory;
import org.mobicents.media.server.ctrl.mgcp.evt.MgcpPackage;
import org.mobicents.media.server.ctrl.mgcp.evt.SignalGenerator;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.MediaType;
import org.mobicents.media.server.spi.resource.Recorder;

public class RecorderFactory
implements GeneratorFactory {
    private String name;
    private MgcpPackage mgcpPackage;

    public String getEventName() {
        return this.name;
    }

    public SignalGenerator getInstance(MgcpController controller, String parms) {
        MediaType type = this.mgcpPackage.getMediaType();
        if (type == null) {
            type = MediaType.AUDIO;
        }
        return new MgcpRecorder(parms, type);
    }

    public MgcpPackage getPackage() {
        return this.mgcpPackage;
    }

    public void setEventName(String eventName) {
        this.name = eventName;
    }

    public void setPackage(MgcpPackage mgcpPackage) {
        this.mgcpPackage = mgcpPackage;
    }

    private static String getExtension(String parms) {
        int dotIndex = parms.lastIndexOf(".");
        return parms.substring(dotIndex + 1);
    }

    private class MgcpRecorder
    extends SignalGenerator {
        private Recorder recorder;
        private String url;
        private Class detectorInterface;
        private Class generatorInterface;
        private MediaType mediaType;

        public MgcpRecorder(String url, MediaType mediaType) {
            super(url);
            this.url = url;
            this.detectorInterface = Recorder.class;
            this.generatorInterface = this.detectorInterface;
            this.mediaType = mediaType;
        }

        public void cancel() {
            this.recorder.stop();
        }

        protected boolean doVerify(Connection connection) {
            Component source = connection.getComponent(this.mediaType, this.generatorInterface);
            if (source != null) {
                this.recorder = (Recorder)source.getInterface(Recorder.class);
                return true;
            }
            return false;
        }

        protected boolean doVerify(Endpoint endpoint) {
            MediaSource source = endpoint.getSource(this.mediaType);
            if (source != null) {
                this.recorder = (Recorder)source.getInterface(Recorder.class);
                return this.recorder != null;
            }
            return false;
        }

        public void start(Request request) {
            try {
                this.recorder.setRecordFile(this.url);
                this.recorder.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void configureDetector(EventDetector det) {
            det.setDetectorInterface(this.detectorInterface);
            det.setMediaType(this.mediaType);
        }
    }
}

