/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server;

import java.util.Map;
import java.util.Set;
import org.mobicents.media.server.ConnectionStateManager;
import org.mobicents.media.server.resource.ChannelFactory;
import org.mobicents.media.server.spi.MediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionFactory {
    private ConnectionStateManager connectionStateManager;
    private ChannelFactory[] rxFactory = new ChannelFactory[2];
    private ChannelFactory[] txFactory = new ChannelFactory[2];

    public ChannelFactory[] getRxFactory() {
        return this.rxFactory;
    }

    public void setRxChannelFactory(Map<String, ChannelFactory> config) {
        if (config != null) {
            this.define(config, this.rxFactory);
        }
    }

    public ChannelFactory[] getTxFactory() {
        return this.txFactory;
    }

    public void setTxChannelFactory(Map<String, ChannelFactory> config) {
        if (config != null) {
            this.define(config, this.txFactory);
        }
    }

    public ConnectionStateManager getConnectionStateManager() {
        return this.connectionStateManager;
    }

    public void setConnectionStateManager(ConnectionStateManager connectionStateManager) {
        this.connectionStateManager = connectionStateManager;
    }

    private void define(Map<String, ChannelFactory> config, ChannelFactory[] factories) {
        Set<String> names = config.keySet();
        for (String name : names) {
            MediaType mediaType = MediaType.getInstance((String)name);
            ChannelFactory factory = config.get(name);
            factory.setMediaType(mediaType);
            factories[mediaType.getCode()] = factory;
        }
    }
}

