/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.mobicents.media.Component;
import org.mobicents.media.server.ConnectionFactory;
import org.mobicents.media.server.EndpointImpl;
import org.mobicents.media.server.resource.Channel;
import org.mobicents.media.server.resource.ChannelFactory;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.ConnectionListener;
import org.mobicents.media.server.spi.ConnectionMode;
import org.mobicents.media.server.spi.ConnectionState;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.MediaType;
import org.mobicents.media.server.spi.NotificationListener;
import org.mobicents.media.server.spi.ResourceUnavailableException;
import org.mobicents.media.server.spi.clock.Task;

public abstract class ConnectionImpl
implements Connection,
Task {
    private static int GEN = 1;
    private String id;
    private int index;
    private EndpointImpl endpoint;
    private ConnectionState state = ConnectionState.NULL;
    protected ConnectionMode[] mode = new ConnectionMode[]{ConnectionMode.INACTIVE, ConnectionMode.INACTIVE};
    protected Channel[] txChannels = new Channel[2];
    protected Channel[] rxChannels = new Channel[2];
    protected ConcurrentHashMap connectionListeners = new ConcurrentHashMap();
    protected volatile int stream;
    private int[] lifeTime = new int[]{0, 30000, 3600000, 3600000, 0};
    private long startTime;

    public ConnectionImpl(EndpointImpl endpoint) throws ResourceUnavailableException {
        this.endpoint = endpoint;
        this.id = this.genID();
        ConnectionFactory factory = endpoint.getConnectionFactory();
        this.initRx(factory);
        this.initTx(factory);
    }

    private void initTx(ConnectionFactory factory) throws ResourceUnavailableException {
        ChannelFactory[] txFactories = factory.getTxFactory();
        Collection<MediaType> mediaTypes = this.endpoint.getMediaTypes();
        for (MediaType mediaType : mediaTypes) {
            ChannelFactory channelFactory = txFactories[mediaType.getCode()];
            if (channelFactory == null) continue;
            Channel channel = channelFactory.newInstance(this.endpoint, mediaType);
            channel.setEndpoint(this.endpoint);
            channel.setConnection(this);
            this.txChannels[mediaType.getCode()] = channel;
        }
    }

    private void initRx(ConnectionFactory factory) throws ResourceUnavailableException {
        ChannelFactory[] rxFactories = factory.getRxFactory();
        Collection<MediaType> mediaTypes = this.endpoint.getMediaTypes();
        for (MediaType mediaType : mediaTypes) {
            ChannelFactory channelFactory = rxFactories[mediaType.getCode()];
            if (channelFactory == null) continue;
            Channel channel = channelFactory.newInstance(this.endpoint, mediaType);
            channel.setEndpoint(this.endpoint);
            channel.setConnection(this);
            this.rxChannels[mediaType.getCode()] = channel;
        }
    }

    protected void join(MediaType mediaType) {
        int i = mediaType.getCode();
        if (this.rxChannels[i] != null && this.endpoint.getSink(mediaType) != null) {
            this.rxChannels[i].connect(this.endpoint.getSink(mediaType));
        }
        if (this.txChannels[i] != null && this.endpoint.getSource(mediaType) != null) {
            this.txChannels[i].connect(this.endpoint.getSource(mediaType));
        }
        if (this.state == ConnectionState.NULL) {
            this.setState(ConnectionState.IDLE);
        }
        this.stream |= mediaType.getMask();
    }

    protected void join() {
        Collection<MediaType> mediaTypes = this.endpoint.getMediaTypes();
        for (MediaType mediaType : mediaTypes) {
            this.join(mediaType);
        }
    }

    protected void bind(MediaType mediaType) throws ResourceUnavailableException {
        if (this.state == ConnectionState.IDLE) {
            this.setState(ConnectionState.HALF_OPEN);
        }
    }

    private String genID() {
        if (++GEN == Integer.MAX_VALUE) {
            GEN = 1;
        }
        return Integer.toHexString(GEN);
    }

    public String getId() {
        return this.id;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public ConnectionState getState() {
        return this.state;
    }

    protected void setState(ConnectionState state) {
        ConnectionState oldState = this.state;
        this.state = state;
        if (oldState != this.state) {
            for (Object ocl : this.connectionListeners.keySet()) {
                ConnectionListener cl = (ConnectionListener)ocl;
                cl.onStateChange((Connection)this, oldState);
            }
        }
    }

    public int[] getLifeTime() {
        return this.lifeTime;
    }

    public void setLifeTime(int[] lifeTime) {
        this.lifeTime = lifeTime;
    }

    public ConnectionMode getMode(MediaType mediaType) {
        return this.mode[mediaType.getCode()];
    }

    public void setMode(ConnectionMode mode, MediaType mediaType) {
        if ((this.stream & mediaType.getMask()) != 0) {
            Channel txChannel = this.txChannels[mediaType.getCode()];
            Channel rxChannel = this.rxChannels[mediaType.getCode()];
            if (mode == ConnectionMode.SEND_RECV) {
                if (txChannel != null) {
                    txChannel.start();
                }
                if (rxChannel != null) {
                    rxChannel.start();
                }
            } else if (mode == ConnectionMode.SEND_ONLY) {
                if (txChannel != null) {
                    txChannel.start();
                }
                if (rxChannel != null) {
                    rxChannel.stop();
                }
            } else if (mode == ConnectionMode.RECV_ONLY) {
                if (txChannel != null) {
                    txChannel.stop();
                }
                if (rxChannel != null) {
                    rxChannel.start();
                }
            }
            if (mode == ConnectionMode.INACTIVE) {
                if (txChannel != null) {
                    txChannel.stop();
                }
                if (rxChannel != null) {
                    rxChannel.stop();
                }
            }
            this.mode[mediaType.getCode()] = mode;
        }
    }

    public void setMode(ConnectionMode mode) {
        this.setMode(mode, MediaType.AUDIO);
        this.setMode(mode, MediaType.VIDEO);
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void addListener(ConnectionListener listener) {
        this.connectionListeners.put(listener, listener);
    }

    public void removeListener(ConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    public Component getComponent(String name) {
        Component c = this.getComponent(this.rxChannels, name);
        if (c == null) {
            c = this.getComponent(this.txChannels, name);
        }
        return c;
    }

    private Component getComponent(Channel[] channels, String name) {
        for (Channel channel : channels) {
            Component component = channel.getComponent(name);
            if (component == null) continue;
            return component;
        }
        return null;
    }

    public Component getComponent(MediaType type, Class interface1) {
        Component c = this.getComponent(this.rxChannels[type.getCode()], interface1);
        if (c == null) {
            c = this.getComponent(this.txChannels[type.getCode()], interface1);
        }
        return c;
    }

    private Component getComponent(Channel channel, Class interface1) {
        if (channel != null) {
            return channel.getComponent(interface1);
        }
        return null;
    }

    public void addNotificationListener(NotificationListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeNotificationListener(NotificationListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected void close(MediaType mediaType) {
        if ((this.stream & mediaType.getMask()) != 0) {
            int i = mediaType.getCode();
            if (this.rxChannels[i] != null && this.endpoint.getSink(mediaType) != null) {
                this.rxChannels[i].disconnect(this.endpoint.getSink(mediaType));
                this.rxChannels[i].stop();
            }
            if (this.txChannels[i] != null && this.endpoint.getSource(mediaType) != null) {
                this.txChannels[i].disconnect(this.endpoint.getSource(mediaType));
                this.txChannels[i].stop();
            }
            this.mode[i] = ConnectionMode.INACTIVE;
            this.stream ^= mediaType.getMask();
            if ((this.stream & 3) == 0) {
                this.setState(ConnectionState.NULL);
            }
        }
    }

    protected void close() {
        Collection<MediaType> mediaTypes = this.endpoint.getMediaTypes();
        for (MediaType mediaType : mediaTypes) {
            this.close(mediaType);
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void cancel() {
    }

    public boolean isActive() {
        return this.state != ConnectionState.NULL && this.state != ConnectionState.CLOSED;
    }

    public int perform() {
        long endTime;
        long currentTime = System.currentTimeMillis();
        if (currentTime >= (endTime = this.startTime + (long)this.lifeTime[this.state.getCode()])) {
            this.endpoint.deleteConnection(this.id);
            return 0;
        }
        return (int)(endTime - currentTime);
    }
}

