/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.mobicents.media.Buffer;
import org.mobicents.media.Component;
import org.mobicents.media.ComponentFactory;
import org.mobicents.media.Format;
import org.mobicents.media.MediaSink;
import org.mobicents.media.MediaSource;
import org.mobicents.media.server.ConnectionFactory;
import org.mobicents.media.server.ConnectionImpl;
import org.mobicents.media.server.LocalConnectionImpl;
import org.mobicents.media.server.RtpConnectionImpl;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.AbstractSource;
import org.mobicents.media.server.impl.rtp.RtpFactory;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.ConnectionListener;
import org.mobicents.media.server.spi.ConnectionState;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.MediaType;
import org.mobicents.media.server.spi.MultimediaSink;
import org.mobicents.media.server.spi.MultimediaSource;
import org.mobicents.media.server.spi.NotificationListener;
import org.mobicents.media.server.spi.ResourceGroup;
import org.mobicents.media.server.spi.ResourceUnavailableException;
import org.mobicents.media.server.spi.TooManyConnectionsException;
import org.mobicents.media.server.spi.clock.Task;
import org.mobicents.media.server.spi.clock.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointImpl
implements Endpoint {
    private String localName;
    private boolean isInUse = false;
    private Timer timer;
    private Map<String, ComponentFactory> sourceFactory;
    private Map<String, ComponentFactory> sinkFactory;
    private ComponentFactory groupFactory;
    protected ConnectionFactory connectionFactory;
    protected RtpFactory rtpFactory;
    private HashMap<MediaType, MediaSource> sources = new HashMap();
    private HashMap<MediaType, MediaSink> sinks = new HashMap();
    private ArrayList<MediaType> mediaTypes = new ArrayList();
    private ArrayList<Integer> index = new ArrayList();
    private int lastIndex = -1;
    private static final int _CONNECTION_TAB_SIZE = 10;
    private LocalConnectionImpl[] localConnections;
    private RtpConnectionImpl[] networkConnections;
    private Connection[] connections;
    private int count;
    protected ReentrantLock state = new ReentrantLock();
    private final Logger logger = Logger.getLogger(EndpointImpl.class);

    public EndpointImpl() {
    }

    public EndpointImpl(String localName) {
        this.localName = localName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public Collection<MediaType> getMediaTypes() {
        return this.mediaTypes;
    }

    public MediaSink getSink(MediaType media) {
        MediaSink sink = this.sinks.get(media);
        if (sink == null) {
            sink = new VirtualSink("virtual.sink");
            this.sinks.put(media, sink);
        }
        return sink;
    }

    public MediaSource getSource(MediaType media) {
        return this.sources.get(media);
    }

    public int getConnectionIndex() {
        return this.index.isEmpty() ? (this.lastIndex = this.lastIndex + 1) : this.index.remove(0);
    }

    private MediaType[] getMediaTypes(String media) {
        if (media.equalsIgnoreCase("audio")) {
            return new MediaType[]{MediaType.AUDIO};
        }
        if (media.equals("video")) {
            return new MediaType[]{MediaType.VIDEO};
        }
        if (media.equals("*")) {
            return new MediaType[]{MediaType.AUDIO, MediaType.VIDEO};
        }
        throw new IllegalArgumentException("Unknown media type " + media);
    }

    private void createSources() throws ResourceUnavailableException {
        if (this.sourceFactory == null) {
            return;
        }
        Set<String> types = this.sourceFactory.keySet();
        for (String media : types) {
            ComponentFactory factory = this.sourceFactory.get(media);
            Component source = factory.newInstance((Endpoint)this);
            source.setEndpoint((Endpoint)this);
            MediaType[] list = this.getMediaTypes(media);
            for (int i = 0; i < list.length; ++i) {
                if (source instanceof MediaSource) {
                    this.sources.put(list[i], (MediaSource)source);
                } else if (source instanceof MultimediaSource) {
                    this.sources.put(list[i], ((MultimediaSource)source).getMediaSource(list[i]));
                } else {
                    this.logger.warn((Object)("Component " + source.toString() + " is neither instance of MediaSource or MultimediaSource"));
                }
                if (this.mediaTypes.contains(list[i])) continue;
                this.mediaTypes.add(list[i]);
            }
        }
    }

    private void createSource(ResourceGroup group) {
        Collection list = group.getMediaTypes();
        for (MediaType mediaType : list) {
            MediaSource source = group.getSource(mediaType);
            if (source == null) continue;
            source.setEndpoint((Endpoint)this);
            this.sources.put(mediaType, source);
            if (this.mediaTypes.contains(mediaType)) continue;
            this.mediaTypes.add(mediaType);
        }
    }

    private void createSinks() throws ResourceUnavailableException {
        if (this.sinkFactory == null) {
            return;
        }
        Set<String> types = this.sinkFactory.keySet();
        for (String media : types) {
            ComponentFactory factory = this.sinkFactory.get(media);
            Component sink = factory.newInstance((Endpoint)this);
            sink.setEndpoint((Endpoint)this);
            MediaType[] list = this.getMediaTypes(media);
            for (int i = 0; i < list.length; ++i) {
                if (sink instanceof MediaSink) {
                    this.sinks.put(list[i], (MediaSink)sink);
                } else if (sink instanceof MultimediaSink) {
                    this.sinks.put(list[i], ((MultimediaSink)sink).getMediaSink(list[i]));
                } else {
                    this.logger.warn((Object)("Component " + sink.toString() + " is neither instance of MediaSink or MultimediaSink"));
                }
                if (this.mediaTypes.contains(list[i])) continue;
                this.mediaTypes.add(list[i]);
            }
        }
    }

    private void createSink(ResourceGroup group) {
        Collection list = group.getMediaTypes();
        for (MediaType mediaType : list) {
            MediaSink sink = group.getSink(mediaType);
            if (sink == null) continue;
            sink.setEndpoint((Endpoint)this);
            this.sinks.put(mediaType, sink);
            if (this.mediaTypes.contains(mediaType)) continue;
            this.mediaTypes.add(mediaType);
        }
    }

    public void start() throws ResourceUnavailableException {
        int i;
        this.networkConnections = new RtpConnectionImpl[10];
        this.localConnections = new LocalConnectionImpl[10];
        this.connections = new ConnectionImpl[10];
        if (this.groupFactory != null) {
            ResourceGroup group = (ResourceGroup)this.groupFactory.newInstance((Endpoint)this);
            this.createSource(group);
            this.createSink(group);
        } else {
            this.createSources();
            this.createSinks();
        }
        for (i = 0; i < this.connections.length; ++i) {
            this.localConnections[i] = new LocalConnectionImpl(this);
            this.setLifeTime(this.localConnections[i]);
        }
        if (this.rtpFactory != null) {
            for (i = 0; i < this.connections.length; ++i) {
                this.networkConnections[i] = new RtpConnectionImpl(this);
                this.setLifeTime(this.networkConnections[i]);
            }
        }
        this.logger.info((Object)("Started " + this.localName));
    }

    private void setLifeTime(Connection connection) {
        if (this.connectionFactory != null && this.connectionFactory.getConnectionStateManager() != null) {
            Hashtable<ConnectionState, Integer> connStateLifeTime = this.connectionFactory.getConnectionStateManager().getConnStateLifeTime();
            for (ConnectionState connState : connStateLifeTime.keySet()) {
                connection.getLifeTime()[connState.getCode()] = connStateLifeTime.get(connState);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("silence for state " + connState + " is " + connStateLifeTime.get(connState)));
            }
        }
    }

    public void stop() {
        this.logger.info((Object)("Stopped " + this.localName));
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public void setSourceFactory(Map<String, ComponentFactory> sourceFactory) {
        this.sourceFactory = sourceFactory;
    }

    public Map<String, ComponentFactory> getSourceFactory() {
        return this.sourceFactory;
    }

    public void setSinkFactory(Map<String, ComponentFactory> sinkFactory) {
        this.sinkFactory = sinkFactory;
    }

    public Map<String, ComponentFactory> getSinkFactory() {
        return this.sinkFactory;
    }

    public ComponentFactory getGroupFactory() {
        return this.groupFactory;
    }

    public void setGroupFactory(ComponentFactory groupFactory) {
        this.groupFactory = groupFactory;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setRtpFactory(RtpFactory rtpFactory) {
        this.rtpFactory = rtpFactory;
    }

    public RtpFactory getRtpFactory() {
        return this.rtpFactory;
    }

    public Collection<Connection> getConnections() {
        return null;
    }

    public String describe(MediaType mediaType) throws ResourceUnavailableException {
        String sdp = null;
        this.state.lock();
        try {
            RtpConnectionImpl connection = null;
            for (int i = 0; i < this.networkConnections.length; ++i) {
                if (this.networkConnections[i].getState() != ConnectionState.NULL) continue;
                connection = this.networkConnections[i];
                break;
            }
            if (connection == null) {
                throw new ResourceUnavailableException("The limit of network connection is exeeded");
            }
            if (mediaType == null) {
                connection.join();
                sdp = connection.getLocalDescriptor();
                connection.close();
            } else {
                connection.join(mediaType);
                sdp = connection.getLocalDescriptor();
                connection.close(mediaType);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Could not create RTP connection", (Throwable)e);
            throw new ResourceUnavailableException(e.getMessage());
        }
        finally {
            this.state.unlock();
        }
        return sdp;
    }

    public Connection createConnection() throws TooManyConnectionsException, ResourceUnavailableException {
        this.state.lock();
        try {
            int i;
            RtpConnectionImpl connection = null;
            for (i = 0; i < this.networkConnections.length; ++i) {
                if (this.networkConnections[i].getState() != ConnectionState.NULL) continue;
                connection = this.networkConnections[i];
                break;
            }
            if (connection == null) {
                throw new ResourceUnavailableException("The limit of network connection is exeeded");
            }
            for (i = 0; i < this.connections.length; ++i) {
                if (this.connections[i] != null) continue;
                connection.setIndex(i);
                System.out.println("Connection index=" + i);
                this.connections[i] = connection;
                break;
            }
            connection.join();
            connection.bind();
            connection.setStartTime(System.currentTimeMillis());
            this.timer.sync((Task)connection);
            ++this.count;
            this.isInUse = true;
            RtpConnectionImpl rtpConnectionImpl = connection;
            return rtpConnectionImpl;
        }
        catch (Exception e) {
            this.logger.error((Object)"Could not create RTP connection", (Throwable)e);
            throw new ResourceUnavailableException(e.getMessage());
        }
        finally {
            this.state.unlock();
        }
    }

    public Connection createLocalConnection() throws TooManyConnectionsException, ResourceUnavailableException {
        this.state.lock();
        try {
            int i;
            ConnectionImpl connection = null;
            for (i = 0; i < this.localConnections.length; ++i) {
                if (this.localConnections[i].getState() != ConnectionState.NULL) continue;
                connection = this.localConnections[i];
                break;
            }
            if (connection == null) {
                throw new ResourceUnavailableException("The limit of network connection is exeeded");
            }
            for (i = 0; i < this.connections.length; ++i) {
                if (this.connections[i] != null) continue;
                connection.setIndex(i);
                this.connections[i] = connection;
                if (!this.logger.isInfoEnabled()) break;
                this.logger.info((Object)("Connection index: " + i + ", on endpoint: " + this.localName));
                break;
            }
            connection.join();
            ((LocalConnectionImpl)connection).bind();
            connection.setStartTime(System.currentTimeMillis());
            this.timer.sync((Task)connection);
            ++this.count;
            this.isInUse = true;
            ConnectionImpl connectionImpl = connection;
            return connectionImpl;
        }
        catch (Exception e) {
            this.logger.error((Object)"Could not create Local connection", (Throwable)e);
            throw new ResourceUnavailableException(e.getMessage());
        }
        finally {
            this.state.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteConnection(String connectionID) {
        this.state.lock();
        try {
            ConnectionImpl connection = null;
            for (int i = 0; i < this.connections.length; ++i) {
                if (this.connections[i] == null || !((ConnectionImpl)this.connections[i]).getId().equals(connectionID)) continue;
                connection = (ConnectionImpl)this.connections[i];
                this.connections[i] = null;
                break;
            }
            if (connection != null) {
                connection.close();
                --this.count;
            }
            this.isInUse = this.count > 0;
        }
        finally {
            this.state.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllConnections() {
        this.state.lock();
        try {
            for (int i = 0; i < this.connections.length; ++i) {
                if (this.connections[i] == null) continue;
                ((ConnectionImpl)this.connections[i]).close();
                this.connections[i] = null;
            }
            this.count = 0;
        }
        finally {
            this.state.unlock();
        }
    }

    public boolean hasConnections() {
        return this.count > 0;
    }

    public boolean isInUse() {
        return this.isInUse;
    }

    public void setInUse(boolean inUse) {
        this.isInUse = inUse;
    }

    public void addNotificationListener(NotificationListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeNotificationListener(NotificationListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addConnectionListener(ConnectionListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeConnectionListener(ConnectionListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String[] getSupportedPackages() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Connection getConnection(String connectionID) {
        for (int i = 0; i < this.connections.length; ++i) {
            if (this.connections[i] == null || !this.connections[i].getId().equals(connectionID)) continue;
            return this.connections[i];
        }
        return null;
    }

    public Component getComponent(String name) {
        Collection<MediaSource> components = this.sources.values();
        for (MediaSource source : components) {
            if (!source.getName().matches(name)) continue;
            return source;
        }
        Collection<MediaSink> components2 = this.sinks.values();
        for (MediaSink sink : components2) {
            if (!sink.getName().matches(name)) continue;
            return sink;
        }
        return null;
    }

    public Endpoint clone() {
        EndpointImpl enp = new EndpointImpl();
        enp.setTimer(this.getTimer());
        enp.setRtpFactory(this.getRtpFactory());
        enp.setConnectionFactory(this.getConnectionFactory());
        enp.setSourceFactory(this.getSourceFactory());
        enp.setSinkFactory(this.getSinkFactory());
        enp.setGroupFactory(this.getGroupFactory());
        return enp;
    }

    public String getLocalAddress(String media) {
        return this.rtpFactory != null ? this.rtpFactory.getBindAddress() : "0.0.0.0";
    }

    public int getLocalPort(String media) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private class VirtualSource
    extends AbstractSource {
        public VirtualSource(String name) {
            super(name);
        }

        public void evolve(Buffer buffer, long timestamp) {
            buffer.setFlags(4);
        }

        public Format[] getFormats() {
            return new Format[]{Format.ANY};
        }
    }

    private class VirtualSink
    extends AbstractSink {
        public VirtualSink(String name) {
            super(name);
        }

        public Format[] getFormats() {
            return new Format[]{Format.ANY};
        }

        public boolean isAcceptable(Format format) {
            return true;
        }

        public void onMediaTransfer(Buffer buffer) throws IOException {
        }
    }
}

