/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl;

import java.util.Collection;
import java.util.HashMap;
import org.mobicents.media.MediaSink;
import org.mobicents.media.MediaSource;
import org.mobicents.media.server.impl.AbstractSink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSinkSet
extends AbstractSink
implements MediaSink {
    private HashMap<String, AbstractSink> sinks = new HashMap();

    public AbstractSinkSet(String name) {
        super(name);
    }

    public Collection<AbstractSink> getStreams() {
        return this.sinks.values();
    }

    @Override
    public boolean isMultipleConnectionsAllowed() {
        return true;
    }

    @Override
    public void connect(MediaSource source) {
        if (source.isMultipleConnectionsAllowed()) {
            throw new IllegalArgumentException(source + " allows muliple connection and this component also");
        }
        AbstractSink sink = this.createSink(source);
        sink.setEndpoint(this.getEndpoint());
        sink.setConnection(this.getConnection());
        sink.connect(source);
        this.sinks.put(source.getId(), sink);
    }

    @Override
    public void disconnect(MediaSource source) {
        AbstractSink sink = this.sinks.remove(source.getId());
        if (sink == null) {
            throw new IllegalArgumentException(source + " is not connected to " + this);
        }
        sink.stop();
        sink.disconnect(source);
        this.destroySink(sink);
        sink.setEndpoint(null);
        sink.setConnection(null);
    }

    public int getActiveSinkCount() {
        return this.sinks.size();
    }

    public abstract AbstractSink createSink(MediaSource var1);

    public abstract void destroySink(AbstractSink var1);
}

