/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl;

import java.util.Collection;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.Inlet;
import org.mobicents.media.MediaSink;
import org.mobicents.media.MediaSource;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.BaseComponent;
import org.mobicents.media.server.impl.FailureEventImpl;
import org.mobicents.media.server.impl.NotifyEventImpl;
import org.mobicents.media.server.spi.SyncSource;
import org.mobicents.media.server.spi.events.NotifyEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSource
extends BaseComponent
implements MediaSource {
    protected transient MediaSink otherParty;
    private SyncSource syncSource;
    private ReentrantLock state = new ReentrantLock();
    private long packetsTransmitted;
    private long bytesTransmitted;
    private volatile boolean started;
    private NotifyEvent evtStarted;
    private NotifyEvent evtCompleted;
    private NotifyEvent evtStopped;
    protected Logger logger = Logger.getLogger(this.getClass());
    private volatile long timestamp = 0L;
    private long sequenceNumber = 1L;
    private long duration = -1L;

    public AbstractSource(String name) {
        super(name);
        this.evtStarted = new NotifyEventImpl(this, 10000, "Started");
        this.evtCompleted = new NotifyEventImpl(this, 20000, "Completed");
        this.evtStopped = new NotifyEventImpl(this, 30000, "Stoped");
    }

    public SyncSource getSyncSource() {
        return this.syncSource;
    }

    public long getMediaTime() {
        return this.timestamp;
    }

    public void setMediaTime(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setSyncSource(SyncSource syncSource) {
        this.syncSource = syncSource;
    }

    protected void beforeStart() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.state.lock();
        try {
            if (this.started) {
                return;
            }
            this.started = true;
            this.timestamp = 0L;
            this.sequenceNumber = 0L;
            this.beforeStart();
            if (this.syncSource == null) {
                throw new IllegalStateException("No source of synchronization: " + this);
            }
            if (this.otherParty != null && !this.otherParty.isStarted()) {
                this.otherParty.start();
            }
            this.syncSource.sync((MediaSource)this);
            this.started();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.started = false;
            this.failed(10001, e);
        }
        finally {
            this.state.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.state.lock();
        try {
            this.started = false;
            this.syncSource.unsync((MediaSource)this);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(this + " stopped"));
            }
            if (this.otherParty != null && this.otherParty.isStarted()) {
                this.otherParty.stop();
            }
            this.stopped();
            this.afterStop();
            this.timestamp = 0L;
        }
        finally {
            this.state.unlock();
        }
    }

    public void cancel() {
        this.stop();
    }

    public boolean isActive() {
        return this.started;
    }

    public void afterStop() {
    }

    public boolean isMultipleConnectionsAllowed() {
        return false;
    }

    public void setPreffered(Format format) {
        this.format = format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(MediaSink otherParty) {
        this.state.lock();
        try {
            if (otherParty == null) {
                throw new IllegalArgumentException("Other party can not be null");
            }
            if (!(otherParty instanceof AbstractSink)) {
                throw new IllegalArgumentException("Can not connect: " + otherParty + " does not extends AbstractSink");
            }
            if (otherParty.isMultipleConnectionsAllowed()) {
                otherParty.connect((MediaSource)this);
                return;
            }
            AbstractSink sink = (AbstractSink)otherParty;
            Collection<Format> subset = this.subset(this.getFormats(), otherParty.getFormats());
            if (subset.isEmpty()) {
                throw new IllegalArgumentException("Format missmatch");
            }
            Format preffered = sink.getPreffered(subset);
            if (preffered != null) {
                this.setPreffered(preffered);
            }
            sink.otherParty = this;
            this.otherParty = sink;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(this + " is connected to " + otherParty));
            }
        }
        finally {
            this.state.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(MediaSink otherParty) {
        this.state.lock();
        try {
            if (otherParty == null) {
                throw new IllegalArgumentException("Other party can not be null");
            }
            if (!(otherParty instanceof AbstractSink)) {
                throw new IllegalArgumentException("Can not disconnect: " + otherParty + " is not connected");
            }
            if (otherParty.isMultipleConnectionsAllowed()) {
                otherParty.disconnect((MediaSource)this);
                return;
            }
            if (otherParty != this.otherParty) {
                throw new IllegalArgumentException("Can not disconnect: " + otherParty + " is not connected");
            }
            AbstractSink sink = (AbstractSink)otherParty;
            this.setPreffered(null);
            sink.getPreffered(null);
            sink.otherParty = null;
            this.otherParty = null;
        }
        finally {
            this.state.unlock();
        }
    }

    public void connect(Inlet inlet) {
        this.connect(inlet.getInput());
    }

    public void disconnect(Inlet inlet) {
        this.disconnect(inlet.getInput());
    }

    public boolean isConnected() {
        return this.otherParty != null;
    }

    public boolean isStarted() {
        return this.started;
    }

    public abstract void evolve(Buffer var1, long var2);

    protected String getSupportedFormatList() {
        String s = "";
        if (this.otherParty != null) {
            Format[] formats = this.otherParty.getFormats();
            for (int i = 0; i < formats.length; ++i) {
                s = s + formats[i] + ";";
            }
        }
        return s;
    }

    public int perform() {
        Buffer buffer = new Buffer();
        buffer.setFormat(this.format);
        this.evolve(buffer, this.timestamp);
        this.sequenceNumber = this.inc(this.sequenceNumber);
        buffer.setTimeStamp(this.timestamp);
        buffer.setSequenceNumber(this.sequenceNumber);
        if (buffer.isDiscard()) {
            return (int)buffer.getDuration();
        }
        this.timestamp += buffer.getDuration();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(this + " sending " + buffer + " to " + this.otherParty));
        }
        if (this.otherParty == null) {
            return (int)buffer.getDuration();
        }
        try {
            if (buffer.getLength() > 0) {
                this.otherParty.receive(buffer);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Can not deliver packet to " + this.otherParty), (Throwable)e);
            this.failed(10002, e);
        }
        ++this.packetsTransmitted;
        this.bytesTransmitted += (long)buffer.getLength();
        if (this.duration > 0L && this.timestamp >= this.duration) {
            buffer.setEOM(true);
        }
        if (buffer.isEOM()) {
            this.completed();
            return -1;
        }
        return (int)buffer.getDuration();
    }

    protected void started() {
        this.sendEvent(this.evtStarted);
    }

    protected void failed(int eventID, Exception e) {
        FailureEventImpl failed = new FailureEventImpl((BaseComponent)this, eventID, e);
        this.syncSource.unsync((MediaSource)this);
        this.stop();
        this.sendEvent(failed);
    }

    protected void completed() {
        this.syncSource.unsync((MediaSource)this);
        System.out.println("Stopping " + this);
        this.started = false;
        this.sendEvent(this.evtCompleted);
    }

    protected void stopped() {
        this.sendEvent(this.evtStopped);
    }

    public long getPacketsTransmitted() {
        return this.packetsTransmitted;
    }

    public long getBytesTransmitted() {
        return this.bytesTransmitted;
    }

    @Override
    public void resetStats() {
        this.packetsTransmitted = 0L;
        this.bytesTransmitted = 0L;
    }

    private long inc(long v) {
        if (v == Long.MAX_VALUE) {
            v = -1L;
        }
        return ++v;
    }

    @Override
    public <T> T getInterface(Class<T> interfaceType) {
        return null;
    }
}

