/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl;

import java.util.Collection;
import java.util.HashMap;
import org.mobicents.media.MediaSink;
import org.mobicents.media.server.impl.AbstractSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSourceSet
extends AbstractSource {
    private HashMap<String, AbstractSource> sources = new HashMap();

    public AbstractSourceSet(String name) {
        super(name);
    }

    public Collection<AbstractSource> getStreams() {
        return this.sources.values();
    }

    @Override
    public boolean isMultipleConnectionsAllowed() {
        return true;
    }

    @Override
    public void start() {
        Collection<AbstractSource> streams = this.sources.values();
    }

    @Override
    public void connect(MediaSink sink) {
        if (sink == null) {
            throw new IllegalArgumentException("Other party can not be nul");
        }
        AbstractSource source = this.createSource(sink);
        source.connect(sink);
        this.sources.put(sink.getId(), source);
    }

    @Override
    public void disconnect(MediaSink otherParty) {
        AbstractSource source = this.sources.remove(otherParty.getId());
        if (source == null) {
            throw new IllegalArgumentException(otherParty + " is not connected to " + this);
        }
        source.stop();
        source.disconnect(otherParty);
    }

    public abstract AbstractSource createSource(MediaSink var1);

    public abstract void destroySource(AbstractSource var1);

    public int getActiveSourceCount() {
        return this.sources.size();
    }
}

