/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.clock;

import java.util.HashMap;
import org.mobicents.media.MediaSource;
import org.mobicents.media.server.impl.clock.LocalTask;
import org.mobicents.media.server.impl.clock.Scheduler;
import org.mobicents.media.server.spi.clock.Task;
import org.mobicents.media.server.spi.clock.Timer;
import org.mobicents.media.server.spi.clock.TimerTask;

public class TimerImpl
implements Timer {
    private Scheduler scheduler = new Scheduler();
    private HashMap<String, LocalTask> tasks = new HashMap();

    public int getHeartBeat() {
        return 1;
    }

    public void setHeartBeat(int heartBeat) {
    }

    public long getTimestamp() {
        return System.currentTimeMillis();
    }

    public void sync(MediaSource mediaSource) throws IllegalArgumentException {
        LocalTask task = this.scheduler.execute((Task)mediaSource);
        this.tasks.put(mediaSource.getId(), task);
    }

    public TimerTask sync(Task task) {
        return this.scheduler.execute(task);
    }

    public void unsync(MediaSource mediaSource) {
        LocalTask task = this.tasks.remove(mediaSource.getId());
        if (task != null) {
            task.cancel();
        }
    }

    public void start() {
        this.scheduler.start();
    }

    public void stop() {
        this.scheduler.stop();
    }
}

