/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.dsp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.MediaSink;
import org.mobicents.media.MediaSource;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.AbstractSource;
import org.mobicents.media.server.impl.BaseComponent;
import org.mobicents.media.server.spi.SyncSource;
import org.mobicents.media.server.spi.clock.Task;
import org.mobicents.media.server.spi.clock.TimerTask;
import org.mobicents.media.server.spi.dsp.Codec;
import org.mobicents.media.server.spi.dsp.SignalingProcessor;

public class Processor
extends BaseComponent
implements SignalingProcessor {
    private Input input;
    private Output output;
    private transient ArrayList<Codec> codecs = new ArrayList();
    private Codec codec;
    private Buffer buff;
    private long timestamp;

    public Processor(String name) {
        super(name);
        this.input = new Input(name);
        this.output = new Output(name);
        this.output.setSyncSource(this.input);
    }

    protected void add(Codec codec) {
        this.codecs.add(codec);
    }

    public Codec getActiveCodec() {
        return this.codec;
    }

    public MediaSink getInput() {
        return this.input;
    }

    public MediaSource getOutput() {
        return this.output;
    }

    public void connect(MediaSource source) {
        this.input.connect(source);
    }

    public void disconnect(MediaSource source) {
        this.input.disconnect(source);
    }

    public void connect(MediaSink sink) {
        this.output.connect(sink);
    }

    public void disconnect(MediaSink sink) {
        this.output.disconnect(sink);
    }

    public void start() {
        if (!this.input.isStarted()) {
            this.input.start();
        }
    }

    public void stop() {
        if (this.input.isStarted()) {
            this.input.stop();
        }
    }

    private boolean contains(Format[] list, int count, Format item) {
        for (int i = 0; i < count; ++i) {
            if (!list[i].matches(item)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Output
    extends AbstractSource {
        private volatile boolean started;

        public Output(String name) {
            super(name + ".output");
            this.started = false;
        }

        protected Format[] getOtherPartyFormats() {
            return this.otherParty != null ? this.otherParty.getFormats() : new Format[]{};
        }

        @Override
        public boolean isStarted() {
            return this.started;
        }

        @Override
        public void start() {
            this.started = true;
            if (!Processor.this.input.isStarted()) {
                Processor.this.input.start();
            }
            super.start();
        }

        @Override
        public void stop() {
            this.started = false;
            if (Processor.this.input.isStarted()) {
                Processor.this.input.stop();
            }
            super.stop();
        }

        public Format getOtherPartyPreffered(Collection<Format> set) {
            return ((AbstractSink)this.otherParty).getPreffered(set);
        }

        @Override
        public void setPreffered(Format fmt) {
            Format[] supported;
            super.setPreffered(fmt);
            if (!Processor.this.input.isConnected()) {
                return;
            }
            for (Format f : supported = Processor.this.input.getOtherPartyFormats()) {
                if (!f.matches(fmt)) continue;
                Processor.this.input.assignPreffered(fmt);
                return;
            }
            for (Codec c : Processor.this.codecs) {
                if (!c.getSupportedOutputFormat().matches(fmt)) continue;
                for (Format f : supported) {
                    if (!f.matches(c.getSupportedInputFormat())) continue;
                    System.out.println("Assigned codec=" + Processor.this.codec);
                    Processor.this.codec = c;
                    Processor.this.input.assignPreffered(f);
                    return;
                }
            }
            Processor.this.codec = null;
        }

        public Format[] getFormats() {
            Format[] formats;
            Format[] formatArray;
            if (!Processor.this.input.isConnected()) {
                return new Format[]{Format.ANY};
            }
            if (Processor.this.input.getFormat() != null) {
                Format[] formatArray2 = new Format[1];
                formatArray = formatArray2;
                formatArray2[0] = Processor.this.input.getFormat();
            } else {
                formatArray = formats = Processor.this.input.getOtherPartyFormats();
            }
            if (formats.length == 1 && formats[0] == Format.ANY) {
                return new Format[]{Format.ANY};
            }
            Format[] extended = new Format[20];
            int count = 0;
            for (Format f : formats) {
                extended[count++] = f;
                for (Codec codec : Processor.this.codecs) {
                    if (!codec.getSupportedInputFormat().matches(f) || Processor.this.contains(extended, count, codec.getSupportedOutputFormat())) continue;
                    extended[count++] = codec.getSupportedOutputFormat();
                }
            }
            Format[] res = new Format[count];
            System.arraycopy(extended, 0, res, 0, count);
            return res;
        }

        protected void transmit(Buffer buffer) {
            if (!this.started) {
                buffer.dispose();
                return;
            }
            if (this.otherParty == null) {
                buffer.dispose();
                return;
            }
            if (Processor.this.codec != null) {
                Processor.this.codec.process(buffer);
            }
            if (buffer.getFlags() == 2) {
                buffer.dispose();
                return;
            }
            Processor.this.buff = buffer;
            this.perform();
        }

        @Override
        public void evolve(Buffer buffer, long timestamp) {
            buffer.copy(Processor.this.buff);
        }

        @Override
        public String toString() {
            return "Processor.Output[" + this.getName() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Input
    extends AbstractSink
    implements SyncSource {
        private Format fmt;
        private boolean isAcceptable;
        private volatile boolean started;

        public Input(String name) {
            super(name + ".input");
            this.started = false;
        }

        @Override
        public Format selectPreffered(Collection<Format> set) {
            if (set == null) {
                Processor.this.codec = null;
                return null;
            }
            if (!Processor.this.output.isConnected()) {
                return null;
            }
            Format outFormat = Processor.this.output.getFormat();
            if (outFormat == null) {
                return null;
            }
            for (Format f : set) {
                if (!f.matches(outFormat)) continue;
                return f;
            }
            Processor.this.codec = null;
            for (Codec c : Processor.this.codecs) {
                if (!c.getSupportedOutputFormat().matches(outFormat)) continue;
                for (Format f : set) {
                    if (!c.getSupportedInputFormat().matches(f)) continue;
                    Processor.this.codec = c;
                    System.out.println("Assigned codec=" + Processor.this.codec);
                    return f;
                }
            }
            return null;
        }

        @Override
        public boolean isStarted() {
            return this.started;
        }

        @Override
        public void start() {
            this.started = true;
            if (!Processor.this.output.isStarted()) {
                Processor.this.output.start();
            }
            super.start();
        }

        @Override
        public void stop() {
            this.started = false;
            if (Processor.this.output.isStarted()) {
                Processor.this.output.stop();
            }
            super.stop();
        }

        @Override
        public void onMediaTransfer(Buffer buffer) throws IOException {
            Processor.this.timestamp = buffer.getTimeStamp();
            Processor.this.output.transmit(buffer);
        }

        protected Format[] getOtherPartyFormats() {
            return this.otherParty != null ? this.otherParty.getFormats() : new Format[]{};
        }

        public Format[] getFormats() {
            Format[] formats;
            Format[] formatArray;
            if (!Processor.this.output.isConnected()) {
                return new Format[]{Format.ANY};
            }
            if (Processor.this.output.getFormat() != null) {
                Format[] formatArray2 = new Format[1];
                formatArray = formatArray2;
                formatArray2[0] = Processor.this.output.getFormat();
            } else {
                formatArray = formats = Processor.this.output.getOtherPartyFormats();
            }
            if (formats.length == 1 && formats[0] == Format.ANY) {
                return new Format[]{Format.ANY};
            }
            Format[] extended = new Format[20];
            int count = 0;
            for (Format f : formats) {
                extended[count++] = f;
                for (Codec codec : Processor.this.codecs) {
                    if (!codec.getSupportedOutputFormat().matches(f) || Processor.this.contains(extended, count, codec.getSupportedInputFormat())) continue;
                    extended[count++] = codec.getSupportedInputFormat();
                }
            }
            Format[] res = new Format[count];
            System.arraycopy(extended, 0, res, 0, count);
            return res;
        }

        @Override
        public String toString() {
            return "Processor.Input[" + this.getName() + "]";
        }

        public void sync(MediaSource mediaSource) {
        }

        public void unsync(MediaSource mediaSource) {
        }

        public long getTimestamp() {
            return Processor.this.timestamp;
        }

        public TimerTask sync(Task task) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

